/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.galleries.A_CmsTreeTabDataPreloader;
import org.opencms.ade.galleries.CmsSiteSelectorOptionBuilder;
import org.opencms.ade.galleries.CmsTreeOpenState;
import org.opencms.ade.galleries.Messages;
import org.opencms.ade.galleries.preview.I_CmsPreviewProvider;
import org.opencms.ade.galleries.shared.CmsGalleryConfiguration;
import org.opencms.ade.galleries.shared.CmsGalleryDataBean;
import org.opencms.ade.galleries.shared.CmsGalleryFolderBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.ade.galleries.shared.CmsResourceTypeBean;
import org.opencms.ade.galleries.shared.CmsResultItemBean;
import org.opencms.ade.galleries.shared.CmsSitemapEntryBean;
import org.opencms.ade.galleries.shared.CmsVfsEntryBean;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.ade.galleries.shared.rpc.I_CmsGalleryService;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsResourceManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.galleries.CmsGallerySearchResultList;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsUriSplitter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsGalleryService
extends CmsGwtService
implements I_CmsGalleryService {
    private static final Log LOG = CmsLog.getLog(CmsGalleryService.class);
    private static final long serialVersionUID = 1673026761080584889L;
    CmsResourceManager m_resourceManager;
    private CmsWorkplaceSettings m_workplaceSettings;
    private Locale m_wpLocale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsGalleryDataBean getInitialSettings(HttpServletRequest request, CmsGalleryConfiguration config) throws CmsRpcException {
        CmsGalleryService srv = new CmsGalleryService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsGalleryDataBean result = null;
        try {
            result = srv.getInitialSettings(config);
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsGallerySearchBean getSearch(HttpServletRequest request, CmsGalleryDataBean config) {
        CmsGalleryService srv = new CmsGalleryService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsGallerySearchBean result = null;
        try {
            result = srv.getSearch(config);
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    @Override
    public void deleteResource(String resourcePath) throws CmsRpcException {
        try {
            this.ensureLock(resourcePath);
            this.getCmsObject().deleteResource(resourcePath, CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public List<CmsGalleryFolderBean> getGalleries(List<String> resourceTypes) {
        return this.buildGalleriesList(this.readGalleryInfosByTypeNames(resourceTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmsResultItemBean getInfoForResource(String linkPath, String locale) throws CmsRpcException {
        CmsResultItemBean result;
        block30: {
            result = null;
            CmsObject cms = this.getCmsObject();
            try {
                boolean notFound;
                block32: {
                    if (new CmsUriSplitter(linkPath).getProtocol() != null) {
                        result = new CmsResultItemBean();
                        result.setTitle(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_EXTERNAL_LINK_0"));
                        result.setSubTitle("");
                        result.setType(CmsResourceTypePointer.getStaticTypeName());
                        break block30;
                    }
                    notFound = false;
                    String path = linkPath;
                    String siteRoot = OpenCms.getSiteManager().getSiteRoot(linkPath);
                    String oldSite = cms.getRequestContext().getSiteRoot();
                    try {
                        if (siteRoot != null) {
                            cms.getRequestContext().setSiteRoot(siteRoot);
                            path = cms.getRequestContext().removeSiteRoot(linkPath);
                        }
                        int pos = path.indexOf("?");
                        int anchorPos = path.indexOf(35);
                        if (pos == -1 || anchorPos > -1 && pos > anchorPos) {
                            pos = anchorPos;
                        }
                        if (pos > -1) {
                            path = path.substring(0, pos);
                        }
                        path = OpenCms.getLinkManager().getRootPath(cms, path);
                    }
                    catch (Exception e) {
                        notFound = true;
                    }
                    finally {
                        if (siteRoot != null) {
                            cms.getRequestContext().setSiteRoot(oldSite);
                        }
                    }
                    boolean bl = notFound = notFound || path == null;
                    if (!notFound) {
                        CmsObject rootCms = OpenCms.initCmsObject(cms);
                        rootCms.getRequestContext().setSiteRoot("");
                        try {
                            CmsResource selectedResource = rootCms.readResource(path);
                            if (selectedResource.isFolder()) {
                                result = new CmsResultItemBean();
                                CmsJspNavElement folderNav = new CmsJspNavBuilder(rootCms).getNavigationForResource(selectedResource.getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
                                CmsResource defaultFileResource = null;
                                if (folderNav.isInNavigation() && !folderNav.isNavigationLevel()) {
                                    try {
                                        defaultFileResource = rootCms.readDefaultFile(selectedResource, CmsResourceFilter.ONLY_VISIBLE);
                                    }
                                    catch (Exception e) {
                                        this.log(e.getMessage(), e);
                                    }
                                }
                                if (defaultFileResource != null) {
                                    result.setType(OpenCms.getResourceManager().getResourceType(defaultFileResource).getTypeName());
                                } else {
                                    result.setType(OpenCms.getResourceManager().getResourceType(selectedResource).getTypeName());
                                }
                                String title = folderNav.getProperty("NavText");
                                if (CmsStringUtil.isEmptyOrWhitespaceOnly(title)) {
                                    title = folderNav.getTitle();
                                } else if (CmsStringUtil.isEmptyOrWhitespaceOnly(title) && (title = CmsResource.getName(path)).contains("/")) {
                                    title = title.substring(0, title.indexOf("/"));
                                }
                                result.setTitle(title);
                                try {
                                    String userName = cms.readUser(selectedResource.getUserLastModified()).getFullName();
                                    result.setUserLastModified(userName);
                                }
                                catch (CmsException e) {
                                    this.log(e.getMessage(), e);
                                }
                                Date date = new Date(selectedResource.getDateLastModified());
                                String formattedDate = CmsDateUtil.getDateTime(date, 2, this.getWorkplaceLocale());
                                result.setDateLastModified(formattedDate);
                                break block32;
                            }
                            CmsGallerySearchResult resultItem = null;
                            try {
                                resultItem = CmsGallerySearch.searchByPath(cms, path, CmsLocaleManager.getLocale(locale));
                            }
                            catch (CmsVfsResourceNotFoundException ex) {
                                // empty catch block
                            }
                            boolean bl2 = notFound = resultItem == null;
                            if (!notFound) {
                                result = this.buildSingleSearchResultItem(this.getCmsObject(), resultItem, null);
                            }
                        }
                        catch (CmsException ex) {
                            notFound = true;
                        }
                    }
                }
                if (notFound) {
                    result = new CmsResultItemBean();
                    result.setTitle(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESOURCE_NOT_FOUND_0"));
                    result.setSubTitle("");
                    result.setType("cms_resource_not_found");
                }
            }
            catch (Throwable t) {
                this.error(t);
            }
        }
        return result;
    }

    @Override
    public CmsGalleryDataBean getInitialSettings(CmsGalleryConfiguration conf) throws CmsRpcException {
        CmsGalleryDataBean data = new CmsGalleryDataBean();
        data.setMode(conf.getGalleryMode());
        data.setLocales(this.buildLocalesMap());
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(conf.getLocale())) {
            data.setLocale(conf.getLocale());
        } else {
            data.setLocale(this.getCmsObject().getRequestContext().getLocale().toString());
        }
        data.setVfsRootFolders(this.getRootEntries());
        data.setScope(this.getWorkplaceSettings().getLastSearchScope());
        List<CmsResourceTypeBean> types = null;
        switch (conf.getGalleryMode()) {
            case editor: 
            case view: 
            case widget: {
                data.setCurrentElement(conf.getCurrentElement());
                String referencePath = conf.getReferencePath();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(referencePath)) {
                    referencePath = conf.getGalleryPath();
                }
                data.setReferenceSitePath(referencePath);
                types = this.getResourceTypeBeans(conf.getGalleryMode(), data.getReferenceSitePath(), conf.getResourceTypes());
                data.setTypes(types);
                Map<String, CmsGalleryTypeInfo> galleryTypeInfos = this.readGalleryInfosByTypeBeans(types);
                if (conf.getGalleryTypes() != null) {
                    HashMap<String, CmsGalleryTypeInfo> infos = new HashMap<String, CmsGalleryTypeInfo>();
                    for (int i = 0; i < conf.getGalleryTypes().length; ++i) {
                        CmsGalleryTypeInfo typeInfo = galleryTypeInfos.get(conf.getGalleryTypes()[i]);
                        if (typeInfo == null) continue;
                        infos.put(conf.getGalleryTypes()[i], typeInfo);
                    }
                    galleryTypeInfos = infos;
                }
                data.setGalleries(this.buildGalleriesList(galleryTypeInfos));
                String startGallery = conf.getGalleryPath();
                boolean galleryAvailable = false;
                for (CmsGalleryFolderBean folderBean : data.getGalleries()) {
                    if (!folderBean.getPath().equals(startGallery)) continue;
                    galleryAvailable = true;
                    break;
                }
                data.setStartGallery(galleryAvailable ? startGallery : null);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(conf.getStartFolder())) {
                    try {
                        CmsObject cloneCms = OpenCms.initCmsObject(this.getCmsObject());
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(conf.getStartSite())) {
                            cloneCms.getRequestContext().setSiteRoot(conf.getStartSite());
                        }
                        if (cloneCms.existsResource(conf.getStartFolder(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                            data.setStartFolder(cloneCms.getRequestContext().addSiteRoot(conf.getStartFolder()));
                        }
                    }
                    catch (CmsException e) {
                        this.log(e.getMessage(), e);
                    }
                }
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartGallery()) && !types.isEmpty()) {
                    String lastGallery = this.getWorkplaceSettings().getLastUsedGallery(types.get(0).getTypeId());
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(lastGallery) && !data.getGalleries().isEmpty()) {
                        String galleryTypeName = data.getGalleries().get(0).getType();
                        lastGallery = this.getWorkplaceSettings().getUserSettings().getStartGallery(galleryTypeName, this.getCmsObject());
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(lastGallery) && !"default".equals(lastGallery)) {
                            lastGallery = this.getCmsObject().getRequestContext().removeSiteRoot(lastGallery);
                        }
                    }
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(lastGallery) && this.getCmsObject().existsResource(lastGallery)) {
                        data.setStartGallery(lastGallery);
                    } else {
                        data.setStartGallery(null);
                    }
                }
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartGallery()) && CmsStringUtil.isEmptyOrWhitespaceOnly(data.getCurrentElement()) && CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartFolder()) && data.getTypes().size() > 1) {
                    data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_galleries);
                }
                if (conf.isIncludeFiles()) break;
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_vfstree);
                break;
            }
            case ade: {
                data.setReferenceSitePath(this.getCmsObject().getRequestContext().getUri());
                types = this.getResourceTypeBeans(conf.getGalleryMode(), data.getReferenceSitePath(), conf.getResourceTypes());
                data.setTypes(types);
                Map<String, CmsGalleryTypeInfo> adeGalleryTypeInfos = this.readGalleryInfosByTypeBeans(types);
                data.setGalleries(this.buildGalleriesList(adeGalleryTypeInfos));
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_types);
                break;
            }
        }
        CmsSiteSelectorOptionBuilder optionBuilder = new CmsSiteSelectorOptionBuilder(this.getCmsObject());
        optionBuilder.addNormalSites(true, this.getWorkplaceSettings().getUserSettings().getStartFolder());
        optionBuilder.addSharedSite();
        data.setVfsSiteSelectorOptions(optionBuilder.getOptions());
        CmsSiteSelectorOptionBuilder sitemapOptionBuilder = new CmsSiteSelectorOptionBuilder(this.getCmsObject());
        sitemapOptionBuilder.addNormalSites(false, null);
        if (data.getReferenceSitePath() != null) {
            sitemapOptionBuilder.addCurrentSubsite(this.getCmsObject().addSiteRoot(data.getReferenceSitePath()));
        }
        data.setSitemapSiteSelectorOptions(sitemapOptionBuilder.getOptions());
        return data;
    }

    @Override
    public CmsGallerySearchBean getSearch(CmsGalleryDataBean data) {
        CmsGallerySearchBean result = null;
        ArrayList<String> types = new ArrayList<String>();
        for (CmsResourceTypeBean info : data.getTypes()) {
            types.add(info.getType());
        }
        switch (data.getMode()) {
            case editor: 
            case view: 
            case widget: {
                String currentelement = data.getCurrentElement();
                try {
                    CmsSitemapEntryBean sitemapPreloadData = null;
                    CmsVfsEntryBean vfsPreloadData = null;
                    I_CmsGalleryProviderConstants.GalleryTabId startTab = null;
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(currentelement)) {
                        this.log("looking up:" + currentelement);
                        if (currentelement.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                            currentelement = currentelement.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
                            this.log("removed context - result: " + currentelement);
                        }
                        if ((result = this.findResourceInGallery(currentelement, data)) != null) {
                            sitemapPreloadData = result.getSitemapPreloadData();
                            vfsPreloadData = result.getVfsPreloadData();
                        }
                        if (sitemapPreloadData != null) {
                            startTab = I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_sitemap;
                        } else if (vfsPreloadData != null) {
                            startTab = I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_vfstree;
                        }
                    } else {
                        CmsTreeOpenState sitemapState;
                        CmsTreeOpenState vfsState = this.getVfsTreeState(data.getTreeToken());
                        if (vfsState != null) {
                            A_CmsTreeTabDataPreloader<CmsVfsEntryBean> vfsloader = new A_CmsTreeTabDataPreloader<CmsVfsEntryBean>(){

                                @Override
                                protected CmsVfsEntryBean createEntry(CmsObject cms, CmsResource resource) throws CmsException {
                                    String title = cms.readPropertyObject(resource, "Title", false).getValue();
                                    return CmsGalleryService.this.internalCreateVfsEntryBean(resource.getRootPath(), resource.getStructureId(), title, true, CmsGalleryService.this.isEditable(cms, resource), null);
                                }
                            };
                            vfsPreloadData = (CmsVfsEntryBean)vfsloader.preloadData(this.getCmsObject(), this.readAll(vfsState.getOpenItems(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                            startTab = I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_vfstree;
                        }
                        if ((sitemapState = this.getSitemapTreeState(data.getTreeToken())) != null) {
                            A_CmsTreeTabDataPreloader<CmsSitemapEntryBean> sitemaploader = new A_CmsTreeTabDataPreloader<CmsSitemapEntryBean>(){

                                @Override
                                protected CmsSitemapEntryBean createEntry(CmsObject cms, CmsResource resource) throws CmsException {
                                    return CmsGalleryService.this.internalCreateSitemapEntryBean(cms, resource);
                                }

                                @Override
                                protected List<CmsResource> getChildren(CmsResource resource) throws CmsException {
                                    return CmsGalleryService.this.getSitemapSubEntryResources(resource.getRootPath());
                                }
                            };
                            sitemapPreloadData = (CmsSitemapEntryBean)sitemaploader.preloadData(this.getCmsObject(), this.readAll(sitemapState.getOpenItems(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                            if (vfsState == null || vfsState.getTimestamp() < sitemapState.getTimestamp()) {
                                startTab = I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_sitemap;
                            }
                        }
                    }
                    if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                        result = new CmsGallerySearchBean();
                        result.setIgnoreSearchExclude(true);
                        String gallery = data.getStartGallery();
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(gallery)) {
                            ArrayList<String> galleries = new ArrayList<String>();
                            galleries.add(gallery);
                            result.setGalleries(galleries);
                        }
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(data.getStartFolder())) {
                            HashSet<String> folders = new HashSet<String>();
                            folders.add(data.getStartFolder());
                            result.setFolders(folders);
                        }
                        result.setTypes(types);
                        result.setLocale(data.getLocale());
                        result.setScope(CmsGallerySearchScope.everything);
                        result = this.search(result);
                    }
                    result.setSitemapPreloadData(sitemapPreloadData);
                    result.setVfsPreloadData(vfsPreloadData);
                    result.setInitialTabId(startTab);
                    if (types.size() <= 1) break;
                    result.setTypes(null);
                }
                catch (CmsException e) {
                    this.logError(e);
                    result = null;
                }
                break;
            }
        }
        return result;
    }

    @Override
    public CmsGallerySearchBean getSearch(CmsGallerySearchBean searchObj) throws CmsRpcException {
        CmsGallerySearchBean gSearchObj = null;
        try {
            gSearchObj = this.search(searchObj);
            this.getWorkplaceSettings().setLastSearchScope(searchObj.getScope());
            this.setLastOpenedGallery(gSearchObj);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return gSearchObj;
    }

    @Override
    public List<CmsSitemapEntryBean> getSubEntries(String rootPath, boolean isRoot) throws CmsRpcException {
        try {
            return this.getSubEntriesInternal(rootPath, isRoot);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getSubFolders(String rootPath) throws CmsRpcException {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            ArrayList<CmsVfsEntryBean> result = new ArrayList<CmsVfsEntryBean>();
            if (cms.existsResource(rootPath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                CmsResource resource = cms.readResource(rootPath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                List<CmsResource> resources = cms.getSubFolders(resource.getRootPath(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                for (CmsResource res : resources) {
                    String title = cms.readPropertyObject(res, "Title", false).getValue();
                    result.add(this.internalCreateVfsEntryBean(res.getRootPath(), res.getStructureId(), title, false, this.isEditable(cms, res), null));
                }
            }
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsVfsEntryBean loadVfsEntryBean(String path) throws CmsRpcException {
        try {
            String startFolder;
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            if (!cms.existsResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED) && cms.existsResource(startFolder = CmsStringUtil.joinPaths(path, this.getWorkplaceSettings().getUserSettings().getStartFolder()), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                path = startFolder;
            }
            CmsResource optionRes = cms.readResource(path);
            CmsVfsEntryBean entryBean = this.internalCreateVfsEntryBean(path, optionRes.getStructureId(), path, true, this.isEditable(cms, optionRes), null);
            return entryBean;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public void saveTreeOpenState(String treeName, String treeToken, String siteRoot, Set<CmsUUID> openItems) throws CmsRpcException {
        try {
            HttpServletRequest request = this.getRequest();
            HttpSession session = request.getSession();
            String attributeName = this.getTreeOpenStateAttributeName(treeName, treeToken);
            if (openItems.isEmpty()) {
                CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
                cms.getRequestContext().setSiteRoot("");
                CmsResource resource = cms.readResource(siteRoot);
                openItems = Sets.newHashSet((Object[])new CmsUUID[]{resource.getStructureId()});
            }
            CmsTreeOpenState treeState = new CmsTreeOpenState(treeName, siteRoot, openItems);
            session.setAttribute(attributeName, (Object)treeState);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void updateIndex() throws CmsRpcException {
        try {
            OpenCms.getSearchManager().updateOfflineIndexes(30000L);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    protected List<CmsResource> getSitemapSubEntryResources(String rootPath) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(this.getCmsObject());
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        rootCms.getRequestContext().setSiteRoot("");
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(rootCms);
        for (CmsJspNavElement navElement : navBuilder.getNavigationForFolder(rootPath, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE)) {
            if (navElement == null || !navElement.isInNavigation()) continue;
            result.add(navElement.getResource());
        }
        return result;
    }

    protected List<CmsSitemapEntryBean> getSubEntriesInternal(String rootPath, boolean isRoot) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(this.getCmsObject());
        rootCms.getRequestContext().setSiteRoot("");
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(rootCms);
        ArrayList<CmsSitemapEntryBean> result = new ArrayList<CmsSitemapEntryBean>();
        for (CmsJspNavElement navElement : navBuilder.getNavigationForFolder(rootPath, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE)) {
            if (navElement == null || !navElement.isInNavigation()) continue;
            result.add(this.prepareSitemapEntry(rootCms, navElement, false));
        }
        if (isRoot) {
            CmsJspNavElement navElement = navBuilder.getNavigationForResource(rootPath, CmsResourceFilter.ONLY_VISIBLE);
            if (navElement == null) {
                return result;
            }
            CmsSitemapEntryBean root = this.prepareSitemapEntry(rootCms, navElement, isRoot);
            root.setChildren(result);
            return Collections.singletonList(root);
        }
        return result;
    }

    protected boolean isSitemapEntry(CmsObject cms, CmsResource resource) throws CmsException {
        CmsResource parent;
        CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED;
        ArrayList<CmsResource> ancestors = new ArrayList<CmsResource>();
        CmsResource currentResource = resource;
        String siteRoot = OpenCms.getSiteManager().getSiteRoot(resource.getRootPath());
        if (CmsStringUtil.isEmpty(siteRoot)) {
            return false;
        }
        while ((parent = cms.readParentFolder(currentResource.getStructureId())) != null && cms.existsResource(parent.getStructureId(), filter)) {
            ancestors.add(parent);
            if (CmsStringUtil.comparePaths(siteRoot, parent.getRootPath())) break;
            currentResource = parent;
        }
        Collections.reverse(ancestors);
        boolean first = true;
        for (CmsResource ancestor : ancestors) {
            if (first ? null == OpenCms.getSiteManager().getSiteRoot(ancestor.getRootPath()) : !this.hasNavigationProperty(cms, ancestor)) {
                return false;
            }
            first = false;
        }
        if (resource.isFile()) {
            if (ancestors.isEmpty()) {
                return false;
            }
            CmsResource defaultFile = cms.readDefaultFile((CmsResource)ancestors.get(ancestors.size() - 1), filter);
            if (!resource.equals(defaultFile)) {
                return false;
            }
        } else if (!this.hasNavigationProperty(cms, resource)) {
            return false;
        }
        return true;
    }

    protected List<CmsResource> readAll(Collection<CmsUUID> structureIds, CmsResourceFilter filter) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsUUID id : structureIds) {
            try {
                result.add(this.getCmsObject().readResource(id, filter));
            }
            catch (CmsException e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    CmsTreeOpenState getSitemapTreeState(String treeToken) {
        return (CmsTreeOpenState)this.getRequest().getSession().getAttribute(this.getTreeOpenStateAttributeName("sitemap", treeToken));
    }

    CmsTreeOpenState getVfsTreeState(String treeToken) {
        return (CmsTreeOpenState)this.getRequest().getSession().getAttribute(this.getTreeOpenStateAttributeName("vfs", treeToken));
    }

    CmsSitemapEntryBean internalCreateSitemapEntryBean(CmsObject cms, CmsResource resource) throws CmsException {
        cms = OpenCms.initCmsObject(cms);
        cms.getRequestContext().setSiteRoot("");
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(cms);
        CmsJspNavElement entry = navBuilder.getNavigationForResource(resource.getRootPath());
        if (entry == null) {
            return null;
        }
        return this.prepareSitemapEntry(cms, entry, false);
    }

    CmsVfsEntryBean internalCreateVfsEntryBean(String rootPath, CmsUUID structureId, String title, boolean isRoot, boolean isEditable, List<CmsVfsEntryBean> children) {
        String tempSiteRoot;
        CmsVfsEntryBean result = new CmsVfsEntryBean(rootPath, structureId, title, isRoot, isEditable, children);
        String siteRoot = null;
        siteRoot = OpenCms.getSiteManager().startsWithShared(rootPath) ? OpenCms.getSiteManager().getSharedFolder() : ((tempSiteRoot = OpenCms.getSiteManager().getSiteRoot(rootPath)) != null ? tempSiteRoot : "");
        result.setSiteRoot(siteRoot);
        return result;
    }

    boolean isEditable(CmsObject cms, CmsResource resource) {
        try {
            return cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
        }
        catch (CmsException e) {
            return false;
        }
    }

    private void addGalleriesForType(Map<String, CmsGalleryTypeInfo> galleryTypeInfos, String typeName) throws CmsLoaderException {
        I_CmsResourceType contentType = this.getResourceManager().getResourceType(typeName);
        for (I_CmsResourceType galleryType : contentType.getGalleryTypes()) {
            try {
                CmsGalleryTypeInfo typeInfo;
                if (galleryTypeInfos.containsKey(galleryType.getTypeName())) {
                    typeInfo = galleryTypeInfos.get(galleryType.getTypeName());
                    typeInfo.addContentType(contentType);
                    continue;
                }
                typeInfo = new CmsGalleryTypeInfo(galleryType, contentType, this.getGalleriesByType(galleryType.getTypeId()));
                galleryTypeInfos.put(galleryType.getTypeName(), typeInfo);
            }
            catch (CmsException e) {
                this.logError(e);
            }
        }
    }

    private List<CmsGalleryFolderBean> buildGalleriesList(Map<String, CmsGalleryTypeInfo> galleryTypes) {
        ArrayList<CmsGalleryFolderBean> list = new ArrayList<CmsGalleryFolderBean>();
        if (galleryTypes == null) {
            return list;
        }
        for (Map.Entry<String, CmsGalleryTypeInfo> ent : galleryTypes.entrySet()) {
            CmsGalleryTypeInfo tInfo = ent.getValue();
            ArrayList<String> contentTypes = new ArrayList<String>();
            Iterator<I_CmsResourceType> it = tInfo.getContentTypes().iterator();
            while (it.hasNext()) {
                contentTypes.add(String.valueOf(it.next().getTypeName()));
            }
            for (CmsResource res : tInfo.getGalleries()) {
                CmsGalleryFolderBean bean = new CmsGalleryFolderBean();
                String sitePath = this.getCmsObject().getSitePath(res);
                String title = "";
                try {
                    title = this.getCmsObject().readPropertyObject(sitePath, "Title", false).getValue("");
                }
                catch (CmsException e) {
                    this.logError(e);
                }
                bean.setPath(sitePath);
                bean.setContentTypes(contentTypes);
                bean.setTitle(title);
                bean.setType(tInfo.getResourceType().getTypeName());
                bean.setEditable(this.isEditable(this.getCmsObject(), res));
                list.add(bean);
            }
        }
        return list;
    }

    private Map<String, String> buildLocalesMap() {
        TreeMap<String, String> localesMap = new TreeMap<String, String>();
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            localesMap.put(locale.toString(), locale.getDisplayName(this.getWorkplaceLocale()));
        }
        return localesMap;
    }

    private List<CmsResultItemBean> buildSearchResultList(List<CmsGallerySearchResult> searchResult, CmsGallerySearchResult presetResult) {
        ArrayList<CmsResultItemBean> list = new ArrayList<CmsResultItemBean>();
        if (searchResult == null || searchResult.size() == 0) {
            return list;
        }
        CmsObject cms = this.getCmsObject();
        for (CmsGallerySearchResult sResult : searchResult) {
            try {
                CmsResultItemBean bean = this.buildSingleSearchResultItem(cms, sResult, presetResult);
                list.add(bean);
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
        return list;
    }

    private CmsResultItemBean buildSingleSearchResultItem(CmsObject cms, CmsGallerySearchResult sResult, CmsGallerySearchResult presetResult) throws CmsLoaderException, CmsException, ParseException {
        CmsProperty imageDimensionProp;
        Locale wpLocale = this.getWorkplaceLocale();
        CmsResultItemBean bean = new CmsResultItemBean();
        if (sResult == presetResult) {
            bean.setPreset(true);
        }
        bean.setReleasedAndNotExpired(sResult.isReleaseAndNotExpired(cms));
        String path = sResult.getPath();
        path = cms.getRequestContext().removeSiteRoot(path);
        bean.setPath(path);
        bean.setTitle(CmsStringUtil.isEmptyOrWhitespaceOnly(sResult.getTitle()) ? CmsResource.getName(sResult.getPath()) : sResult.getTitle());
        bean.setType(sResult.getResourceType());
        bean.setClientId(sResult.getStructureId());
        CmsResource resultResource = cms.readResource(new CmsUUID(sResult.getStructureId()), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsVfsService.addLockInfo(cms, resultResource, bean);
        String permalink = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), "/permalink/", sResult.getStructureId().toString());
        bean.setViewLink(permalink);
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(sResult.getResourceType());
        String resourceTypeDisplayName = CmsWorkplaceMessages.getResourceTypeName(wpLocale, type.getTypeName());
        String description = sResult.getDescription();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(description)) {
            bean.setDescription(description);
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DESCRIPTION_0"), description);
        } else {
            bean.setDescription(resourceTypeDisplayName);
        }
        bean.setUserLastModified(sResult.getUserLastModified());
        Date lastModDate = sResult.getDateLastModified();
        String formattedDate = lastModDate != null ? CmsDateUtil.getDateTime(lastModDate, 2, wpLocale) : "";
        bean.setDateLastModified(formattedDate);
        if (!type.getTypeName().equals(CmsResourceTypeImage.getStaticTypeName())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_RESOURCE_TYPE_0"), resourceTypeDisplayName);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(sResult.getExcerpt())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_EXCERPT_0"), sResult.getExcerpt(), "multiLineLabel");
        }
        if (type instanceof CmsResourceTypeImage && !(imageDimensionProp = cms.readPropertyObject(resultResource, "image.size", false)).isNullProperty()) {
            String dimensions = imageDimensionProp.getValue();
            dimensions = dimensions.substring(2).replace(",h:", " x ");
            bean.setDimension(dimensions);
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DIMENSION_0"), dimensions);
        }
        bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_SIZE_0"), sResult.getLength() / 1000 + " kb");
        if (lastModDate != null) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DATE_CHANGED_0"), CmsDateUtil.getDate(lastModDate, 3, this.getWorkplaceLocale()));
        }
        if (sResult.getDateExpired().getTime() != Long.MAX_VALUE && !sResult.getDateExpired().equals(CmsSearchFieldMapping.getDefaultDateExpired())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DATE_EXPIRED_0"), CmsDateUtil.getDate(sResult.getDateExpired(), 3, this.getWorkplaceLocale()));
        }
        bean.setNoEditReson(new CmsResourceUtil(cms, resultResource).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)));
        return bean;
    }

    private List<CmsResourceTypeBean> buildTypesList(List<I_CmsResourceType> types, List<String> creatableTypes) {
        ArrayList<CmsResourceTypeBean> list = new ArrayList<CmsResourceTypeBean>();
        if (types == null) {
            return list;
        }
        Map<I_CmsResourceType, I_CmsPreviewProvider> typeProviderMapping = this.getPreviewProviderForTypes(types);
        for (I_CmsResourceType type : types) {
            try {
                CmsResourceTypeBean bean = this.createTypeBean(type, typeProviderMapping.get(type), creatableTypes.contains(type.getTypeName()));
                list.add(bean);
            }
            catch (Exception e) {
                if (type == null) continue;
                this.log(Messages.get().getBundle(this.getWorkplaceLocale()).key("ERR_BUILD_TYPE_LIST_1", type.getTypeName()), e);
            }
        }
        return list;
    }

    private CmsResourceTypeBean createTypeBean(I_CmsResourceType type, I_CmsPreviewProvider preview, boolean creatable) {
        CmsResourceTypeBean result = new CmsResourceTypeBean();
        result.setType(type.getTypeName());
        result.setTypeId(type.getTypeId());
        Locale wpLocale = this.getWorkplaceLocale();
        result.setTitle(CmsWorkplaceMessages.getResourceTypeName(wpLocale, type.getTypeName()));
        result.setDescription(CmsWorkplaceMessages.getResourceTypeDescription(wpLocale, type.getTypeName()));
        ArrayList<String> galleryNames = new ArrayList<String>();
        for (I_CmsResourceType galleryType : type.getGalleryTypes()) {
            galleryNames.add(galleryType.getTypeName());
        }
        result.setGalleryTypeNames(galleryNames);
        if (preview != null) {
            result.setPreviewProviderName(preview.getPreviewName());
        }
        result.setCreatableType(creatable);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsGallerySearchBean findResourceInGallery(String resourceName, CmsGalleryDataBean data) throws CmsException {
        String resNameWithoutServer;
        CmsResource resource = null;
        int pos = resourceName.indexOf("?");
        String resName = resourceName;
        String query = "";
        if (pos > -1) {
            query = resourceName.substring(pos);
            resName = resourceName.substring(0, pos);
        }
        if ((resNameWithoutServer = OpenCms.getLinkManager().getRootPath(this.getCmsObject(), resName)) != null) {
            resName = resNameWithoutServer;
        }
        CmsObject cms = this.getCmsObject();
        try {
            this.log("reading resource: " + resName);
            resource = cms.readResource(resName, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        }
        catch (CmsException e) {
            String originalSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("");
                resource = cms.readResource(resName, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            }
            catch (CmsException e2) {
                this.logError(e);
                CmsGallerySearchBean cmsGallerySearchBean = null;
                return cmsGallerySearchBean;
            }
            finally {
                cms.getRequestContext().setSiteRoot(originalSiteRoot);
            }
        }
        ArrayList<String> types = new ArrayList<String>();
        String resType = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        types.add(resType);
        CmsGallerySearchBean initialSearchObj = new CmsGallerySearchBean();
        initialSearchObj.setIgnoreSearchExclude(true);
        initialSearchObj.setTypes(types);
        ArrayList<String> galleries = new ArrayList<String>();
        for (CmsGalleryFolderBean gallery : data.getGalleries()) {
            String galleryPath = gallery.getPath();
            String galleryRootPath = cms.addSiteRoot(galleryPath);
            String folderPath = CmsResource.getFolderPath(resName);
            if (!galleryPath.equals(folderPath) && !galleryRootPath.equals(folderPath)) continue;
            galleries.add(gallery.getPath());
            initialSearchObj.setGalleries(galleries);
            break;
        }
        if (galleries.isEmpty()) {
            ArrayList<String> vfsFolders = new ArrayList<String>();
            vfsFolders.add(CmsResource.getFolderPath(resource.getRootPath()));
            initialSearchObj.setFolders(new HashSet<String>(vfsFolders));
        }
        initialSearchObj.setLocale(data.getLocale());
        CmsGallerySearchBean searchObj = new CmsGallerySearchBean(initialSearchObj);
        searchObj.setSortOrder(CmsGallerySearchParameters.CmsGallerySortParam.DEFAULT.toString());
        int currentPage = 1;
        boolean found = false;
        searchObj.setPage(currentPage);
        CmsGallerySearchParameters params = this.prepareSearchParams(searchObj);
        CmsGallerySearch searchBean = new CmsGallerySearch();
        searchBean.init(this.getCmsObject());
        searchBean.setIndex("Gallery Index");
        CmsGallerySearchResultList searchResults = null;
        CmsGallerySearchResultList totalResults = new CmsGallerySearchResultList();
        CmsGallerySearchResult foundItem = null;
        while (!found) {
            params.setResultPage(currentPage);
            searchResults = searchBean.getResult(params);
            ListIterator resultsIt = searchResults.listIterator();
            totalResults.append(searchResults);
            while (resultsIt.hasNext()) {
                CmsGallerySearchResult searchResult = (CmsGallerySearchResult)resultsIt.next();
                if (!searchResult.getPath().equals(resource.getRootPath())) continue;
                found = true;
                foundItem = searchResult;
                break;
            }
            if (found || searchResults.getHitCount() / (currentPage * params.getMatchesPerPage()) < 1) break;
            ++currentPage;
        }
        boolean hasResults = searchResults != null;
        searchResults = totalResults;
        if (found && hasResults) {
            initialSearchObj.setSortOrder(params.getSortOrder().name());
            initialSearchObj.setResultCount(searchResults.getHitCount());
            initialSearchObj.setPage(params.getResultPage());
            initialSearchObj.setResults(this.buildSearchResultList(searchResults, foundItem));
            initialSearchObj.setPage(1);
            initialSearchObj.setLastPage(currentPage);
            initialSearchObj.setTabId(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results.name());
            initialSearchObj.setResourcePath(resName + query);
            initialSearchObj.setResourceType(resType);
        } else {
            this.log("could not find selected resource");
        }
        if (resource != null) {
            A_CmsTreeTabDataPreloader loader;
            if (this.isSitemapEntry(cms, resource)) {
                loader = new A_CmsTreeTabDataPreloader<CmsSitemapEntryBean>(){

                    @Override
                    protected CmsSitemapEntryBean createEntry(CmsObject innerCms, CmsResource innerResource) throws CmsException {
                        return CmsGalleryService.this.internalCreateSitemapEntryBean(innerCms, innerResource);
                    }
                };
                CmsSitemapEntryBean entryBean = (CmsSitemapEntryBean)loader.preloadData(cms, Collections.singletonList(resource));
                initialSearchObj.setSitemapPreloadData(entryBean);
            } else if (resource.isFolder()) {
                loader = new A_CmsTreeTabDataPreloader<CmsVfsEntryBean>(){

                    @Override
                    protected CmsVfsEntryBean createEntry(CmsObject innerCms, CmsResource innerResource) throws CmsException {
                        String title = innerCms.readPropertyObject(innerResource, "Title", false).getValue();
                        return CmsGalleryService.this.internalCreateVfsEntryBean(innerResource.getRootPath(), innerResource.getStructureId(), title, true, CmsGalleryService.this.isEditable(innerCms, innerResource), null);
                    }
                };
                CmsVfsEntryBean entryBean = (CmsVfsEntryBean)loader.preloadData(cms, Collections.singletonList(resource));
                initialSearchObj.setVfsPreloadData(entryBean);
            }
        }
        return initialSearchObj;
    }

    private List<CmsResource> getGalleriesByType(int galleryTypeId) throws CmsException {
        ArrayList<CmsResource> galleries = new ArrayList();
        galleries = this.getCmsObject().readResources("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
        String siteRoot = this.getCmsObject().getRequestContext().getSiteRoot();
        if (!siteRoot.equals("")) {
            List<CmsResource> systemGalleries = null;
            systemGalleries = this.getCmsObject().readResources("/system/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
            if (systemGalleries != null) {
                galleries.addAll(systemGalleries);
            }
        }
        if (!OpenCms.getSiteManager().isSharedFolder(siteRoot)) {
            String shared = OpenCms.getSiteManager().getSharedFolder();
            List<CmsResource> sharedGalleries = this.getCmsObject().readResources(shared, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
            if (sharedGalleries != null) {
                galleries.addAll(sharedGalleries);
            }
        }
        return galleries;
    }

    private Map<I_CmsResourceType, I_CmsPreviewProvider> getPreviewProviderForTypes(List<I_CmsResourceType> types) {
        HashMap<String, I_CmsPreviewProvider> previewProviderMap = new HashMap<String, I_CmsPreviewProvider>();
        HashMap<I_CmsResourceType, I_CmsPreviewProvider> typeProviderMapping = new HashMap<I_CmsResourceType, I_CmsPreviewProvider>();
        for (I_CmsResourceType type : types) {
            String providerClass = type.getGalleryPreviewProvider();
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(providerClass)) continue;
            providerClass = providerClass.trim();
            try {
                if (previewProviderMap.containsKey(providerClass)) {
                    typeProviderMapping.put(type, (I_CmsPreviewProvider)previewProviderMap.get(providerClass));
                    continue;
                }
                I_CmsPreviewProvider previewProvider = (I_CmsPreviewProvider)Class.forName(providerClass).newInstance();
                previewProviderMap.put(providerClass, previewProvider);
                typeProviderMapping.put(type, previewProvider);
            }
            catch (Exception e) {
                this.logError(new CmsException(Messages.get().container("ERR_INSTANCING_PREVIEW_PROVIDER_2", providerClass, type.getTypeName()), (Throwable)e));
            }
        }
        return typeProviderMapping;
    }

    private CmsResourceManager getResourceManager() {
        if (this.m_resourceManager == null) {
            this.m_resourceManager = OpenCms.getResourceManager();
        }
        return this.m_resourceManager;
    }

    private List<CmsResourceTypeBean> getResourceTypeBeans(I_CmsGalleryProviderConstants.GalleryMode galleryMode, String referenceSitePath, List<String> resourceTypesList) throws CmsRpcException {
        List<I_CmsResourceType> resourceTypes = null;
        List<String> creatableTypes = null;
        switch (galleryMode) {
            case editor: 
            case view: 
            case widget: {
                resourceTypes = this.readResourceTypesFromRequest(resourceTypesList);
                creatableTypes = Collections.emptyList();
                break;
            }
            case ade: {
                resourceTypes = new ArrayList();
                creatableTypes = new ArrayList();
                try {
                    String typeName;
                    CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), this.getCmsObject().getRequestContext().addSiteRoot(this.getCmsObject().getRequestContext().getUri()));
                    for (CmsResourceTypeConfig typeConfig : config.getResourceTypes()) {
                        if (!typeConfig.checkViewable(this.getCmsObject(), referenceSitePath)) continue;
                        typeName = typeConfig.getTypeName();
                        resourceTypes.add(this.getResourceManager().getResourceType(typeName));
                    }
                    for (CmsResourceTypeConfig typeConfig : config.getCreatableTypes(this.getCmsObject())) {
                        typeName = typeConfig.getTypeName();
                        creatableTypes.add(typeName);
                    }
                    break;
                }
                catch (CmsException e) {
                    this.error(e);
                    break;
                }
            }
            default: {
                resourceTypes = Collections.emptyList();
                creatableTypes = Collections.emptyList();
            }
        }
        return this.buildTypesList(resourceTypes, creatableTypes);
    }

    private List<CmsVfsEntryBean> getRootEntries() throws CmsRpcException {
        ArrayList<CmsVfsEntryBean> rootFolders = new ArrayList<CmsVfsEntryBean>();
        CmsObject cms = this.getCmsObject();
        try {
            String path = "/";
            if (!cms.existsResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                String startFolder = this.getWorkplaceSettings().getUserSettings().getStartFolder();
                path = cms.existsResource(startFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED) ? startFolder : null;
            }
            if (path != null) {
                CmsResource rootFolderResource = this.getCmsObject().readResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                String title = cms.readPropertyObject(path, "Title", false).getValue();
                rootFolders.add(this.internalCreateVfsEntryBean(rootFolderResource.getRootPath(), rootFolderResource.getStructureId(), title, true, this.isEditable(this.getCmsObject(), rootFolderResource), null));
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
        return rootFolders;
    }

    private String getTreeOpenStateAttributeName(String treeName, String treeToken) {
        return "tree_" + treeName + "_" + treeToken;
    }

    private Locale getWorkplaceLocale() {
        if (this.m_wpLocale == null) {
            this.m_wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        }
        return this.m_wpLocale;
    }

    private CmsWorkplaceSettings getWorkplaceSettings() {
        if (this.m_workplaceSettings == null) {
            this.m_workplaceSettings = (CmsWorkplaceSettings)this.getRequest().getSession().getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS");
            if (this.m_workplaceSettings == null) {
                this.m_workplaceSettings = CmsWorkplace.initWorkplaceSettings(this.getCmsObject(), null, false);
                this.getRequest().getSession().setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)this.m_workplaceSettings);
            }
        }
        return this.m_workplaceSettings;
    }

    private boolean hasNavigationProperty(CmsObject cms, CmsResource resource) throws CmsException {
        List<CmsProperty> props = cms.readPropertyObjects(resource, false);
        Map<String, String> propMap = CmsProperty.toMap(props);
        return propMap.containsKey("NavPos") || propMap.containsKey("NavText");
    }

    private CmsGallerySearchParameters prepareSearchParams(CmsGallerySearchBean searchData) {
        CmsGallerySearchParameters.CmsGallerySortParam sortOrder;
        CmsGallerySearchParameters params = new CmsGallerySearchParameters();
        CmsObject cms = this.getCmsObject();
        if (searchData.getTypes() != null) {
            params.setResourceTypes(searchData.getTypes());
        }
        if (searchData.getGalleries() != null) {
            ArrayList<String> paramGalleries = new ArrayList<String>();
            for (String gallerySitePath : searchData.getGalleries()) {
                paramGalleries.add(cms.getRequestContext().addSiteRoot(gallerySitePath));
            }
            params.setGalleries(paramGalleries);
        }
        String temp = searchData.getSortOrder();
        try {
            sortOrder = CmsGallerySearchParameters.CmsGallerySortParam.valueOf(temp);
        }
        catch (Exception e) {
            sortOrder = CmsGallerySearchParameters.CmsGallerySortParam.DEFAULT;
        }
        params.setSortOrder(sortOrder);
        if (searchData.getScope() == null) {
            params.setScope(CmsGallerySearchScope.everything);
        } else {
            params.setScope(searchData.getScope());
        }
        params.setReferencePath(searchData.getReferencePath());
        params.setFolders(new ArrayList<String>(searchData.getFolders()));
        if (searchData.getCategories() != null) {
            params.setCategories(searchData.getCategories());
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(searchData.getQuery())) {
            params.setSearchWords(searchData.getQuery());
        }
        int page = searchData.getPage();
        params.setResultPage(page);
        String locale = searchData.getLocale();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(locale)) {
            locale = this.getCmsObject().getRequestContext().getLocale().toString();
        }
        params.setSearchLocale(locale);
        params.setMatchesPerPage(searchData.getMatchesPerPage());
        long dateCreatedStart = searchData.getDateCreatedStart();
        long dateCreatedEnd = searchData.getDateCreatedEnd();
        long dateModifiedStart = searchData.getDateModifiedStart();
        long dateModifiedEnd = searchData.getDateModifiedEnd();
        if (dateCreatedStart != -1L && dateCreatedEnd != -1L) {
            params.setDateCreatedTimeRange(dateCreatedStart, dateCreatedEnd);
        } else if (dateCreatedStart != -1L) {
            params.setDateCreatedTimeRange(dateCreatedStart, Long.MAX_VALUE);
        } else if (dateCreatedEnd != -1L) {
            params.setDateCreatedTimeRange(Long.MIN_VALUE, dateCreatedEnd);
        }
        if (dateModifiedStart != -1L && dateModifiedEnd != -1L) {
            params.setDateLastModifiedTimeRange(dateModifiedStart, dateModifiedEnd);
        } else if (dateModifiedStart != -1L) {
            params.setDateLastModifiedTimeRange(dateModifiedStart, Long.MAX_VALUE);
        } else if (dateModifiedEnd != -1L) {
            params.setDateLastModifiedTimeRange(Long.MIN_VALUE, dateModifiedEnd);
        }
        params.setIgnoreSearchExclude(searchData.isIgnoreSearchExclude());
        return params;
    }

    private CmsSitemapEntryBean prepareSitemapEntry(CmsObject cms, CmsJspNavElement navElement, boolean isRoot) throws CmsException {
        CmsResource ownResource = navElement.getResource();
        CmsResource defaultFileResource = null;
        if (ownResource.isFolder() && !navElement.isNavigationLevel()) {
            defaultFileResource = cms.readDefaultFile(ownResource, CmsResourceFilter.ONLY_VISIBLE);
        }
        String type = defaultFileResource != null ? OpenCms.getResourceManager().getResourceType(defaultFileResource.getTypeId()).getTypeName() : OpenCms.getResourceManager().getResourceType(ownResource.getTypeId()).getTypeName();
        String title = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(navElement.getProperty("NavText"))) {
            title = navElement.getProperty("NavText");
        } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(navElement.getProperty("Title"))) {
            title = navElement.getProperty("Title");
        } else {
            title = navElement.getFileName();
            if (title.contains("/")) {
                title = title.substring(0, title.indexOf("/"));
            }
        }
        CmsSitemapEntryBean result = new CmsSitemapEntryBean(navElement.getResource().getRootPath(), navElement.getResourceName(), ownResource.getStructureId(), title, type, ownResource.isFolder(), isRoot, navElement.isHiddenNavigationEntry());
        result.setSiteRoot(OpenCms.getSiteManager().getSiteRoot(ownResource.getRootPath()));
        return result;
    }

    private Map<String, CmsGalleryTypeInfo> readGalleryInfosByTypeBeans(List<CmsResourceTypeBean> resourceTypes) {
        HashMap<String, CmsGalleryTypeInfo> galleryTypeInfos = new HashMap<String, CmsGalleryTypeInfo>();
        for (CmsResourceTypeBean typeBean : resourceTypes) {
            try {
                this.addGalleriesForType(galleryTypeInfos, typeBean.getType());
            }
            catch (CmsLoaderException e1) {
                this.logError(e1);
            }
        }
        return galleryTypeInfos;
    }

    private Map<String, CmsGalleryTypeInfo> readGalleryInfosByTypeNames(List<String> resourceTypes) {
        HashMap<String, CmsGalleryTypeInfo> galleryTypeInfos = new HashMap<String, CmsGalleryTypeInfo>();
        for (String typeName : resourceTypes) {
            try {
                this.addGalleriesForType(galleryTypeInfos, typeName);
            }
            catch (CmsLoaderException e1) {
                this.logError(e1);
            }
        }
        return galleryTypeInfos;
    }

    private List<I_CmsResourceType> readResourceTypesFromRequest(List<String> resourceTypes) {
        List<I_CmsResourceType> result = new ArrayList<I_CmsResourceType>();
        if (resourceTypes != null) {
            for (String type : resourceTypes) {
                try {
                    result.add(this.getResourceManager().getResourceType(type.trim()));
                }
                catch (Exception e) {
                    this.logError(e);
                }
            }
        }
        if (result.size() == 0) {
            result = this.getResourceManager().getResourceTypes();
        }
        return result;
    }

    private CmsGallerySearchBean search(CmsGallerySearchBean searchObj) throws CmsException {
        CmsGallerySearchBean searchObjBean = new CmsGallerySearchBean(searchObj);
        if (searchObj == null) {
            return searchObjBean;
        }
        CmsGallerySearchParameters params = this.prepareSearchParams(searchObj);
        CmsGallerySearch searchBean = new CmsGallerySearch();
        if (searchObj.isIncludeExpired()) {
            CmsObject searchCms = OpenCms.initCmsObject(this.getCmsObject());
            searchCms.getRequestContext().setRequestTime(Long.MIN_VALUE);
            searchBean.init(searchCms);
        } else {
            searchBean.init(this.getCmsObject());
        }
        searchBean.setIndex("Gallery Index");
        CmsGallerySearchResultList searchResults = searchBean.getResult(params);
        searchObjBean.setSortOrder(params.getSortOrder().name());
        searchObjBean.setScope(params.getScope());
        searchObjBean.setResultCount(searchResults.getHitCount());
        searchObjBean.setPage(params.getResultPage());
        searchObjBean.setLastPage(params.getResultPage());
        searchObjBean.setResults(this.buildSearchResultList(searchResults, null));
        return searchObjBean;
    }

    private void setLastOpenedGallery(CmsGallerySearchBean searchObject) {
        if (searchObject.getGalleries() != null && searchObject.getGalleries().size() == 1) {
            String galleryPath = searchObject.getGalleries().get(0);
            CmsWorkplaceSettings settings = this.getWorkplaceSettings();
            for (String typeName : searchObject.getTypes()) {
                try {
                    settings.setLastUsedGallery(OpenCms.getResourceManager().getResourceType(typeName).getTypeId(), galleryPath);
                }
                catch (CmsLoaderException e) {
                    this.log(e.getLocalizedMessage(), e);
                }
            }
        }
    }

    protected class CmsGalleryTypeInfo {
        private List<I_CmsResourceType> m_contentTypes;
        private List<CmsResource> m_galleries;
        private I_CmsResourceType m_resourceType;

        protected CmsGalleryTypeInfo(I_CmsResourceType resourceType, I_CmsResourceType contentType, List<CmsResource> galleries) {
            this.m_resourceType = resourceType;
            this.m_contentTypes = new ArrayList<I_CmsResourceType>();
            this.m_contentTypes.add(contentType);
            this.m_galleries = galleries;
        }

        protected void addContentType(I_CmsResourceType type) {
            this.m_contentTypes.add(type);
        }

        protected List<I_CmsResourceType> getContentTypes() {
            return this.m_contentTypes;
        }

        protected List<CmsResource> getGalleries() {
            return this.m_galleries;
        }

        protected I_CmsResourceType getResourceType() {
            return this.m_resourceType;
        }

        protected void setContentTypes(List<I_CmsResourceType> contentTypes) {
            this.m_contentTypes = contentTypes;
        }

        protected void setGalleries(List<CmsResource> galleries) {
            this.m_galleries = galleries;
        }

        protected void setResourceType(I_CmsResourceType resourceType) {
            this.m_resourceType = resourceType;
        }
    }
}

