/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.galleries.ClientMessages;
import org.opencms.ade.galleries.CmsGalleryService;
import org.opencms.ade.galleries.Messages;
import org.opencms.ade.galleries.shared.CmsGalleryConfiguration;
import org.opencms.ade.galleries.shared.CmsGalleryDataBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.ade.galleries.shared.rpc.I_CmsGalleryService;
import org.opencms.ade.upload.CmsUploadActionElement;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsGalleryActionElement
extends CmsGwtActionElement {
    public static final String CMS_MODULE_NAME = "org.opencms.ade.galleries";
    public static final String GWT_MODULE_NAME = "galleries";
    private I_CmsGalleryProviderConstants.GalleryMode m_galleryMode;

    public CmsGalleryActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
        try {
            this.m_galleryMode = I_CmsGalleryProviderConstants.GalleryMode.valueOf(this.getRequest().getParameter("gallerymode").trim());
        }
        catch (Exception e) {
            this.m_galleryMode = I_CmsGalleryProviderConstants.GalleryMode.view;
        }
    }

    @Override
    public String export() throws Exception {
        return this.export(this.m_galleryMode);
    }

    @Override
    public String exportAll() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.export());
        sb.append(this.export());
        sb.append(this.exportCloseLink());
        sb.append(new CmsUploadActionElement(this.getJspContext(), this.getRequest(), this.getResponse()).export());
        sb.append(this.createNoCacheScript(GWT_MODULE_NAME, OpenCms.getModuleManager().getModule(CMS_MODULE_NAME).getVersion().toString()));
        return sb.toString();
    }

    public String exportForContainerpage() throws Exception {
        return this.export(I_CmsGalleryProviderConstants.GalleryMode.ade);
    }

    public String exportWidget() {
        return ClientMessages.get().export(this.getRequest());
    }

    public String getTitle() {
        return Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_GALLERIES_TITLE_0");
    }

    public boolean isEditorMode() {
        return this.m_galleryMode == I_CmsGalleryProviderConstants.GalleryMode.editor;
    }

    public boolean isWidgetMode() {
        return this.m_galleryMode == I_CmsGalleryProviderConstants.GalleryMode.widget;
    }

    private String export(I_CmsGalleryProviderConstants.GalleryMode galleryMode) throws Exception {
        String galleryTypes;
        CmsGalleryConfiguration conf = new CmsGalleryConfiguration();
        conf.setGalleryMode(galleryMode);
        conf.setReferencePath(this.getRequest().getParameter("resource"));
        conf.setGalleryPath(this.getRequest().getParameter("gallerypath"));
        conf.setCurrentElement(this.getRequest().getParameter("currentelement"));
        String resourceTypes = this.getRequest().getParameter("resourcetypes");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resourceTypes)) {
            conf.setResourceTypes(Arrays.asList(resourceTypes.split(",")));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(galleryTypes = this.getRequest().getParameter("gallerytypes"))) {
            conf.setGalleryTypes(galleryTypes.split(","));
        }
        CmsGalleryDataBean data = CmsGalleryService.getInitialSettings(this.getRequest(), conf);
        CmsGallerySearchBean search = null;
        if (I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results.equals((Object)data.getStartTab())) {
            search = CmsGalleryService.getSearch(this.getRequest(), data);
        }
        if (search != null && search.getScope() != null && search.getScope() != data.getScope()) {
            data.setScope(search.getScope());
        } else if (search != null && search.getScope() == null) {
            data.setScope(CmsGallerySearchScope.everything);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ClientMessages.get().export(this.getRequest()));
        sb.append(CmsGalleryActionElement.exportDictionary("cms_gallery_data_bean", I_CmsGalleryService.class.getMethod("getInitialSettings", CmsGalleryConfiguration.class), data));
        sb.append(CmsGalleryActionElement.exportDictionary("cms_gallery_search_bean", I_CmsGalleryService.class.getMethod("getSearch", CmsGalleryDataBean.class), search));
        return sb.toString();
    }

    private String exportCloseLink() {
        String closeLink = null;
        if (this.getRequest().getAttribute("closeLink") != null) {
            closeLink = (String)this.getRequest().getAttribute("closeLink");
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(closeLink)) {
            closeLink = "/system/workplace/views/explorer/explorer_files.jsp";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ").append("closeLink").append(" = '").append(closeLink).append("';");
        CmsGalleryActionElement.wrapScript(sb);
        return sb.toString();
    }
}

