/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.ade.galleries.shared.I_CmsGalleryTreeEntry;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsTreeTabDataPreloader<T extends I_CmsGalleryTreeEntry<T>> {
    private Multimap<CmsResource, CmsResource> m_childMap = ArrayListMultimap.create();
    private CmsObject m_cms;
    private String m_commonRoot;
    private CmsResourceFilter m_filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED;
    private Set<CmsResource> m_knownResources = new HashSet<CmsResource>();
    private CmsResource m_rootResource;

    public T preloadData(CmsObject cms, Collection<CmsResource> openResources) throws CmsException {
        assert (this.m_cms == null) : "Instance can't be used more than once!";
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_cms.getRequestContext().setSiteRoot("");
        this.findRoot(openResources);
        for (CmsResource resource : openResources) {
            this.loadAncestors(resource);
        }
        this.loadChildren();
        return this.createBeans();
    }

    protected abstract T createEntry(CmsObject var1, CmsResource var2) throws CmsException;

    protected void findRoot(Collection<CmsResource> openResources) throws CmsException {
        String siteRoot;
        String commonPath = this.getCommonAncestorPath(openResources);
        CmsSiteManagerImpl siteManager = OpenCms.getSiteManager();
        this.m_commonRoot = siteManager.startsWithShared(commonPath) ? siteManager.getSharedFolder() : ((siteRoot = siteManager.getSiteRoot(CmsStringUtil.joinPaths(commonPath, "/"))) == null ? "/" : siteRoot);
        try {
            this.m_rootResource = this.m_cms.readResource(this.m_commonRoot, this.m_filter);
        }
        catch (CmsVfsResourceNotFoundException e) {
            String currentPath = commonPath;
            String lastWorkingPath = null;
            while (this.m_cms.existsResource(currentPath, this.m_filter)) {
                lastWorkingPath = currentPath;
                currentPath = CmsResource.getParentFolder(currentPath);
            }
            this.m_rootResource = this.m_cms.readResource(lastWorkingPath, this.m_filter);
            this.m_commonRoot = lastWorkingPath;
        }
        this.m_knownResources.add(this.m_rootResource);
    }

    protected List<CmsResource> getChildren(CmsResource resource) throws CmsException {
        return this.m_cms.getSubFolders(resource.getRootPath(), this.m_filter);
    }

    private T createBeans() throws CmsException {
        HashMap<CmsResource, T> beans = new HashMap<CmsResource, T>();
        for (CmsResource cmsResource : this.m_knownResources) {
            T bean = this.createEntry(this.m_cms, cmsResource);
            if (bean == null) continue;
            beans.put(cmsResource, bean);
        }
        for (Map.Entry entry : beans.entrySet()) {
            CmsResource key = (CmsResource)entry.getKey();
            I_CmsGalleryTreeEntry bean = (I_CmsGalleryTreeEntry)entry.getValue();
            for (CmsResource child : this.m_childMap.get((Object)key)) {
                I_CmsGalleryTreeEntry childEntry = (I_CmsGalleryTreeEntry)beans.get(child);
                if (childEntry == null) continue;
                bean.addChild(childEntry);
            }
        }
        return (T)((I_CmsGalleryTreeEntry)beans.get(this.m_rootResource));
    }

    private String getCommonAncestorPath(Collection<CmsResource> resources) {
        if (resources.isEmpty()) {
            return "/";
        }
        String commonPath = null;
        for (CmsResource resource : resources) {
            commonPath = this.getCommonAncestorPath(commonPath, resource.getRootPath());
        }
        return commonPath;
    }

    private String getCommonAncestorPath(String rootPath1, String rootPath2) {
        char char2;
        char char1;
        int i;
        if (rootPath1 == null) {
            return rootPath2;
        }
        if (rootPath2 == null) {
            return rootPath1;
        }
        rootPath1 = CmsStringUtil.joinPaths("/", rootPath1, "/");
        rootPath2 = CmsStringUtil.joinPaths("/", rootPath2, "/");
        int minLength = Math.min(rootPath1.length(), rootPath2.length());
        for (i = 0; i < minLength && (char1 = rootPath1.charAt(i)) == (char2 = rootPath2.charAt(i)); ++i) {
        }
        String result = rootPath1.substring(0, i);
        if ("/".equals(result)) {
            return result;
        }
        int slashIndex = result.lastIndexOf(47);
        result = result.substring(0, slashIndex);
        return result;
    }

    private void loadAncestors(CmsResource resource) throws CmsException {
        CmsResource currentResource = resource;
        while (currentResource != null && this.m_cms.existsResource(currentResource.getStructureId(), this.m_filter) && this.m_knownResources.add(currentResource) && !CmsStringUtil.comparePaths(currentResource.getRootPath(), this.m_commonRoot)) {
            CmsResource parent;
            currentResource = parent = this.m_cms.readParentFolder(currentResource.getStructureId());
        }
    }

    private void loadChildren() throws CmsException {
        for (CmsResource resource : new ArrayList<CmsResource>(this.m_knownResources)) {
            if (!resource.isFolder()) continue;
            List<CmsResource> children = this.getChildren(resource);
            for (CmsResource child : children) {
                this.m_knownResources.add(child);
                this.m_childMap.put((Object)resource, (Object)child);
            }
        }
    }
}

