/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.util.ArrayList;
import java.util.Collection;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.detailpage.I_CmsDetailPageFinder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;

public class CmsSitemapDetailPageFinder
implements I_CmsDetailPageFinder {
    @Override
    public Collection<String> getAllDetailPages(CmsObject cms, int resType) throws CmsException {
        if (!OpenCms.getADEManager().isInitialized()) {
            return new ArrayList<String>();
        }
        String typeName = OpenCms.getResourceManager().getResourceType(resType).getTypeName();
        return OpenCms.getADEManager().getDetailPages(cms, typeName);
    }

    @Override
    public String getDetailPage(CmsObject cms, String rootPath, String linkSource) {
        CmsADEManager manager = OpenCms.getADEManager();
        if (!manager.isInitialized()) {
            return null;
        }
        if (rootPath.endsWith(".jsp") || rootPath.startsWith("/system/workplace/")) {
            return null;
        }
        String result = manager.getDetailPage(cms, rootPath, linkSource);
        if (result == null) {
            return null;
        }
        if (!CmsResource.isFolder(result)) {
            result = CmsResource.getFolderPath(result);
        }
        return result;
    }
}

