/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import com.alkacon.acacia.shared.AttributeConfiguration;
import com.alkacon.acacia.shared.TabInfo;
import com.alkacon.acacia.shared.Type;
import com.alkacon.vie.shared.I_Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.contenteditor.CmsContentService;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.main.OpenCms;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.content.CmsXmlContentTab;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsContentTypeVisitor {
    private Map<String, AttributeConfiguration> m_attributeConfigurations;
    private CmsObject m_cms;
    private I_CmsXmlContentHandler m_contentHandler;
    private CmsFile m_file;
    private Locale m_locale;
    private CmsMultiMessages m_messages;
    private List<I_CmsWidget> m_widgets = new ArrayList<I_CmsWidget>();
    private Map<String, I_Type> m_registeredTypes;
    private List<TabInfo> m_tabInfos;
    private Map<String, CmsExternalWidgetConfiguration> m_widgetConfigurations;

    public CmsContentTypeVisitor(CmsObject cms, CmsFile file, Locale locale) {
        this.m_file = file;
        this.m_cms = cms;
        this.m_locale = locale;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public List<I_CmsWidget> getCollectedWidgets() {
        return Collections.unmodifiableList(this.m_widgets);
    }

    public List<TabInfo> getTabInfos() {
        return this.m_tabInfos;
    }

    public void visitTypes(CmsXmlContentDefinition xmlContentDefinition, Locale messageLocale) {
        this.visitTypes(xmlContentDefinition, messageLocale, false);
    }

    public void visitTypes(CmsXmlContentDefinition xmlContentDefinition, Locale messageLocale, boolean checkWidgetsOnly) {
        this.m_contentHandler = xmlContentDefinition.getContentHandler();
        CmsMessages messages = null;
        this.m_messages = new CmsMultiMessages(messageLocale);
        try {
            messages = OpenCms.getWorkplaceManager().getMessages(messageLocale);
            if (messages != null) {
                this.m_messages.addMessages(messages);
            }
            if ((messages = this.m_contentHandler.getMessages(messageLocale)) != null) {
                this.m_messages.addMessages(messages);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_attributeConfigurations = new HashMap<String, AttributeConfiguration>();
        this.m_widgetConfigurations = new HashMap<String, CmsExternalWidgetConfiguration>();
        this.m_registeredTypes = new HashMap<String, I_Type>();
        this.readTypes(xmlContentDefinition, "", checkWidgetsOnly);
        this.m_tabInfos = this.collectTabInfos(xmlContentDefinition);
    }

    protected Map<String, AttributeConfiguration> getAttributeConfigurations() {
        return this.m_attributeConfigurations;
    }

    protected Map<String, I_Type> getTypes() {
        return this.m_registeredTypes;
    }

    protected Collection<CmsExternalWidgetConfiguration> getWidgetConfigurations() {
        return this.m_widgetConfigurations.values();
    }

    private List<TabInfo> collectTabInfos(CmsXmlContentDefinition definition) {
        ArrayList<TabInfo> result = new ArrayList<TabInfo>();
        if (definition.getContentHandler().getTabs() != null) {
            for (CmsXmlContentTab xmlTab : definition.getContentHandler().getTabs()) {
                String tabName = this.m_messages.keyDefault("label." + definition.getInnerName() + "." + xmlTab.getTabName(), xmlTab.getTabName());
                result.add(new TabInfo(tabName, xmlTab.getIdName(), xmlTab.getStartName(), xmlTab.isCollapsed()));
            }
        }
        return result;
    }

    private String getHelp(I_CmsXmlSchemaType value) {
        StringBuffer result = new StringBuffer(64);
        result.append("label.");
        result.append(this.getTypeKey(value));
        result.append(".help");
        return this.m_messages.keyDefault(result.toString(), null);
    }

    private String getLabel(I_CmsXmlSchemaType value) {
        StringBuffer result = new StringBuffer(64);
        result.append("label.");
        result.append(this.getTypeKey(value));
        return this.m_messages.keyDefault(result.toString(), value.getName());
    }

    private String getTypeKey(I_CmsXmlSchemaType value) {
        StringBuffer result = new StringBuffer(64);
        result.append(value.getContentDefinition().getInnerName());
        result.append('.');
        result.append(value.getName());
        return result.toString();
    }

    private AttributeConfiguration readConfiguration(A_CmsXmlContentValue schemaType, String path, boolean checkWidgetsOnly) {
        AttributeConfiguration result = null;
        String widgetName = null;
        String widgetConfig = null;
        CmsObject cms = this.getCmsObject();
        try {
            I_CmsWidget widget = schemaType.getContentDefinition().getContentHandler().getWidget(schemaType);
            if (widget != null) {
                widgetName = widget.getClass().getName();
                long timer = 0L;
                if (widget instanceof I_CmsADEWidget && !checkWidgetsOnly) {
                    if (CmsContentService.LOG.isDebugEnabled()) {
                        timer = System.currentTimeMillis();
                    }
                    I_CmsADEWidget adeWidget = (I_CmsADEWidget)widget;
                    widgetName = adeWidget.getWidgetName();
                    widgetConfig = adeWidget.getConfiguration(cms, schemaType, this.m_messages, this.m_file, this.m_locale);
                    if (!adeWidget.isInternal() && !this.m_widgetConfigurations.containsKey(widgetName)) {
                        CmsExternalWidgetConfiguration externalConfiguration = new CmsExternalWidgetConfiguration(widgetName, adeWidget.getInitCall(), adeWidget.getJavaScriptResourceLinks(cms), adeWidget.getCssResourceLinks(cms));
                        this.m_widgetConfigurations.put(widgetName, externalConfiguration);
                    }
                    if (CmsContentService.LOG.isDebugEnabled()) {
                        CmsContentService.LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_READING_WIDGET_CONFIGURATION_TIME_2", widgetName, "" + (System.currentTimeMillis() - timer)));
                    }
                }
                this.m_widgets.add(widget);
            }
        }
        catch (Exception e) {
            CmsContentService.LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        result = new AttributeConfiguration(this.getLabel(schemaType), this.getHelp(schemaType), widgetName, widgetConfig, this.readDefaultValue(schemaType, path));
        return result;
    }

    private String readDefaultValue(I_CmsXmlSchemaType schemaType, String path) {
        return this.m_contentHandler.getDefault(this.getCmsObject(), this.m_file, schemaType, path, this.m_locale);
    }

    private void readTypes(CmsXmlContentDefinition xmlContentDefinition, String path, boolean checkWidgetsOnly) {
        String typeName = CmsContentService.getTypeUri(xmlContentDefinition);
        if (this.m_registeredTypes.containsKey(typeName)) {
            return;
        }
        Type type = new Type(typeName);
        type.setChoiceMaxOccurrence(xmlContentDefinition.getChoiceMaxOccurs());
        this.m_registeredTypes.put(typeName, (I_Type)type);
        if (type.isChoice()) {
            Type choiceType = new Type(typeName + "/" + "ATTRIBUTE_CHOICE");
            this.m_registeredTypes.put(choiceType.getId(), (I_Type)choiceType);
            type.addAttribute("ATTRIBUTE_CHOICE", choiceType.getId(), 1, xmlContentDefinition.getChoiceMaxOccurs());
            type = choiceType;
        }
        for (I_CmsXmlSchemaType subType : xmlContentDefinition.getTypeSequence()) {
            String subTypeName = null;
            String childPath = path + "/" + subType.getName();
            String subAttributeName = CmsContentService.getAttributeName(subType.getName(), typeName);
            AttributeConfiguration config = this.readConfiguration((A_CmsXmlContentValue)subType, childPath, checkWidgetsOnly);
            if (config != null) {
                this.m_attributeConfigurations.put(subAttributeName, config);
            }
            if (subType.isSimpleType()) {
                subTypeName = "http://opencms.org/types/" + subType.getTypeName();
                if (!this.m_registeredTypes.containsKey(subTypeName)) {
                    this.m_registeredTypes.put(subTypeName, (I_Type)new Type(subTypeName));
                }
            } else {
                CmsXmlContentDefinition subTypeDefinition = ((CmsXmlNestedContentDefinition)subType).getNestedContentDefinition();
                subTypeName = CmsContentService.getTypeUri(subTypeDefinition);
                this.readTypes(subTypeDefinition, childPath, checkWidgetsOnly);
            }
            type.addAttribute(subAttributeName, subTypeName, subType.getMinOccurs(), subType.getMaxOccurs());
        }
    }
}

