/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import com.alkacon.acacia.shared.ContentDefinition;
import com.alkacon.acacia.shared.Entity;
import com.alkacon.acacia.shared.ValidationResult;
import com.alkacon.vie.shared.I_Entity;
import com.alkacon.vie.shared.I_EntityAttribute;
import com.alkacon.vie.shared.I_Type;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.contenteditor.CmsContentTypeVisitor;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.ade.contenteditor.shared.CmsContentDefinition;
import org.opencms.ade.contenteditor.shared.rpc.I_CmsContentService;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.CmsXmlContentEditor;
import org.opencms.workplace.explorer.CmsNewResourceXmlContent;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsContentService
extends CmsGwtService
implements I_CmsContentService {
    protected static final Log LOG = CmsLog.getLog(CmsContentService.class);
    static final String TYPE_NAME_PREFIX = "http://opencms.org/types/";
    private static final long serialVersionUID = 7873052619331296648L;
    private Locale m_workplaceLocale;

    public static String getAttributeName(I_CmsXmlContentValue contentValue) {
        return CmsContentService.getTypeUri(contentValue.getContentDefinition()) + "/" + contentValue.getName();
    }

    public static String getAttributeName(String elementName, String parentType) {
        return parentType + "/" + elementName;
    }

    public static String getEntityId(I_CmsXmlContentValue contentValue) {
        String result = CmsContentDefinition.uuidToEntityId(contentValue.getDocument().getFile().getStructureId(), contentValue.getLocale().toString());
        String valuePath = contentValue.getPath();
        if (valuePath.contains("/")) {
            result = result + "/" + valuePath.substring(0, valuePath.lastIndexOf("/"));
        }
        if (contentValue.isChoiceOption()) {
            result = result + "/ATTRIBUTE_CHOICE_" + contentValue.getName() + "[" + contentValue.getXmlIndex() + "]";
        }
        return result;
    }

    public static String getTypeUri(CmsXmlContentDefinition xmlContentDefinition) {
        return xmlContentDefinition.getSchemaLocation() + "/" + xmlContentDefinition.getTypeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsContentDefinition prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsContentService srv = new CmsContentService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsContentDefinition result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    public ContentDefinition loadContentDefinition(String entityId) throws CmsRpcException {
        return this.loadDefinition(entityId);
    }

    @Override
    public CmsContentDefinition loadDefinition(String entityId) throws CmsRpcException {
        CmsContentDefinition definition = null;
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            definition = this.readContentDefinition(resource, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), contentLocale, false);
        }
        catch (Exception e) {
            this.error(e);
        }
        return definition;
    }

    @Override
    public CmsContentDefinition loadDefinition(String entityId, String newLink, CmsUUID modelFileId, String editContext) throws CmsRpcException {
        CmsContentDefinition result = null;
        this.getCmsObject().getRequestContext().setAttribute(CmsXmlContentEditor.ATTRIBUTE_EDITCONTEXT, editContext);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(newLink)) {
            try {
                CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
                CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                result = this.readContentDefnitionForNew(newLink, resource, modelFileId, contentLocale);
            }
            catch (Throwable t) {
                this.error(t);
            }
        } else {
            result = this.loadDefinition(entityId);
        }
        return result;
    }

    @Override
    public CmsContentDefinition loadNewDefinition(String entityId) throws CmsRpcException {
        CmsContentDefinition definition = null;
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            definition = this.readContentDefinition(resource, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), contentLocale, true);
        }
        catch (Exception e) {
            this.error(e);
        }
        return definition;
    }

    @Override
    public CmsContentDefinition prefetch() throws CmsRpcException {
        String paramResource = this.getRequest().getParameter("resource");
        String paramNewLink = this.getRequest().getParameter("newlink");
        boolean createNew = false;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramNewLink)) {
            createNew = true;
            paramNewLink = this.decodeNewLink(paramNewLink);
        }
        String paramLocale = this.getRequest().getParameter("elementlanguage");
        Locale locale = null;
        CmsObject cms = this.getCmsObject();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramResource)) {
            try {
                CmsResource resource = cms.readResource(paramResource, CmsResourceFilter.IGNORE_EXPIRATION);
                if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramLocale)) {
                        locale = CmsLocaleManager.getLocale(paramLocale);
                    }
                    if (createNew) {
                        if (locale == null) {
                            locale = OpenCms.getLocaleManager().getDefaultLocale(cms, paramResource);
                        }
                        CmsUUID modelFileId = null;
                        String paramModelFile = this.getRequest().getParameter("modelfile");
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramModelFile)) {
                            modelFileId = cms.readResource(paramModelFile).getStructureId();
                        }
                        return this.readContentDefnitionForNew(paramNewLink, resource, modelFileId, locale);
                    }
                    CmsFile file = cms.readFile(resource);
                    CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                    if (locale == null) {
                        locale = this.getBestAvailableLocale(resource, content);
                    }
                    return this.readContentDefinition(file, content, null, locale, false);
                }
            }
            catch (Throwable e) {
                this.error(e);
            }
        }
        return null;
    }

    @Override
    public ValidationResult saveAndDeleteEntities(List<Entity> changedEntities, List<String> deletedEntities, boolean clearOnSuccess) throws CmsRpcException {
        CmsUUID structureId = null;
        if (!changedEntities.isEmpty()) {
            structureId = CmsContentDefinition.entityIdToUuid(changedEntities.get(0).getId());
        }
        if (structureId == null && !deletedEntities.isEmpty()) {
            structureId = CmsContentDefinition.entityIdToUuid(deletedEntities.get(0));
        }
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = null;
            try {
                resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                this.ensureLock(resource);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                this.checkAutoCorrection(cms, content);
                for (Entity entity : changedEntities) {
                    String entityId = entity.getId();
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                    if (content.hasLocale(contentLocale)) {
                        content.removeLocale(contentLocale);
                    }
                    content.addLocale(cms, contentLocale);
                    this.addEntityAttributes(cms, content, "", (I_Entity)entity, contentLocale);
                }
                for (String deleteId : deletedEntities) {
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(deleteId));
                    if (!content.hasLocale(contentLocale)) continue;
                    content.removeLocale(contentLocale);
                }
                ValidationResult validationResult = this.validateContent(cms, structureId, content);
                if (validationResult.hasErrors()) {
                    return validationResult;
                }
                this.writeContent(cms, file, content, this.getFileEncoding(cms, file));
                OpenCms.getSearchManager().updateOfflineIndexes(30000L);
                if (clearOnSuccess) {
                    this.tryUnlock(resource);
                }
            }
            catch (Exception e) {
                if (resource != null) {
                    this.tryUnlock(resource);
                }
                this.error(e);
            }
        }
        return null;
    }

    public ValidationResult saveEntities(List<Entity> entities) throws CmsRpcException {
        return this.saveAndDeleteEntities(entities, Collections.<String>emptyList(), true);
    }

    public ValidationResult saveEntity(Entity entity) throws CmsRpcException {
        return this.saveEntities(Collections.singletonList(entity));
    }

    public ValidationResult validateEntities(List<Entity> changedEntities) throws CmsRpcException {
        CmsUUID structureId = null;
        if (changedEntities.isEmpty()) {
            return new ValidationResult(null, null);
        }
        structureId = CmsContentDefinition.entityIdToUuid(changedEntities.get(0).getId());
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            try {
                CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                for (Entity entity : changedEntities) {
                    String entityId = entity.getId();
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                    if (content.hasLocale(contentLocale)) {
                        content.removeLocale(contentLocale);
                    }
                    content.addLocale(cms, contentLocale);
                    this.addEntityAttributes(cms, content, "", (I_Entity)entity, contentLocale);
                }
                return this.validateContent(cms, structureId, content);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        return new ValidationResult(null, null);
    }

    protected String decodeNewLink(String newLink) {
        String result = newLink;
        if (result == null) {
            return null;
        }
        try {
            result = CmsEncoder.decode(result);
            try {
                result = CmsEncoder.decode(result);
            }
            catch (Throwable e) {
                LOG.info((Object)e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable e) {
            LOG.info((Object)e.getLocalizedMessage(), e);
        }
        return result;
    }

    protected String getElementName(String attributeName) {
        if (attributeName.contains("/")) {
            return attributeName.substring(attributeName.lastIndexOf("/") + 1);
        }
        return attributeName;
    }

    protected String getFileEncoding(CmsObject cms, CmsResource file) {
        String result;
        try {
            result = cms.readPropertyObject(file, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
        }
        catch (CmsException e) {
            result = OpenCms.getSystemInfo().getDefaultEncoding();
        }
        return CmsEncoder.lookupEncoding(result, OpenCms.getSystemInfo().getDefaultEncoding());
    }

    protected Entity readEntity(CmsXmlContent content, Element element, Locale locale, String entityId, String parentPath, String typeName, Map<String, I_Type> registeredTypes) {
        Entity newEntity;
        String newEntityId = entityId + (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentPath) ? "/" + parentPath : "");
        Entity result = newEntity = new Entity(newEntityId, typeName);
        List elements = element.elements();
        I_Type type = registeredTypes.get(typeName);
        boolean isChoice = type.isChoice();
        String choiceTypeName = null;
        HashMap<String, Integer> attributeCounter = null;
        if (isChoice) {
            choiceTypeName = type.getAttributeTypeName("ATTRIBUTE_CHOICE");
            type = registeredTypes.get(type.getAttributeTypeName("ATTRIBUTE_CHOICE"));
            attributeCounter = new HashMap<String, Integer>();
        }
        int counter = 0;
        CmsObject cms = this.getCmsObject();
        String previousName = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentPath)) {
            parentPath = parentPath + "/";
        }
        for (Element child : elements) {
            String attributeName = CmsContentService.getAttributeName(child.getName(), typeName);
            String subTypeName = type.getAttributeTypeName(attributeName);
            if (registeredTypes.get(subTypeName) == null) continue;
            if (isChoice && attributeCounter != null) {
                if (!attributeName.equals(previousName)) {
                    counter = attributeCounter.get(attributeName) != null ? (Integer)attributeCounter.get(attributeName) : 0;
                    previousName = attributeName;
                }
                attributeCounter.put(attributeName, counter + 1);
            } else if (!attributeName.equals(previousName)) {
                counter = 0;
                previousName = attributeName;
            }
            if (isChoice) {
                result = new Entity(newEntityId + "/" + "ATTRIBUTE_CHOICE" + "_" + child.getName() + "[" + counter + "]", choiceTypeName);
                newEntity.addAttributeValue("ATTRIBUTE_CHOICE", (I_Entity)result);
            }
            String path = parentPath + child.getName();
            if (registeredTypes.get(subTypeName).isSimpleType()) {
                I_CmsXmlContentValue value = content.getValue(path, locale, counter);
                result.addAttributeValue(attributeName, value.getStringValue(cms));
            } else {
                Entity subEntity = this.readEntity(content, child, locale, entityId, path + "[" + (counter + 1) + "]", subTypeName, registeredTypes);
                result.addAttributeValue(attributeName, (I_Entity)subEntity);
            }
            ++counter;
        }
        return newEntity;
    }

    protected Map<String, I_Type> readTypes(CmsXmlContentDefinition xmlContentDefinition, Locale locale) {
        CmsContentTypeVisitor visitor = new CmsContentTypeVisitor(this.getCmsObject(), null, locale);
        visitor.visitTypes(xmlContentDefinition, locale);
        return visitor.getTypes();
    }

    private void addEntityAttributes(CmsObject cms, CmsXmlContent content, String parentPath, I_Entity entity, Locale contentLocale) {
        for (I_EntityAttribute attribute : entity.getAttributes()) {
            I_CmsXmlContentValue field;
            int i;
            if ("ATTRIBUTE_CHOICE".equals(attribute.getAttributeName())) {
                List choiceEntities = attribute.getComplexValues();
                for (int i2 = 0; i2 < choiceEntities.size(); ++i2) {
                    I_CmsXmlContentValue field2;
                    List choiceAttributes = ((I_Entity)choiceEntities.get(i2)).getAttributes();
                    assert (choiceAttributes.size() == 1 && ((I_EntityAttribute)choiceAttributes.get(0)).isSingleValue()) : "each choice entity may only have a single attribute with a single value";
                    I_EntityAttribute choiceAttribute = (I_EntityAttribute)choiceAttributes.get(0);
                    String elementPath = parentPath + this.getElementName(choiceAttribute.getAttributeName());
                    if (choiceAttribute.isSimpleValue()) {
                        String value = choiceAttribute.getSimpleValue();
                        field2 = content.getValue(elementPath, contentLocale, i2);
                        if (field2 == null) {
                            field2 = content.addValue(cms, elementPath, contentLocale, i2);
                        }
                        field2.setStringValue(cms, value);
                        continue;
                    }
                    I_Entity child = choiceAttribute.getComplexValue();
                    field2 = content.getValue(elementPath, contentLocale, i2);
                    if (field2 == null) {
                        field2 = content.addValue(cms, elementPath, contentLocale, i2);
                    }
                    this.addEntityAttributes(cms, content, field2.getPath() + "/", child, contentLocale);
                }
                continue;
            }
            String elementPath = parentPath + this.getElementName(attribute.getAttributeName());
            if (attribute.isSimpleValue()) {
                List values = attribute.getSimpleValues();
                for (i = 0; i < values.size(); ++i) {
                    String value = (String)values.get(i);
                    field = content.getValue(elementPath, contentLocale, i);
                    if (field == null) {
                        field = content.addValue(cms, elementPath, contentLocale, i);
                    }
                    field.setStringValue(cms, value);
                }
                continue;
            }
            List entities = attribute.getComplexValues();
            for (i = 0; i < entities.size(); ++i) {
                I_Entity child = (I_Entity)entities.get(i);
                field = content.getValue(elementPath, contentLocale, i);
                if (field == null) {
                    field = content.addValue(cms, elementPath, contentLocale, i);
                }
                this.addEntityAttributes(cms, content, field.getPath() + "/", child, contentLocale);
            }
        }
    }

    private boolean checkAutoCorrection(CmsObject cms, CmsXmlContent content) throws CmsXmlException {
        boolean performedAutoCorrection = false;
        try {
            content.validateXmlStructure(new CmsXmlEntityResolver(cms));
        }
        catch (CmsXmlException eXml) {
            content.setAutoCorrectionEnabled(true);
            content.correctXmlStructure(cms);
            performedAutoCorrection = true;
        }
        return performedAutoCorrection;
    }

    private Locale getBestAvailableLocale(CmsResource resource, CmsXmlContent content) {
        CmsObject cms = this.getCmsObject();
        Locale locale = OpenCms.getLocaleManager().getDefaultLocale(this.getCmsObject(), resource);
        if (!content.hasLocale(locale)) {
            boolean foundLocale = false;
            if (content.getLocales().size() > 0) {
                List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
                for (Locale defaultLocale : locales) {
                    if (!content.hasLocale(defaultLocale)) continue;
                    locale = defaultLocale;
                    foundLocale = true;
                    break;
                }
                if (!foundLocale) {
                    locales = OpenCms.getLocaleManager().getAvailableLocales(cms, resource);
                    for (Locale availableLocale : locales) {
                        if (!content.hasLocale(availableLocale)) continue;
                        locale = availableLocale;
                        foundLocale = true;
                        break;
                    }
                }
            }
        }
        return locale;
    }

    private String[] getPathElements(CmsXmlContent content, I_CmsXmlContentValue value) {
        ArrayList<String> pathElements = new ArrayList<String>();
        String[] paths = value.getPath().split("/");
        String path = "";
        for (int i = 0; i < paths.length; ++i) {
            path = path + paths[i];
            I_CmsXmlContentValue ancestor = content.getValue(path, value.getLocale());
            int valueIndex = ancestor.getXmlIndex();
            if (ancestor.isChoiceOption()) {
                Element parent = ancestor.getElement().getParent();
                valueIndex = parent.indexOf((Node)ancestor.getElement());
            }
            String pathElement = CmsContentService.getAttributeName(ancestor.getName(), CmsContentService.getTypeUri(ancestor.getContentDefinition()));
            pathElements.add(pathElement + "[" + valueIndex + "]");
            path = path + "/";
        }
        return pathElements.toArray(new String[pathElements.size()]);
    }

    private Locale getWorkplaceLocale(CmsObject cms) {
        if (this.m_workplaceLocale == null) {
            this.m_workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        }
        return this.m_workplaceLocale;
    }

    private CmsContentDefinition readContentDefinition(CmsFile file, CmsXmlContent content, String entityId, Locale locale, boolean newLocale) throws CmsException {
        boolean performedAutoCorrection;
        long timer = 0L;
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        CmsObject cms = this.getCmsObject();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(entityId)) {
            entityId = CmsContentDefinition.uuidToEntityId(file.getStructureId(), locale.toString());
        }
        if (performedAutoCorrection = this.checkAutoCorrection(cms, content)) {
            content.initDocument();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_UNMARSHALING_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        CmsContentTypeVisitor visitor = new CmsContentTypeVisitor(cms, file, locale);
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        visitor.visitTypes(content.getContentDefinition(), this.getWorkplaceLocale(cms));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_VISITING_TYPES_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        Entity entity = null;
        if (content.hasLocale(locale) && newLocale) {
            content.removeLocale(locale);
        }
        if (!content.hasLocale(locale)) {
            content.addLocale(cms, locale);
        }
        Element element = content.getLocaleNode(locale);
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        entity = this.readEntity(content, element, locale, entityId, "", CmsContentService.getTypeUri(content.getContentDefinition()), visitor.getTypes());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_READING_ENTITY_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        ArrayList<String> contentLocales = new ArrayList<String>();
        for (Locale contentLocale : content.getLocales()) {
            contentLocales.add(contentLocale.toString());
        }
        Locale workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        TreeMap<String, String> availableLocales = new TreeMap<String, String>();
        for (Locale availableLocale : OpenCms.getLocaleManager().getAvailableLocales(cms, file)) {
            availableLocales.put(availableLocale.toString(), availableLocale.getDisplayName(workplaceLocale));
        }
        String title = cms.readPropertyObject(file, "Title", false).getValue();
        String typeName = OpenCms.getResourceManager().getResourceType(file.getTypeId()).getTypeName();
        return new CmsContentDefinition(entity, visitor.getAttributeConfigurations(), visitor.getWidgetConfigurations(), visitor.getTypes(), visitor.getTabInfos(), locale.toString(), contentLocales, availableLocales, title, cms.getSitePath(file), typeName, performedAutoCorrection);
    }

    private CmsContentDefinition readContentDefinition(CmsResource resource, String entityId, Locale locale, boolean newLocale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsFile file = cms.readFile(resource);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
        return this.readContentDefinition(file, content, entityId, locale, newLocale);
    }

    private CmsContentDefinition readContentDefnitionForNew(String newLink, CmsResource referenceResource, CmsUUID modelFileId, Locale locale) throws CmsException {
        String sitePath = this.getCmsObject().getSitePath(referenceResource);
        String resourceType = OpenCms.getResourceManager().getResourceType(referenceResource.getTypeId()).getTypeName();
        String modelFile = null;
        if (modelFileId == null) {
            List<CmsResource> modelResources = CmsNewResourceXmlContent.getModelFiles(this.getCmsObject(), CmsResource.getFolderPath(sitePath), resourceType);
            if (!modelResources.isEmpty()) {
                List<CmsModelResourceInfo> modelInfos = CmsContainerpageService.generateModelResourceList(this.getCmsObject(), resourceType, modelResources, locale);
                return new CmsContentDefinition(modelInfos, newLink, referenceResource.getStructureId(), locale.toString());
            }
        } else if (!modelFileId.isNullUUID()) {
            modelFile = this.getCmsObject().getSitePath(this.getCmsObject().readResource(modelFileId, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        String newFileName = A_CmsResourceCollector.createResourceForCollector(this.getCmsObject(), newLink, locale, sitePath, modelFile);
        CmsResource resource = this.getCmsObject().readResource(newFileName, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsContentDefinition contentDefinition = this.readContentDefinition(resource, null, locale, false);
        contentDefinition.setDeleteOnCancel(true);
        return contentDefinition;
    }

    private ValidationResult validateContent(CmsObject cms, CmsUUID structureId, CmsXmlContent content) {
        CmsXmlContentErrorHandler errorHandler = content.validate(cms);
        HashMap errorsByEntity = new HashMap();
        if (errorHandler.hasErrors()) {
            for (Map.Entry<Locale, Map<String, String>> localeEntry : errorHandler.getErrors().entrySet()) {
                HashMap<String[], String> errors = new HashMap<String[], String>();
                for (Map.Entry<String, String> error : localeEntry.getValue().entrySet()) {
                    I_CmsXmlContentValue value = content.getValue(error.getKey(), localeEntry.getKey());
                    errors.put(this.getPathElements(content, value), error.getValue());
                }
                errorsByEntity.put(CmsContentDefinition.uuidToEntityId(structureId, localeEntry.getKey().toString()), errors);
            }
        }
        HashMap warningsByEntity = new HashMap();
        if (errorHandler.hasWarnings()) {
            for (Map.Entry<Locale, Map<String, String>> localeEntry : errorHandler.getWarnings().entrySet()) {
                HashMap<String[], String> warnings = new HashMap<String[], String>();
                for (Map.Entry<String, String> warning : localeEntry.getValue().entrySet()) {
                    I_CmsXmlContentValue value = content.getValue(warning.getKey(), localeEntry.getKey());
                    warnings.put(this.getPathElements(content, value), warning.getValue());
                }
                warningsByEntity.put(CmsContentDefinition.uuidToEntityId(structureId, localeEntry.getKey().toString()), warnings);
            }
        }
        return new ValidationResult(errorsByEntity, warningsByEntity);
    }

    private CmsXmlContent writeContent(CmsObject cms, CmsFile file, CmsXmlContent content, String encoding) throws CmsException {
        String decodedContent = content.toString();
        try {
            file.setContents(decodedContent.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new CmsException(org.opencms.workplace.editors.Messages.get().container("ERR_INVALID_CONTENT_ENC_1", file.getRootPath()), (Throwable)e);
        }
        file = cms.writeFile(file);
        return CmsXmlContentFactory.unmarshal(cms, file);
    }
}

