/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.shared;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.gwt.shared.CmsAdditionalInfoBean;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsContainerElementData
extends CmsContainerElement {
    private Map<String, String> m_contents;
    private Set<String> m_cssResources;
    private String m_description;
    private List<CmsInheritanceInfo> m_inheritanceInfos = new ArrayList<CmsInheritanceInfo>();
    private String m_inheritanceName;
    private String m_lastModifiedByUser;
    private long m_lastModifiedDate;
    private String m_navText;
    private Map<String, CmsXmlContentProperty> m_settingConfig;
    private Map<String, String> m_settings;
    private List<String> m_subItems = new ArrayList<String>();
    private String m_title;
    private Set<String> m_types;

    public Map<String, String> getContents() {
        return this.m_contents;
    }

    public Set<String> getCssResources() {
        return this.m_cssResources;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<CmsAdditionalInfoBean> getFormatedIndividualSettings() {
        ArrayList<CmsAdditionalInfoBean> result = new ArrayList<CmsAdditionalInfoBean>();
        if (this.m_settings != null) {
            for (Map.Entry<String, String> settingEntry : this.m_settings.entrySet()) {
                String settingKey = settingEntry.getKey();
                if (this.m_settingConfig.containsKey(settingEntry.getKey())) {
                    String niceName = this.m_settingConfig.get(settingEntry.getKey()).getNiceName();
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_settingConfig.get(settingEntry.getKey()).getNiceName())) {
                        settingKey = niceName;
                    }
                }
                result.add(new CmsAdditionalInfoBean(settingKey, settingEntry.getValue(), null));
            }
        }
        return result;
    }

    public List<CmsInheritanceInfo> getInheritanceInfos() {
        if (this.isInheritContainer()) {
            return this.m_inheritanceInfos;
        }
        throw new UnsupportedOperationException("Only inherit containers have inheritance infos");
    }

    public String getInheritanceName() {
        return this.m_inheritanceName;
    }

    public String getLastModifiedByUser() {
        return this.m_lastModifiedByUser;
    }

    public long getLastModifiedDate() {
        return this.m_lastModifiedDate;
    }

    public String getNavText() {
        return this.m_navText;
    }

    public Map<String, CmsXmlContentProperty> getSettingConfig() {
        return this.m_settingConfig;
    }

    public Map<String, String> getSettings() {
        return this.m_settings;
    }

    public List<String> getSubItems() {
        if (this.isGroupContainer()) {
            return this.m_subItems;
        }
        if (this.isInheritContainer()) {
            ArrayList<String> result = new ArrayList<String>();
            for (CmsInheritanceInfo info : this.m_inheritanceInfos) {
                if (!info.isVisible()) continue;
                result.add(info.getClientId());
            }
            return result;
        }
        throw new UnsupportedOperationException("Only group or inherit containers have sub-items");
    }

    public String getTitle() {
        return this.m_title;
    }

    public Set<String> getTypes() {
        return this.m_types;
    }

    @Override
    public boolean hasSettings() {
        return !this.getSettingConfig().isEmpty();
    }

    public void setContents(Map<String, String> contents) {
        this.m_contents = contents;
    }

    public void setCssResources(Set<String> cssResources) {
        this.m_cssResources = cssResources;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setInheritanceInfos(List<CmsInheritanceInfo> inheritanceInfos) {
        this.m_inheritanceInfos = inheritanceInfos;
    }

    public void setInheritanceName(String inheritanceName) {
        this.m_inheritanceName = inheritanceName;
    }

    public void setLastModifiedByUser(String lastModifiedByUser) {
        this.m_lastModifiedByUser = lastModifiedByUser;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.m_lastModifiedDate = lastModifiedDate;
    }

    public void setNavText(String navText) {
        this.m_navText = navText;
    }

    public void setSettingConfig(Map<String, CmsXmlContentProperty> settingConfig) {
        this.m_settingConfig = settingConfig;
    }

    public void setSettings(Map<String, String> settings) {
        this.m_settings = settings;
    }

    public void setSubItems(List<String> subItems) {
        this.m_subItems = subItems;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setTypes(Set<String> types) {
        this.m_types = types;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Title: ").append(this.m_title).append("  File: ").append(this.getSitePath()).append("  ClientId: ").append(this.getClientId());
        return result.toString();
    }
}

