/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.containerpage.inherited.CmsContainerConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;

public class CmsContainerConfigurationParser {
    private final CmsObject m_cms;
    private Map<String, CmsContainerConfiguration> m_currentConfigurationGroup;
    private Locale m_currentLocale;
    private final Map<Locale, Map<String, CmsContainerConfiguration>> m_results;

    public CmsContainerConfigurationParser(CmsObject cms) {
        this.m_cms = cms;
        this.m_results = new HashMap<Locale, Map<String, CmsContainerConfiguration>>();
    }

    public Map<Locale, Map<String, CmsContainerConfiguration>> getParsedResults() {
        return this.m_results;
    }

    public void parse(CmsFile file) throws CmsException {
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, file);
        Iterator<Locale> i$ = content.getLocales().iterator();
        while (i$.hasNext()) {
            Locale locale;
            this.m_currentLocale = locale = i$.next();
            CmsXmlContentRootLocation rootLocation = new CmsXmlContentRootLocation(content, locale);
            this.parseConfigurationGroup(rootLocation);
        }
    }

    public void parse(CmsResource resource) throws CmsException {
        CmsFile file = this.m_cms.readFile(resource);
        this.parse(file);
    }

    protected void parseConfigurationGroup(I_CmsXmlContentLocation location) {
        List<I_CmsXmlContentValueLocation> locations = location.getSubValues("Configuration");
        this.m_currentConfigurationGroup = new HashMap<String, CmsContainerConfiguration>();
        this.m_results.put(this.m_currentLocale, this.m_currentConfigurationGroup);
        for (I_CmsXmlContentValueLocation configLocation : locations) {
            this.parseSingleConfiguration(configLocation);
        }
    }

    protected void parseSingleConfiguration(I_CmsXmlContentValueLocation location) {
        I_CmsXmlContentValueLocation nameLoc = location.getSubValue("Name");
        if (nameLoc == null) {
            return;
        }
        String name = nameLoc.asString(this.m_cms);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            return;
        }
        ArrayList<String> ordering = null;
        List<I_CmsXmlContentValueLocation> orderKeyLocs = location.getSubValues("OrderKey");
        if (orderKeyLocs != null) {
            ordering = new ArrayList<String>();
            for (I_CmsXmlContentValueLocation orderKeyLoc : orderKeyLocs) {
                String orderKey = orderKeyLoc.asString(this.m_cms);
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(orderKey)) continue;
                ordering.add(orderKey.trim());
            }
        }
        HashMap<String, Boolean> visibilities = new HashMap<String, Boolean>();
        List<I_CmsXmlContentValueLocation> visibleLocs = location.getSubValues("Visible");
        for (I_CmsXmlContentValueLocation visibleLoc : visibleLocs) {
            String visibleStr = visibleLoc.asString(this.m_cms);
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(visibleStr)) continue;
            visibilities.put(visibleStr.trim(), Boolean.TRUE);
        }
        List<I_CmsXmlContentValueLocation> hiddenLocs = location.getSubValues("Hidden");
        for (I_CmsXmlContentValueLocation hiddenLoc : hiddenLocs) {
            String hiddenStr = hiddenLoc.asString(this.m_cms);
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(hiddenStr)) continue;
            visibilities.put(hiddenStr.trim(), Boolean.FALSE);
        }
        List<I_CmsXmlContentValueLocation> newElementLocs = location.getSubValues("NewElement");
        HashMap<String, CmsContainerElementBean> newElementBeans = new HashMap<String, CmsContainerElementBean>();
        for (I_CmsXmlContentValueLocation elementLoc : newElementLocs) {
            I_CmsXmlContentValueLocation keyLoc = elementLoc.getSubValue("Key");
            String key = keyLoc.asString(this.m_cms).trim();
            I_CmsXmlContentValueLocation actualElementLoc = elementLoc.getSubValue("Element");
            I_CmsXmlContentValueLocation uriLoc = actualElementLoc.getSubValue("Uri");
            CmsUUID structureId = uriLoc.asId(this.m_cms);
            if (structureId == null) continue;
            Map<String, String> settings = CmsXmlContentPropertyHelper.readProperties(this.m_cms, actualElementLoc);
            CmsContainerElementBean newElementBean = new CmsContainerElementBean(structureId, CmsUUID.getNullUUID(), settings, false);
            newElementBeans.put(key, newElementBean);
        }
        CmsContainerConfiguration config = new CmsContainerConfiguration(ordering, visibilities, newElementBeans);
        this.m_currentConfigurationGroup.put(name, config);
    }
}

