/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.ErrorCode;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;

public final class CmsLanguageUtil {
    public static final String LANGUAGE_PROFILE_ZIP_PATH = "/system/modules/org.opencms.languagedetection/languageprofiles/profiles.zip";
    private static final Log LOG = CmsLog.getLog(CmsLanguageUtil.class);

    private CmsLanguageUtil() {
    }

    public static void loadProfile(CmsObject cms, String path) throws LangDetectException {
        CmsFile file = null;
        try {
            file = cms.readFile(path);
        }
        catch (CmsException e) {
            throw new LangDetectException(ErrorCode.FileLoadError, "can't read resource from '" + path + "'");
        }
        if (file != null) {
            ZipInputStream zipInput = new ZipInputStream(new ByteArrayInputStream(file.getContents()));
            CmsLanguageUtil.loadProfile(zipInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProfile(ZipInputStream zipInput) throws LangDetectException {
        ArrayList<LangProfile> profiles = new ArrayList<LangProfile>();
        try {
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                if (entry.isDirectory() || entry.getName().startsWith(".")) continue;
                ByteArrayInputStream is = null;
                try {
                    int fileByteSize = Long.valueOf(entry.getSize()).intValue();
                    byte[] content = fileByteSize == -1 ? CmsFileUtil.readFully((InputStream)zipInput, false) : CmsFileUtil.readFully(zipInput, fileByteSize, false);
                    is = new ByteArrayInputStream(content);
                    LangProfile profile = (LangProfile)JSON.decode((InputStream)is, LangProfile.class);
                    profiles.add(profile);
                }
                catch (JSONException e) {
                    throw new LangDetectException(ErrorCode.FormatError, "profile format error in '" + entry.getName() + "'");
                }
                catch (IOException e) {
                    throw new LangDetectException(ErrorCode.FileLoadError, "can't open '" + entry.getName() + "'");
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                }
                zipInput.closeEntry();
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                zipInput.close();
            }
            catch (IOException e) {}
        }
        if (!profiles.isEmpty()) {
            DetectorFactory.clear();
            int count = 0;
            int langsize = profiles.size();
            for (LangProfile profile : profiles) {
                DetectorFactory.addProfile((LangProfile)profile, (int)count, (int)langsize);
                ++count;
            }
        }
    }
}

