/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.xml.content;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_COULD_NOT_RESOLVE_ID_1 = "ERR_COULD_NOT_RESOLVE_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNABLE_TO_INITIALIZE_CMSOBJECT_1 = "ERR_UNABLE_TO_INITIALIZE_CMSOBJECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XML_SCHEMA_COULD_NOT_PARSE_PROPERTY_CONFIG_1 = "ERR_XML_SCHEMA_COULD_NOT_PARSE_PROPERTY_CONFIG_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XML_SCHEMA_IO_1 = "ERR_XML_SCHEMA_IO_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XML_SCHEMA_MAPPING_CLASS_NOT_EXIST_3 = "ERR_XML_SCHEMA_MAPPING_CLASS_NOT_EXIST_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XML_SCHEMA_PARSE_1 = "ERR_XML_SCHEMA_PARSE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_ADD_ELEM_INVALID_IDX_2 = "ERR_XMLCONTENT_ADD_ELEM_INVALID_IDX_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_ADD_ELEM_INVALID_IDX_3 = "ERR_XMLCONTENT_ADD_ELEM_INVALID_IDX_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_ADD_ELEM_INVALID_IDX_CHOICE_3 = "ERR_XMLCONTENT_ADD_ELEM_INVALID_IDX_CHOICE_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_CHECK_INVALID_ELEM_1 = "ERR_XMLCONTENT_CHECK_INVALID_ELEM_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_CHECK_INVALID_TYPE_1 = "ERR_XMLCONTENT_CHECK_INVALID_TYPE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_CHECK_NOT_EMPTY_DOC_0 = "ERR_XMLCONTENT_CHECK_NOT_EMPTY_DOC_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_CHECK_NOT_OPTIONAL_1 = "ERR_XMLCONTENT_CHECK_NOT_OPTIONAL_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_CONFIG_ELEM_UNKNOWN_1 = "ERR_XMLCONTENT_CONFIG_ELEM_UNKNOWN_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_ELEM_MAXOCCURS_2 = "ERR_XMLCONTENT_ELEM_MAXOCCURS_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_ELEM_MINOCCURS_2 = "ERR_XMLCONTENT_ELEM_MINOCCURS_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_CUSTOM_CLASS_3 = "ERR_XMLCONTENT_INVALID_CUSTOM_CLASS_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_ELEM_DEFAULT_1 = "ERR_XMLCONTENT_INVALID_ELEM_DEFAULT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_ELEM_LAYOUTWIDGET_1 = "ERR_XMLCONTENT_INVALID_ELEM_LAYOUTWIDGET_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_ELEM_MAPPING_1 = "ERR_XMLCONTENT_INVALID_ELEM_MAPPING_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_ELEM_SEARCHSETTINGS_1 = "ERR_XMLCONTENT_INVALID_ELEM_SEARCHSETTINGS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_ELEM_VALIDATION_1 = "ERR_XMLCONTENT_INVALID_ELEM_VALIDATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_ENC_1 = "ERR_XMLCONTENT_INVALID_ENC_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_TYPE_1 = "ERR_XMLCONTENT_INVALID_TYPE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_INVALID_WIDGET_3 = "ERR_XMLCONTENT_INVALID_WIDGET_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_MISSING_LOCALE_1 = "ERR_XMLCONTENT_MISSING_LOCALE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_MISSING_MODELFOLDER_URI_2 = "ERR_XMLCONTENT_MISSING_MODELFOLDER_URI_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_MISSING_PREVIEW_URI_2 = "ERR_XMLCONTENT_MISSING_PREVIEW_URI_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_MISSING_RESOURCE_BUNDLE_NAME_2 = "ERR_XMLCONTENT_MISSING_RESOURCE_BUNDLE_NAME_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_MISSING_SCHEMA_0 = "ERR_XMLCONTENT_MISSING_SCHEMA_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_RESOLVE_FILE_NOT_FOUND_0 = "ERR_XMLCONTENT_RESOLVE_FILE_NOT_FOUND_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_UNKNOWN_ELEM_PATH_1 = "ERR_XMLCONTENT_UNKNOWN_ELEM_PATH_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_UNKNOWN_ELEM_PATH_SCHEMA_1 = "ERR_XMLCONTENT_UNKNOWN_ELEM_PATH_SCHEMA_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_UNMARSHAL_1 = "ERR_XMLCONTENT_UNMARSHAL_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CATEGORY_CHECK_EMPTY_ERROR_0 = "GUI_CATEGORY_CHECK_EMPTY_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CATEGORY_CHECK_NOLEAF_ERROR_0 = "GUI_CATEGORY_CHECK_NOLEAF_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_XMLCONTENT_VALIDATION_ERROR_2 = "GUI_EDITOR_XMLCONTENT_VALIDATION_ERROR_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_XMLCONTENT_VALIDATION_ERROR_TITLE_0 = "GUI_EDITOR_XMLCONTENT_VALIDATION_ERROR_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_XMLCONTENT_VALIDATION_WARNING_2 = "GUI_EDITOR_XMLCONTENT_VALIDATION_WARNING_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_XMLCONTENT_CHECK_ERROR_0 = "GUI_XMLCONTENT_CHECK_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_XMLCONTENT_CHECK_WARNING_EXPIRED_0 = "GUI_XMLCONTENT_CHECK_WARNING_EXPIRED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_XMLCONTENT_CHECK_WARNING_NOT_RELEASED_0 = "GUI_XMLCONTENT_CHECK_WARNING_NOT_RELEASED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_CHECK_PARENT_2 = "LOG_XMLCONTENT_CHECK_PARENT_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_CHECK_RULE_MATCH_1 = "LOG_XMLCONTENT_CHECK_RULE_MATCH_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_CHECK_WARNING_2 = "LOG_XMLCONTENT_CHECK_WARNING_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_INIT_BOOKMARKS_0 = "LOG_XMLCONTENT_INIT_BOOKMARKS_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_INVALID_ELEM_2 = "LOG_XMLCONTENT_INVALID_ELEM_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_RESOLVE_MAPPING_1 = "LOG_XMLCONTENT_RESOLVE_MAPPING_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_VALIDATION_ERR_2 = "LOG_XMLCONTENT_VALIDATION_ERR_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_VALIDATION_WARN_2 = "LOG_XMLCONTENT_VALIDATION_WARN_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_XMLCONTENT_VISIT_1 = "LOG_XMLCONTENT_VISIT_1";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.xml.content.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}