/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.xml.content;

import org.opencms.xml.I_CmsXmlDocument;

import java.util.List;
import java.util.Locale;

/**
 * This class represents a location in an XML content for a specific locale.<p>
 * 
 * It is used for conveniently retrieving configuration values from an XML content without manually
 * concatenating xpath strings.<p>
 * 
 * @since 8.0.0
 * 
 */
public interface I_CmsXmlContentLocation {

    /**
     * Returns the XML document.<p>
     * 
     * @return the XML document
     */
    I_CmsXmlDocument getDocument();

    /**
     * Returns the locale.<p>
     * 
     * @return the locale
     */
    Locale getLocale();

    /**
     * Returns the location for an xpath relative to the current location.<p>
     * 
     * @param subPath the relative path 
     * @return the location which the relative path points to 
     */
    I_CmsXmlContentValueLocation getSubValue(String subPath);

    /**
     * Returns the locations for an xpath relative to the current location.<p>
     * 
     * @param subPath the relative path 
     * @return the locations which the relative path points to 
     */
    List<I_CmsXmlContentValueLocation> getSubValues(String subPath);

}
