/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.threads;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DB_EXPORT_0 = "ERR_DB_EXPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DB_IMPORT_0 = "ERR_DB_IMPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LINK_VALIDATION_0 = "ERR_LINK_VALIDATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_VALUE_EMPTY_0 = "ERR_VALUE_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_XMLCONTENT_VFSFOLDER_1 = "ERR_XMLCONTENT_VFSFOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DB_IMPORT_THREAD_NAME_1 = "GUI_DB_IMPORT_THREAD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETE_MODULE_THREAD_NAME_1 = "GUI_DELETE_MODULE_THREAD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETE_PROJECT_THREAD_NAME_1 = "GUI_DELETE_PROJECT_THREAD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTML_LINK_VALIDATOR_THREAD_NAME_1 = "GUI_HTML_LINK_VALIDATOR_THREAD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_POINTER_VALIDATION_THREAD_NAME_0 = "GUI_POINTER_VALIDATION_THREAD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_DELETION_VALIDATOR_THREAD_NAME_1 = "GUI_RELATION_DELETION_VALIDATOR_THREAD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_REPLACE_MODULE_THREAD_NAME_1 = "GUI_REPLACE_MODULE_THREAD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_REPORT_TEST_THREAD_NAME_0 = "GUI_REPORT_TEST_THREAD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SYNCHRONIZE_THREAD_NAME_1 = "GUI_SYNCHRONIZE_THREAD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_XMLCONTENTREPAIR_THREAD_NAME_0 = "GUI_XMLCONTENTREPAIR_THREAD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DELETE_THREAD_CONSTRUCTED_0 = "LOG_DELETE_THREAD_CONSTRUCTED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DELETE_THREAD_FINISHED_0 = "LOG_DELETE_THREAD_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DELETE_THREAD_STARTED_0 = "LOG_DELETE_THREAD_STARTED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MODULE_DELETE_FAILED_1 = "LOG_MODULE_DELETE_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PROJECT_DELETE_FAILED_1 = "LOG_PROJECT_DELETE_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REPLACE_THREAD_CONSTRUCTED_0 = "LOG_REPLACE_THREAD_CONSTRUCTED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REPLACE_THREAD_FINISHED_0 = "LOG_REPLACE_THREAD_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REPLACE_THREAD_START_DELETE_0 = "LOG_REPLACE_THREAD_START_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REPLACE_THREAD_START_IMPORT_0 = "LOG_REPLACE_THREAD_START_IMPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PROCESSING_XMLCONTENT_0 = "RPT_PROCESSING_XMLCONTENT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_BEGIN_0 = "RPT_RELATIONS_DELETION_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_BREAK_0 = "RPT_RELATIONS_DELETION_BREAK_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_END_0 = "RPT_RELATIONS_DELETION_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_EXPANDFOLDER_1 = "RPT_RELATIONS_DELETION_EXPANDFOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_EXPANDFOLDER_BEGIN_0 = "RPT_RELATIONS_DELETION_EXPANDFOLDER_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_EXPANDFOLDER_END_0 = "RPT_RELATIONS_DELETION_EXPANDFOLDER_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_EXPANDSIBLING_1 = "RPT_RELATIONS_DELETION_EXPANDSIBLING_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_EXPANDSIBLINGS_BEGIN_0 = "RPT_RELATIONS_DELETION_EXPANDSIBLINGS_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_EXPANDSIBLINGS_END_0 = "RPT_RELATIONS_DELETION_EXPANDSIBLINGS_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_REFERENCING_1 = "RPT_RELATIONS_DELETION_REFERENCING_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_VALIDATION_1 = "RPT_RELATIONS_DELETION_VALIDATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_VALIDATION_BEGIN_0 = "RPT_RELATIONS_DELETION_VALIDATION_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_RELATIONS_DELETION_VALIDATION_END_0 = "RPT_RELATIONS_DELETION_VALIDATION_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_SYNCHRONIZE_BEGIN_0 = "RPT_SYNCHRONIZE_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_SYNCHRONIZE_END_0 = "RPT_SYNCHRONIZE_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_SYNCHRONIZE_FOLDERS_2 = "RPT_SYNCHRONIZE_FOLDERS_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_XMLCONTENTREPAIR_BEGIN_2 = "RPT_XMLCONTENTREPAIR_BEGIN_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_XMLCONTENTREPAIR_END_0 = "RPT_XMLCONTENTREPAIR_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_XMLCONTENTREPAIR_NOTLOCKED_0 = "RPT_XMLCONTENTREPAIR_NOTLOCKED_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_XMLCONTENTREPAIR_REPAIRED_0 = "RPT_XMLCONTENTREPAIR_REPAIRED_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_XMLCONTENTREPAIR_SKIPFILE_0 = "RPT_XMLCONTENTREPAIR_SKIPFILE_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.threads.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}