/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.galleries;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_OPEN_GALLERY_1 = "ERR_OPEN_GALLERY_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_DOWNLOADGALLERY_0 = "ERR_REASON_NO_DOWNLOADGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_HTMLGALLERY_0 = "ERR_REASON_NO_HTMLGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_IMAGEGALLERY_0 = "ERR_REASON_NO_IMAGEGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_LINKGALLERY_0 = "ERR_REASON_NO_LINKGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_TABLEGALLERY_0 = "ERR_REASON_NO_TABLEGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_BUTTON_PASTE_0 = "GUI_BUTTON_PASTE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_BUTTON_PREVIEW_0 = "GUI_BUTTON_PREVIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DOWNLOADGALLERY_EDITOR_TITLE_0 = "GUI_DOWNLOADGALLERY_EDITOR_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DOWNLOADGALLERY_EDITOR_TOOLTIP_0 = "GUI_DOWNLOADGALLERY_EDITOR_TOOLTIP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_BUTTON_CANCEL_0 = "GUI_GALLERY_BUTTON_CANCEL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_BUTTON_CLOSE_0 = "GUI_GALLERY_BUTTON_CLOSE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_BUTTON_OK_0 = "GUI_GALLERY_BUTTON_OK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_BUTTON_SEARCH_RESET_0 = "GUI_GALLERY_BUTTON_SEARCH_RESET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_CATEGORIES_BUTTON_SHOW_0 = "GUI_GALLERY_CATEGORIES_BUTTON_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_CATEGORIES_HL_AVAILABLE_0 = "GUI_GALLERY_CATEGORIES_HL_AVAILABLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_GALLERIES_BUTTON_PUBLISH_0 = "GUI_GALLERY_GALLERIES_BUTTON_PUBLISH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_GALLERIES_BUTTON_SHOW_0 = "GUI_GALLERY_GALLERIES_BUTTON_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_GALLERIES_BUTTON_UPLOAD_0 = "GUI_GALLERY_GALLERIES_BUTTON_UPLOAD_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_GALLERIES_HL_AVAILABLE_0 = "GUI_GALLERY_GALLERIES_HL_AVAILABLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEM_LOCKSTATE_LOCKED_0 = "GUI_GALLERY_ITEM_LOCKSTATE_LOCKED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEM_STATE_CHANGED_0 = "GUI_GALLERY_ITEM_STATE_CHANGED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEM_STATE_NEW_0 = "GUI_GALLERY_ITEM_STATE_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_DATE_CREATED_0 = "GUI_GALLERY_ITEMDETAIL_DATE_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_DATE_MODIFIED_0 = "GUI_GALLERY_ITEMDETAIL_DATE_MODIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_DELETE_0 = "GUI_GALLERY_ITEMDETAIL_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_EDIT_HELP_0 = "GUI_GALLERY_ITEMDETAIL_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_FORMAT_0 = "GUI_GALLERY_ITEMDETAIL_FORMAT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_HEADLINE_0 = "GUI_GALLERY_ITEMDETAIL_HEADLINE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_LINKTO_0 = "GUI_GALLERY_ITEMDETAIL_LINKTO_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_NAME_0 = "GUI_GALLERY_ITEMDETAIL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_PUBLISH_0 = "GUI_GALLERY_ITEMDETAIL_PUBLISH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_SELECT_0 = "GUI_GALLERY_ITEMDETAIL_SELECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_SIZE_0 = "GUI_GALLERY_ITEMDETAIL_SIZE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_STATE_CHANGED_0 = "GUI_GALLERY_ITEMDETAIL_STATE_CHANGED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_STATE_NEW_0 = "GUI_GALLERY_ITEMDETAIL_STATE_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_TARGET_0 = "GUI_GALLERY_ITEMDETAIL_TARGET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_TITLE_0 = "GUI_GALLERY_ITEMDETAIL_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_TYPE_0 = "GUI_GALLERY_ITEMDETAIL_TYPE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_PAGINATION_NEXT_0 = "GUI_GALLERY_PAGINATION_NEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_PAGINATION_PREVIOUS_0 = "GUI_GALLERY_PAGINATION_PREVIOUS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_BUTTON_SEARCH_0 = "GUI_GALLERY_BUTTON_SEARCH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_SEARCH_DESCRIPTION_0 = "GUI_GALLERY_SEARCH_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_SEARCH_NORESULTS_0 = "GUI_GALLERY_SEARCH_NORESULTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_SEARCH_QUERY_0 = "GUI_GALLERY_SEARCH_QUERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_SEARCH_RESULT_0 = "GUI_GALLERY_SEARCH_RESULT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_ITEMDETAIL_EDIT_URL_HELP_0 = "GUI_GALLERY_ITEMDETAIL_EDIT_URL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_SEARCH_RESULTS_0 = "GUI_GALLERY_SEARCH_RESULTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_TAB_ADVANCED_0 = "GUI_GALLERY_TAB_ADVANCED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_TAB_CATEGORIES_0 = "GUI_GALLERY_TAB_CATEGORIES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_TAB_GALLERIES_0 = "GUI_GALLERY_TAB_GALLERIES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GALLERY_TAB_PREVIEW_0 = "GUI_GALLERY_TAB_PREVIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLGALLERY_EDITOR_TITLE_0 = "GUI_HTMLGALLERY_EDITOR_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLGALLERY_EDITOR_TOOLTIP_0 = "GUI_HTMLGALLERY_EDITOR_TOOLTIP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_CROP_HEADLINE_0 = "GUI_IMAGEGALLERY_CROP_HEADLINE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_CROP_HEIGHT_0 = "GUI_IMAGEGALLERY_CROP_HEIGHT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_CROP_RATIO_0 = "GUI_IMAGEGALLERY_CROP_RATIO_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_CROP_WIDTH_0 = "GUI_IMAGEGALLERY_CROP_WIDTH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_EDITOR_TITLE_0 = "GUI_IMAGEGALLERY_EDITOR_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_EDITOR_TOOLTIP_0 = "GUI_IMAGEGALLERY_EDITOR_TOOLTIP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_FORMAT_FREECROP_0 = "GUI_IMAGEGALLERY_FORMAT_FREECROP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_FORMAT_LARGE_0 = "GUI_IMAGEGALLERY_FORMAT_LARGE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_FORMAT_ORIGINAL_0 = "GUI_IMAGEGALLERY_FORMAT_ORIGINAL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_FORMAT_SMALL_0 = "GUI_IMAGEGALLERY_FORMAT_SMALL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_FORMAT_USER_0 = "GUI_IMAGEGALLERY_FORMAT_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ADV_HL_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ADV_HL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_ADVTITLE_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_ADVTITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_CLASS_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_CLASS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_HL_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_HL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_ID_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_ID_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGCODE_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGCODE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGDIR_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGDIR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGDIR_LTR_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGDIR_LTR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGDIR_NOTSET_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGDIR_NOTSET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGDIR_RTL_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LANGDIR_RTL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LONGDESC_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_LONGDESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_STYLE_0 = "GUI_IMAGEGALLERY_IMGADVANCED_ATTRS_STYLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_BT_BROWSE_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_BT_BROWSE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_HL_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_HL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_TARGET_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_TARGET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_NEW_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_NOTSET_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_NOTSET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_PARENT_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_PARENT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_SELF_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_SELF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_TOP_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_TG_TOP_0";
    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGADVANCED_LINK_URL_0 = "GUI_IMAGEGALLERY_IMGADVANCED_LINK_URL_0";
    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGDETAIL_STATE_CHANGED_0 = "GUI_IMAGEGALLERY_IMGDETAIL_STATE_CHANGED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGDETAIL_STATE_NEW_0 = "GUI_IMAGEGALLERY_IMGDETAIL_STATE_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGITEM_LOCKSTATE_LOCKED_0 = "GUI_IMAGEGALLERY_IMGITEM_LOCKSTATE_LOCKED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGITEM_STATE_CHANGED_0 = "GUI_IMAGEGALLERY_IMGITEM_STATE_CHANGED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGITEM_STATE_NEW_0 = "GUI_IMAGEGALLERY_IMGITEM_STATE_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_ALIGN_LEFT_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_ALIGN_LEFT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_ALIGN_RIGHT_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_ALIGN_RIGHT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_ALIGNMENT_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_ALIGNMENT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_COPY_INSERT_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_COPY_INSERT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_COPY_RESET_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_COPY_RESET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_COPYRIGHT_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_COPYRIGHT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_DESCRIPTION_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_IMAGE_SPACING_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_IMAGE_SPACING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_LINK_ORIGINAL_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_LINK_ORIGINAL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_SPACING_H_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_SPACING_H_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_SPACING_V_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_SPACING_V_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_SUBTITLE_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_SUBTITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGOPTIONS_TITLE_RESET_0 = "GUI_IMAGEGALLERY_IMGOPTIONS_TITLE_RESET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_CROP_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_CROP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_CROP_REMOVE_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_CROP_REMOVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_DETAILS_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_DETAILS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_HEIGHT_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_HEIGHT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_HL_CROP_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_HL_CROP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_HL_FORMAT_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_HL_FORMAT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_IMAGE_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_IMAGE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_SIZE_LOCK_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_SIZE_LOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_SIZE_RESET_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_SIZE_RESET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_SIZE_UNLOCK_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_SIZE_UNLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGEGALLERY_IMGPREVIEW_WIDTH_0 = "GUI_IMAGEGALLERY_IMGPREVIEW_WIDTH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_DATELASTMODIFIED_0 = "GUI_INPUT_DATELASTMODIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_DESCRIPTION_0 = "GUI_INPUT_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_EDITPROPERTYINFO_0 = "GUI_INPUT_EDITPROPERTYINFO_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_KEYWORDS_0 = "GUI_INPUT_KEYWORDS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTARGET_0 = "GUI_INPUT_LINKTARGET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTARGETBLANK_0 = "GUI_INPUT_LINKTARGETBLANK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTARGETSELF_0 = "GUI_INPUT_LINKTARGETSELF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTARGETTOP_0 = "GUI_INPUT_LINKTARGETTOP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTO_0 = "GUI_INPUT_LINKTO_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_SEARCH_0 = "GUI_INPUT_SEARCH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_TITLE_0 = "GUI_INPUT_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_EXCERPT_0 = "GUI_LABEL_EXCERPT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_KILOBYTES_0 = "GUI_LABEL_KILOBYTES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_NAME_0 = "GUI_LABEL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_PIXELS_0 = "GUI_LABEL_PIXELS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_SIZE_0 = "GUI_LABEL_SIZE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_TITLE_0 = "GUI_LABEL_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LINKGALLERY_BUTTON_NEWLINK_0 = "GUI_LINKGALLERY_BUTTON_NEWLINK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LINKGALLERY_EDITOR_TITLE_0 = "GUI_LINKGALLERY_EDITOR_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LINKGALLERY_EDITOR_TOOLTIP_0 = "GUI_LINKGALLERY_EDITOR_TOOLTIP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MESSAGEBOX_TITLE_PUBLISHRESOURCE_0 = "GUI_MESSAGEBOX_TITLE_PUBLISHRESOURCE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TABLEGALLERY_EDITOR_TITLE_0 = "GUI_TABLEGALLERY_EDITOR_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TABLEGALLERY_EDITOR_TOOLTIP_0 = "GUI_TABLEGALLERY_EDITOR_TOOLTIP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_DELETE_0 = "GUI_TITLE_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_DOWNLOADGALLERY_0 = "GUI_TITLE_DOWNLOADGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_HTMLGALLERY_0 = "GUI_TITLE_HTMLGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_IMAGEGALLERY_0 = "GUI_TITLE_IMAGEGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_LINKGALLERY_0 = "GUI_TITLE_LINKGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_NEW_0 = "GUI_TITLE_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_TABLEGALLERY_0 = "GUI_TITLE_TABLEGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_GALLERY_INSTANCE_FAILED_2 = "LOG_CREATE_GALLERY_INSTANCE_FAILED_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_GALLERY_INSTANCE_FAILED_JSP_3 = "LOG_CREATE_GALLERY_INSTANCE_FAILED_JSP_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UNKNOWN_GALLERY_TYPE_REQ_1 = "LOG_UNKNOWN_GALLERY_TYPE_REQ_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UNKNOWN_GALLERY_TYPE_REQ_JSP_2 = "LOG_UNKNOWN_GALLERY_TYPE_REQ_JSP_2";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.galleries.messages";

    /**Prefix to create gallery not found key. */
    private static final String ERROR_REASON_NO_PREFIX = "ERR_REASON_NO_";

    /**Postfix to create gallery title key. */
    private static final String GUI_TITLE_POSTFIX = "_0";

    /**Prefix to create gallery title key. */
    private static final String GUI_TITLE_PREFIX = "GUI_TITLE_";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Convert gallery name to not found error  key.
     * @param gallery gallery name for example "htmlgallery"
     * @return key as string "ERR_REASON_NO_HTMLGALLERY_0"
     */
    public static String getGalleryNotFoundKey(String gallery) {

        StringBuffer sb = new StringBuffer(ERROR_REASON_NO_PREFIX);
        sb.append(gallery.toUpperCase());
        sb.append(GUI_TITLE_POSTFIX);
        return sb.toString();
    }

    /**
     * Convert gallery name to title key.
     * @param gallery gallery name for example "htmlgallery"
     * @return key as string "GUI_TITLE_HTMLGALLERY_0"
     */
    public static String getTitleGalleryKey(String gallery) {

        StringBuffer sb = new StringBuffer(GUI_TITLE_PREFIX);
        sb.append(gallery.toUpperCase());
        sb.append(GUI_TITLE_POSTFIX);
        return sb.toString();
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}
