/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.webdav;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 6.5.6
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DIRECTORY_FILENAME_0 = "GUI_DIRECTORY_FILENAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DIRECTORY_LASTMODIFIED_0 = "GUI_DIRECTORY_LASTMODIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DIRECTORY_PARENT_1 = "GUI_DIRECTORY_PARENT_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DIRECTORY_SIZE_0 = "GUI_DIRECTORY_SIZE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DIRECTORY_TITLE_1 = "GUI_DIRECTORY_TITLE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CLOSE_INPUT_STREAM_0 = "ERR_CLOSE_INPUT_STREAM_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CLOSE_READER_0 = "ERR_CLOSE_READER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INIT_PARAM_MISSING_1 = "ERR_INIT_PARAM_MISSING_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MD5_NOT_AVAILABLE_0 = "ERR_MD5_NOT_AVAILABLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REPOSITORY_NOT_FOUND_1 = "ERR_REPOSITORY_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CHILD_LOCKED_1 = "LOG_CHILD_LOCKED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_COPY_ITEM_2 = "LOG_COPY_ITEM_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_COPY_SUCCESS_0 = "LOG_COPY_SUCCESS_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_COLLECTION_0 = "LOG_CREATE_COLLECTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_SUCCESS_0 = "LOG_CREATE_SUCCESS_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DELETE_ITEM_0 = "LOG_DELETE_ITEM_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DELETE_SUCCESS_0 = "LOG_DELETE_SUCCESS_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DELETE_TEMP_FILE_0 = "LOG_DELETE_TEMP_FILE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEST_PATH_EXISTS_1 = "LOG_DEST_PATH_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INIT_WEBDAV_SERVLET_0 = "LOG_INIT_WEBDAV_SERVLET_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INVALID_CONTENT_0 = "LOG_INVALID_CONTENT_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INVALID_PROPFIND_TYPE_0 = "LOG_INVALID_PROPFIND_TYPE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ITEM_EXISTS_1 = "LOG_ITEM_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ITEM_LOCKED_1 = "LOG_ITEM_LOCKED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ITEM_NOT_FOUND_1 = "LOG_ITEM_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LIST_ITEMS_ERROR_1 = "LOG_LIST_ITEMS_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LOCK_ITEM_1 = "LOG_LOCK_ITEM_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LOCK_ITEM_FAILED_0 = "LOG_LOCK_ITEM_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LOCK_ITEM_SUCCESS_0 = "LOG_LOCK_ITEM_SUCCESS_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LOGIN_FAILED_1 = "LOG_LOGIN_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MOVE_ITEM_2 = "LOG_MOVE_ITEM_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MOVE_ITEM_SUCCESS_0 = "LOG_MOVE_ITEM_SUCCESS_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_NO_AUTHORIZATION_0 = "LOG_NO_AUTHORIZATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_NO_PERMISSION_0 = "LOG_NO_PERMISSION_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PARSE_DEST_HEADER_0 = "LOG_PARSE_DEST_HEADER_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_READ_INIT_PARAM_2 = "LOG_READ_INIT_PARAM_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_READ_INIT_PARAM_ERROR_2 = "LOG_READ_INIT_PARAM_ERROR_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REPOSITORY_ERROR_2 = "LOG_REPOSITORY_ERROR_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SAVE_ITEM_0 = "LOG_SAVE_ITEM_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SAVE_SUCCESS_0 = "LOG_SAVE_SUCCESS_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SERVE_BYTES_2 = "LOG_SERVE_BYTES_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SERVE_ITEM_1 = "LOG_SERVE_ITEM_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SERVE_ITEM_CONTENT_LENGTH_1 = "LOG_SERVE_ITEM_CONTENT_LENGTH_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SERVE_ITEM_CONTENT_TYPE_1 = "LOG_SERVE_ITEM_CONTENT_TYPE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SERVE_ITEM_HEADER_1 = "LOG_SERVE_ITEM_HEADER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SRC_DEST_EQUALS_0 = "LOG_SRC_DEST_EQUALS_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UNLOCK_ITEM_0 = "LOG_UNLOCK_ITEM_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_USE_REPOSITORY_1 = "LOG_USE_REPOSITORY_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WEBDAV_READ_ONLY_0 = "LOG_WEBDAV_READ_ONLY_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.webdav.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.
     * <p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.
     * <p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.
     * <p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}
