/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.relations;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 6.3.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CATEGORY_INVALID_LOCATION_1 = "ERR_CATEGORY_INVALID_LOCATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_RELATION_TYPE_INIT_1 = "ERR_RELATION_TYPE_INIT_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LINK_POINTING_TO_0 = "GUI_LINK_POINTING_TO_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LINK_POINTING_TO_2 = "GUI_LINK_POINTING_TO_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LINK_VALIDATION_RESULTS_ALL_VALID_1 = "GUI_LINK_VALIDATION_RESULTS_ALL_VALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LINK_VALIDATION_RESULTS_INTRO_1 = "GUI_LINK_VALIDATION_RESULTS_INTRO_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_A_0 = "GUI_RELATION_TYPE_A_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_CATEGORY_0 = "GUI_RELATION_TYPE_CATEGORY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_IMG_0 = "GUI_RELATION_TYPE_IMG_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_JSP_STRONG_0 = "GUI_RELATION_TYPE_JSP_STRONG_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_JSP_WEAK_0 = "GUI_RELATION_TYPE_JSP_WEAK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_OBJECT_0 = "GUI_RELATION_TYPE_OBJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_OU_0 = "GUI_RELATION_TYPE_OU_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_UNKNOWN_1 = "GUI_RELATION_TYPE_UNKNOWN_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_XML_STRONG_0 = "GUI_RELATION_TYPE_XML_STRONG_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_XML_WEAK_0 = "GUI_RELATION_TYPE_XML_WEAK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATION_TYPE_XSD_0 = "GUI_RELATION_TYPE_XSD_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATIONS_VALIDATION_DEFAULT_SUBJECT_0 = "GUI_RELATIONS_VALIDATION_DEFAULT_SUBJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_RELATIONS_VALIDATION_PROJECT_1 = "GUI_RELATIONS_VALIDATION_PROJECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_BROKEN_LINK_BY_ID_2 = "LOG_BROKEN_LINK_BY_ID_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_BROKEN_LINK_BY_NAME_1 = "LOG_BROKEN_LINK_BY_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_BROKEN_LINK_NO_ID_0 = "LOG_BROKEN_LINK_NO_ID_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_BROKEN_LINK_UPDATED_BY_ID_3 = "LOG_BROKEN_LINK_UPDATED_BY_ID_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_BROKEN_LINK_UPDATED_BY_NAME_3 = "LOG_BROKEN_LINK_UPDATED_BY_NAME_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ERR_CREATE_CATEGORY_FOLDER_1 = "LOG_ERR_CREATE_CATEGORY_FOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LINK_SEARCH_1 = "LOG_LINK_SEARCH_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LINK_VALIDATION_READBYID_FAILED_2 = "LOG_LINK_VALIDATION_READBYID_FAILED_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LINK_VALIDATION_READBYPATH_FAILED_2 = "LOG_LINK_VALIDATION_READBYPATH_FAILED_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LINK_VALIDATION_RESOURCEDELETED_1 = "LOG_LINK_VALIDATION_RESOURCEDELETED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LINK_VALIDATION_RESOURCENOTINLOOKUP_1 = "LOG_LINK_VALIDATION_RESOURCENOTINLOOKUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_RETRIEVAL_RESOURCES_1 = "LOG_RETRIEVAL_RESOURCES_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_RETRIEVAL_RESOURCETYPE_1 = "LOG_RETRIEVAL_RESOURCETYPE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BROKEN_0 = "RPT_BROKEN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BROKEN_LINKS_IN_1 = "RPT_BROKEN_LINKS_IN_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BROKEN_LINKS_SUMMARY_BEGIN_0 = "RPT_BROKEN_LINKS_SUMMARY_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BROKEN_LINKS_SUMMARY_END_0 = "RPT_BROKEN_LINKS_SUMMARY_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTMLLINK_BROKEN_SOURCE_2 = "RPT_HTMLLINK_BROKEN_SOURCE_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTMLLINK_BROKEN_TARGET_2 = "RPT_HTMLLINK_BROKEN_TARGET_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTMLLINK_FOUND_BROKEN_LINKS_0 = "RPT_HTMLLINK_FOUND_BROKEN_LINKS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTMLLINK_VALIDATING_0 = "RPT_HTMLLINK_VALIDATING_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTMLLINK_VALIDATOR_BEGIN_0 = "RPT_HTMLLINK_VALIDATOR_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTMLLINK_VALIDATOR_END_0 = "RPT_HTMLLINK_VALIDATOR_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTMLLINK_VALIDATOR_ERROR_0 = "RPT_HTMLLINK_VALIDATOR_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_LINK_VALIDATION_STAT_2 = "RPT_LINK_VALIDATION_STAT_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_VALIDATE_EXTERNAL_LINKS_BEGIN_0 = "RPT_VALIDATE_EXTERNAL_LINKS_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_VALIDATE_EXTERNAL_LINKS_END_0 = "RPT_VALIDATE_EXTERNAL_LINKS_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_VALIDATE_LINK_0 = "RPT_VALIDATE_LINK_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.relations.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}