/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.publish;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 6.5.5 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CONFIG_FROZEN_0 = "ERR_CONFIG_FROZEN_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_ENGINE_ABORT_DENIED_1 = "ERR_PUBLISH_ENGINE_ABORT_DENIED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_ENGINE_CREATE_REPORT_FILE_1 = "ERR_PUBLISH_ENGINE_CREATE_REPORT_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_ENGINE_DISABLED_0 = "ERR_PUBLISH_ENGINE_DISABLED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_ENGINE_ERROR_0 = "ERR_PUBLISH_ENGINE_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_ENGINE_MISSING_PUBLISH_JOB_0 = "ERR_PUBLISH_ENGINE_MISSING_PUBLISH_JOB_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_ENGINE_NOT_INITIALIZED_0 = "ERR_PUBLISH_ENGINE_NOT_INITIALIZED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_ENGINE_PERM_DENIED_1 = "ERR_PUBLISH_ENGINE_PERM_DENIED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_ENGINE_QUEUE_1 = "ERR_PUBLISH_ENGINE_QUEUE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_ABORT_ERROR_1 = "ERR_PUBLISH_JOB_ABORT_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_ALREADY_ENQUEUED_0 = "ERR_PUBLISH_JOB_ALREADY_ENQUEUED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_ALREADY_FINISHED_0 = "ERR_PUBLISH_JOB_ALREADY_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_ALREADY_STARTED_0 = "ERR_PUBLISH_JOB_ALREADY_STARTED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_ENQUEUE_ERROR_1 = "ERR_PUBLISH_JOB_ENQUEUE_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_FINISH_ERROR_1 = "ERR_PUBLISH_JOB_FINISH_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_INVALID_1 = "ERR_PUBLISH_JOB_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_REMOVE_ERROR_1 = "ERR_PUBLISH_JOB_REMOVE_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_JOB_START_ERROR_1 = "ERR_PUBLISH_JOB_START_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISH_REPORT_PATH_FAILED_0 = "ERR_PUBLISH_REPORT_PATH_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DIRECT_PUBLISH_PROJECT_NAME_0 = "GUI_DIRECT_PUBLISH_PROJECT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_JOB_ABORTED_2 = "GUI_PUBLISH_JOB_ABORTED_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_JOB_FINISHED_1 = "GUI_PUBLISH_JOB_FINISHED_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_JOB_FINISHED_WITH_WARNS_3 = "GUI_PUBLISH_JOB_FINISHED_WITH_WARNS_3";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_JOB_STARTED_1 = "GUI_PUBLISH_JOB_STARTED_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_TRHEAD_NAME_0 = "GUI_PUBLISH_TRHEAD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_PUBLISH_ENGINE_READY_0 = "INIT_PUBLISH_ENGINE_READY_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_PUBLISH_ENGINE_SHUTDOWN_1 = "INIT_PUBLISH_ENGINE_SHUTDOWN_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_PUBLISH_HISTORY_SIZE_SET_1 = "INIT_PUBLISH_HISTORY_SIZE_SET_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_PUBLISH_REPORT_PATH_SET_1 = "INIT_PUBLISH_REPORT_PATH_SET_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_ENGINE_DEAD_JOB_0 = "LOG_PUBLISH_ENGINE_DEAD_JOB_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_ENGINE_INTERRUPTED_JOB_0 = "LOG_PUBLISH_ENGINE_INTERRUPTED_JOB_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_ENGINE_NO_RUNNING_JOB_0 = "LOG_PUBLISH_ENGINE_NO_RUNNING_JOB_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_ENGINE_RUNNING_0 = "LOG_PUBLISH_ENGINE_RUNNING_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_ENGINE_WAITING_0 = "LOG_PUBLISH_ENGINE_WAITING_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_JOB_ABORT_0 = "LOG_PUBLISH_JOB_ABORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_JOB_ENQUEUE_0 = "LOG_PUBLISH_JOB_ENQUEUE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_JOB_FINISH_0 = "LOG_PUBLISH_JOB_FINISH_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_JOB_REMOVE_0 = "LOG_PUBLISH_JOB_REMOVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_JOB_START_0 = "LOG_PUBLISH_JOB_START_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_PROJECT_FAILED_0 = "LOG_PUBLISH_PROJECT_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_REPORT_DEFAULT_PATH_TRY_1 = "LOG_PUBLISH_REPORT_DEFAULT_PATH_TRY_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_REPORT_DELETE_FAILED_1 = "LOG_PUBLISH_REPORT_DELETE_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_THREADSTORE_PUBLISH_THREAD_INTERRUPT_2 = "LOG_THREADSTORE_PUBLISH_THREAD_INTERRUPT_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_JSPLOADER_UPDATE_CACHE_0 = "RPT_JSPLOADER_UPDATE_CACHE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_JSPLOADER_UPDATE_CACHE_BEGIN_0 = "RPT_JSPLOADER_UPDATE_CACHE_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_JSPLOADER_UPDATE_CACHE_END_0 = "RPT_JSPLOADER_UPDATE_CACHE_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_JOB_ABORT_SHUTDOWN_0 = "RPT_PUBLISH_JOB_ABORT_SHUTDOWN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_PROJECT_BEGIN_0 = "RPT_PUBLISH_PROJECT_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_PROJECT_END_0 = "RPT_PUBLISH_PROJECT_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_RESOURCE_BEGIN_0 = "RPT_PUBLISH_RESOURCE_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_RESOURCE_END_0 = "RPT_PUBLISH_RESOURCE_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_RESOURCE_SWITCH_PROJECT_1 = "RPT_PUBLISH_RESOURCE_SWITCH_PROJECT_1";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.publish.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}