/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.loader;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CONFLICTING_MODULE_RESOURCE_TYPES_5 = "ERR_CONFLICTING_MODULE_RESOURCE_TYPES_5";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CONFLICTING_RESOURCE_TYPES_4 = "ERR_CONFLICTING_RESOURCE_TYPES_4";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CONFLICTING_RESTYPES_IN_MODULE_5 = "ERR_CONFLICTING_RESTYPES_IN_MODULE_5";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_COLLECTOR_NAME_1 = "ERR_INVALID_COLLECTOR_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_HTMLCONVERTER_NAME_1 = "ERR_INVALID_HTMLCONVERTER_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_IMAGE_SCALE_PARAMS_2 = "ERR_INVALID_IMAGE_SCALE_PARAMS_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_POINTER_FILE_1 = "ERR_INVALID_POINTER_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOADER_JSP_ACCESS_1 = "ERR_LOADER_JSP_ACCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOADER_JSP_WRITE_1 = "ERR_LOADER_JSP_WRITE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOADER_NOT_TEMPLATE_ENABLED_0 = "ERR_LOADER_NOT_TEMPLATE_ENABLED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOADER_UNKNOWN_LOCALE_5 = "ERR_LOADER_UNKNOWN_LOCALE_5";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOADER_XML_NEED_ELEMENT_LOCALE_1 = "ERR_LOADER_XML_NEED_ELEMENT_LOCALE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_CONFIG_AFTER_STARTUP_0 = "ERR_NO_CONFIG_AFTER_STARTUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NONDEF_PROP_2 = "ERR_NONDEF_PROP_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SERVICE_UNSUPPORTED_1 = "ERR_SERVICE_UNSUPPORTED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNABLE_TO_EXTRACT_IMAGE_SIZE_1 = "ERR_UNABLE_TO_EXTRACT_IMAGE_SIZE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNABLE_TO_SCALE_IMAGE_2 = "ERR_UNABLE_TO_SCALE_IMAGE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNKNOWN_RESTYPE_ID_REQ_1 = "ERR_UNKNOWN_RESTYPE_ID_REQ_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNKNOWN_RESTYPE_NAME_REQ_1 = "ERR_UNKNOWN_RESTYPE_NAME_REQ_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOADER_CONTAINERPAGE_DEFAULT_DESC_0 = "GUI_LOADER_CONTAINERPAGE_DEFAULT_DESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOADER_DUMB_DEFAULT_DESC_0 = "GUI_LOADER_DUMB_DEFAULT_DESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOADER_JSP_DEFAULT_DESC_0 = "GUI_LOADER_JSP_DEFAULT_DESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOADER_POINTER_DEFAULT_DESC_0 = "GUI_LOADER_POINTER_DEFAULT_DESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOADER_SITEMAP_DEFAULT_DESC_0 = "GUI_LOADER_SITEMAP_DEFAULT_DESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOADER_XMLCONTENT_DEFAULT_DESC_0 = "GUI_LOADER_XMLCONTENT_DEFAULT_DESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOADER_XMLPAGE_DEFAULT_DESC_0 = "GUI_LOADER_XMLPAGE_DEFAULT_DESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_COLLECTOR_1 = "INIT_ADD_COLLECTOR_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_COLLECTOR_CLASS_2 = "INIT_ADD_COLLECTOR_CLASS_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_FLEX_CACHE_0 = "INIT_ADD_FLEX_CACHE_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_HTML_CONVERTER_CLASS_2 = "INIT_ADD_HTML_CONVERTER_CLASS_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_LOADER_2 = "INIT_ADD_LOADER_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_NUM_RESTYPES_FROM_MOD_2 = "INIT_ADD_NUM_RESTYPES_FROM_MOD_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_RESTYPE_3 = "INIT_ADD_RESTYPE_3";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_RESTYPE_FROM_FILE_2 = "INIT_ADD_RESTYPE_FROM_FILE_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_CLIENT_CACHE_MAX_AGE_1 = "INIT_CLIENT_CACHE_MAX_AGE_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_COLLECTOR_REPLACED_1 = "INIT_COLLECTOR_REPLACED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DUPLICATE_COLLECTOR_SKIPPED_1 = "INIT_DUPLICATE_COLLECTOR_SKIPPED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_GET_RESTYPE_2 = "INIT_GET_RESTYPE_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMAGE_REPOSITORY_PATH_1 = "INIT_IMAGE_REPOSITORY_PATH_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMAGE_SCALING_ENABLED_1 = "INIT_IMAGE_SCALING_ENABLED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_JSP_CACHE_SIZE_1 = "INIT_JSP_CACHE_SIZE_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_JSP_REPOSITORY_ABS_PATH_1 = "INIT_JSP_REPOSITORY_ABS_PATH_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_JSP_REPOSITORY_ERR_PAGE_COMMOTED_1 = "INIT_JSP_REPOSITORY_ERR_PAGE_COMMOTED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_LOADER_CONFIG_FINISHED_0 = "INIT_LOADER_CONFIG_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_LOADER_INITIALIZED_1 = "INIT_LOADER_INITIALIZED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_MAP_RESTYPE_2 = "INIT_MAP_RESTYPE_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_NUM_MIMETYPES_1 = "INIT_NUM_MIMETYPES_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_RESOURCE_TYPE_INITIALIZED_0 = "INIT_RESOURCE_TYPE_INITIALIZED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SHUTDOWN_1 = "INIT_SHUTDOWN_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_STARTING_LOADER_CONFIG_0 = "INIT_STARTING_LOADER_CONFIG_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_WEBAPP_PATH_1 = "INIT_WEBAPP_PATH_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ACCESS_DENIED_1 = "LOG_ACCESS_DENIED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_COLLECTOR_BAD_ORDER_NUMBER_1 = "LOG_COLLECTOR_BAD_ORDER_NUMBER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CONTENT_COLLECTOR_CLASS_NOT_FOUND_1 = "LOG_CONTENT_COLLECTOR_CLASS_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DIRECTIVE_ARG_1 = "LOG_DIRECTIVE_ARG_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DIRECTIVE_CHANGED_3 = "LOG_DIRECTIVE_CHANGED_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DIRECTIVE_DETECTED_3 = "LOG_DIRECTIVE_DETECTED_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ERR_UPDATE_1 = "LOG_ERR_UPDATE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_HTML_CONVERTER_CLASS_NOT_FOUND_1 = "LOG_HTML_CONVERTER_CLASS_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IGNORING_EXC_1 = "LOG_IGNORING_EXC_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_JSP_PERMCHECK_4 = "LOG_JSP_PERMCHECK_4";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_NAME_REAL_FS_1 = "LOG_NAME_REAL_FS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_READ_MIMETYPES_FAILED_2 = "LOG_READ_MIMETYPES_FAILED_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UNSUPPORTED_ENC_1 = "LOG_UNSUPPORTED_ENC_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UPDATE_JSP_1 = "LOG_UPDATE_JSP_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UPDATED_JSP_2 = "LOG_UPDATED_JSP_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WARN_WRONG_TEMPLATE_3 = "LOG_WARN_WRONG_TEMPLATE_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WRITING_JSP_1 = "LOG_WRITING_JSP_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_X_DIRECTIVE_DETECTED_1 = "LOG_X_DIRECTIVE_DETECTED_1";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.loader.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}