/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.gwt;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 8.0.0
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ALIAS_ALREADY_USED_1 = "ERR_ALIAS_ALREADY_USED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ALIAS_ALREADY_USED_UNKNOWN_0 = "ERR_ALIAS_ALREADY_USED_UNKNOWN_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ALIAS_DUPLICATE_PATH_0 = "ERR_ALIAS_DUPLICATE_PATH_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ALIAS_INVALID_PATH_0 = "ERR_ALIAS_INVALID_PATH_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ALIAS_IS_VFS_0 = "ERR_ALIAS_IS_VFS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INHERITANCE_GROUP_NOT_FOUND_1 = "ERR_INHERITANCE_GROUP_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INSTANTIATION_FAILED_1 = "ERR_INSTANTIATION_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INSTANTIATION_INCORRECT_TYPE_2 = "ERR_INSTANTIATION_INCORRECT_TYPE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_RESOURCE_HAS_BLOCKING_LOCKED_CHILDREN_1 = "ERR_RESOURCE_HAS_BLOCKING_LOCKED_CHILDREN_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_RESOURCE_MODIFIED_AFTER_OPEN_1 = "ERR_RESOURCE_MODIFIED_AFTER_OPEN_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SESSION_EXPIRED_0 = "ERR_SESSION_EXPIRED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_URL_NAME_ALREADY_EXISTS_1 = "ERR_URL_NAME_ALREADY_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_VALIDATOR_INCORRECT_TYPE_1 = "ERR_VALIDATOR_INCORRECT_TYPE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_VALIDATOR_INSTANTIATION_FAILED_1 = "ERR_VALIDATOR_INSTANTIATION_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ALIAS_0 = "GUI_ALIAS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCY_PAGE_PATH_0 = "GUI_DEPENDENCY_PAGE_PATH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCY_PAGE_TITLE_0 = "GUI_DEPENDENCY_PAGE_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOCKED_BY_1 = "GUI_LOCKED_BY_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOCKED_OWNER_0 = "GUI_LOCKED_OWNER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NO_PREVIEW_CAN_T_READ_CONTENT_0 = "GUI_NO_PREVIEW_CAN_T_READ_CONTENT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NO_PREVIEW_DELETED_0 = "GUI_NO_PREVIEW_DELETED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NO_PREVIEW_FOLDER_0 = "GUI_NO_PREVIEW_FOLDER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NO_PREVIEW_OTHER_SITE_0 = "GUI_NO_PREVIEW_OTHER_SITE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NO_PREVIEW_WRONG_MIME_TYPE_0 = "GUI_NO_PREVIEW_WRONG_MIME_TYPE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CLIENT_WITH_TICKET_4 = "LOG_CLIENT_WITH_TICKET_4";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CLIENT_WITHOUT_TICKET_3 = "LOG_CLIENT_WITHOUT_TICKET_3";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.gwt.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }

}
