/*
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.db.log;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @since 6.3.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_DETAIL_FROM_TO_2 = "GUI_LOG_ENTRY_DETAIL_FROM_TO_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_DETAIL_NAME_AND_ADDRESS_2 = "GUI_LOG_ENTRY_DETAIL_NAME_AND_ADDRESS_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_DETAIL_NAME_AND_PATH_2 = "GUI_LOG_ENTRY_DETAIL_NAME_AND_PATH_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_DETAIL_PATH_1 = "GUI_LOG_ENTRY_DETAIL_PATH_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_DETAIL_PATH_AND_RELATION_FILTER_2 = "GUI_LOG_ENTRY_DETAIL_PATH_AND_RELATION_FILTER_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_ADD_RELATION_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_ADD_RELATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_CLONED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_CLONED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_CONTENT_MODIFIED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_CONTENT_MODIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_COPIED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_COPIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_CREATED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_DATE_EXPIRED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_DATE_EXPIRED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_DATE_RELEASED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_DATE_RELEASED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_DELETED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_DELETED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_FLAGS_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_FLAGS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_HIDDEN_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_HIDDEN_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_HISTORY_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_HISTORY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_IMPORTED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_IMPORTED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_MOVED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_MOVED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_PERMISSIONS_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_PERMISSIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_PROPERTIES_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_PROPERTIES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_PUBLISHED_DELETED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_PUBLISHED_DELETED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_PUBLISHED_MODIFIED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_PUBLISHED_MODIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_PUBLISHED_NEW_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_PUBLISHED_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_REMOVE_RELATION_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_REMOVE_RELATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_RESTORE_DELETED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_RESTORE_DELETED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_RESTORED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_RESTORED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_TOUCHED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_TOUCHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_TYPE_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_TYPE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_RESOURCE_UNDELETED_0 = "GUI_LOG_ENTRY_TYPE_RESOURCE_UNDELETED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_USER_LOGIN_FAILED_0 = "GUI_LOG_ENTRY_TYPE_USER_LOGIN_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_USER_LOGIN_SUCCESSFUL_0 = "GUI_LOG_ENTRY_TYPE_USER_LOGIN_SUCCESSFUL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LOG_ENTRY_TYPE_USER_RESOURCE_VISITED_0 = "GUI_LOG_ENTRY_TYPE_USER_RESOURCE_VISITED_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.db.log.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}