/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.renderer;

import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.I_CmsCustomLinkRenderer;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.xml2json.CmsJsonResourceHandler;
import org.opencms.xml.xml2json.CmsXmlContentTree;
import org.opencms.xml.xml2json.I_CmsJsonFormattableValue;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.renderer.I_CmsJsonRendererXmlContent;

public class CmsJsonRendererXmlContent
implements I_CmsJsonRendererXmlContent {
    private CmsObject m_cms;
    private CmsObject m_rootCms;

    public CmsJsonRendererXmlContent() {
    }

    public CmsJsonRendererXmlContent(CmsObject cms) throws CmsException {
        this.initialize(cms);
    }

    public static JSONObject linkAndPath(String link, String path, CmsObject cms) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("link", link);
        if (path != null) {
            int paramPos = path.indexOf("?");
            if (paramPos != -1) {
                path = path.substring(0, paramPos);
            }
            path = OpenCms.getLinkManager().getRootPath(cms, path);
            result.put("path", path);
        }
        return result;
    }

    public static JSONObject renderAllLocales(CmsXmlContent content, I_CmsJsonRendererXmlContent renderer) throws JSONException {
        List<Locale> locales = content.getLocales();
        JSONObject result = new JSONObject(true);
        for (Locale locale : locales) {
            Object jsonForLocale = renderer.render(content, locale);
            result.put(locale.toString(), jsonForLocale);
        }
        return result;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return null;
    }

    @Override
    public void initConfiguration() {
    }

    @Override
    public void initialize(CmsJsonHandlerContext context) throws CmsException {
        this.initialize(context.getCms());
    }

    @Override
    public void initialize(CmsObject cms) throws CmsException {
        I_CmsCustomLinkRenderer linkRenderer;
        this.m_cms = OpenCms.initCmsObject(cms);
        Object context = cms.getRequestContext().getAttribute("jsonHandlerContext");
        this.m_rootCms = OpenCms.initCmsObject(this.m_cms);
        this.m_rootCms.getRequestContext().setSiteRoot("");
        if (context != null) {
            for (CmsObject currentCms : new CmsObject[]{this.m_cms, this.m_rootCms}) {
                currentCms.getRequestContext().setAttribute("jsonHandlerContext", context);
            }
        }
        if ((linkRenderer = CmsJsonResourceHandler.getLinkRenderer(cms)) != null) {
            this.m_cms.getRequestContext().setAttribute("CmsLink.customLinkHandler", linkRenderer);
        }
    }

    @Override
    public Object render(CmsXmlContent content, Locale locale) throws JSONException {
        CmsXmlContentTree tree = new CmsXmlContentTree(content, locale);
        this.m_cms.getRequestContext().setLocale(locale);
        this.m_rootCms.getRequestContext().setLocale(locale);
        CmsXmlContentTree.Node root = tree.getRoot();
        return this.renderNode(root);
    }

    public Object renderNode(CmsXmlContentTree.Node node) throws JSONException {
        switch (node.getType()) {
            case sequence: {
                List<CmsXmlContentTree.Field> fields = node.getFields();
                JSONObject result = new JSONObject(true);
                for (CmsXmlContentTree.Field field : fields) {
                    AbstractMap.SimpleEntry<String, Object> keyAndValue = this.renderField(field);
                    if (keyAndValue == null) continue;
                    result.put(keyAndValue.getKey(), keyAndValue.getValue());
                }
                return result;
            }
            case choice: {
                JSONArray array = new JSONArray();
                for (CmsXmlContentTree.Field field : node.getFields()) {
                    AbstractMap.SimpleEntry<String, Object> keyAndValue = this.renderField(field);
                    if (keyAndValue == null) continue;
                    JSONObject choiceObj = new JSONObject(true);
                    choiceObj.put(keyAndValue.getKey(), keyAndValue.getValue());
                    array.put(choiceObj);
                }
                return array;
            }
            case simple: {
                Object valueJson = this.renderSimpleValue(node);
                return valueJson;
            }
        }
        throw new IllegalArgumentException("Unsupported node: " + String.valueOf((Object)node.getType()));
    }

    protected AbstractMap.SimpleEntry<String, Object> renderField(CmsXmlContentTree.Field field) throws JSONException {
        String name = field.getName();
        if (field.isMultivalue()) {
            JSONArray array = new JSONArray();
            if (field.getFieldDefinition().isChoiceType()) {
                for (CmsXmlContentTree.Node subNode : field.getNodes()) {
                    JSONArray choiceJson = (JSONArray)this.renderNode(subNode);
                    array.append(choiceJson);
                }
            } else {
                for (CmsXmlContentTree.Node subNode : field.getNodes()) {
                    array.put(this.renderNode(subNode));
                }
            }
            return new AbstractMap.SimpleEntry<String, Object>(name, array);
        }
        if (field.getNodes().size() == 1) {
            if (field.getFieldDefinition().isChoiceType() && !field.isMultiChoice()) {
                JSONArray array = (JSONArray)this.renderNode(field.getNode());
                if (array.length() == 1) {
                    return new AbstractMap.SimpleEntry<String, Object>(name, array.get(0));
                }
            } else {
                return new AbstractMap.SimpleEntry<String, Object>(name, this.renderNode(field.getNodes().get(0)));
            }
        }
        return null;
    }

    protected Object renderSimpleValue(CmsXmlContentTree.Node node) throws JSONException {
        I_CmsXmlContentValue value = node.getValue();
        if (value instanceof I_CmsJsonFormattableValue) {
            return ((I_CmsJsonFormattableValue)((Object)value)).toJson(this.m_cms);
        }
        return node.getValue().getStringValue(this.m_cms);
    }
}

