/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.handler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.xml2json.CmsJsonResult;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.I_CmsJsonHandler;

public class CmsJsonHandlerOnlineCachingWrapper
implements I_CmsJsonHandler {
    private static final Log LOG = CmsLog.getLog(CmsJsonHandlerOnlineCachingWrapper.class);
    private I_CmsJsonHandler m_handler;
    private LoadingCache<CmsJsonHandlerContext.Key, CmsJsonResult> m_cache;

    public CmsJsonHandlerOnlineCachingWrapper(I_CmsJsonHandler handler, String spec) {
        this.m_handler = handler;
        CacheBuilder cacheBuilder = CacheBuilder.from((String)spec);
        this.m_cache = cacheBuilder.build((CacheLoader)new CacheLoader<CmsJsonHandlerContext.Key, CmsJsonResult>(){

            public CmsJsonResult load(CmsJsonHandlerContext.Key key) throws Exception {
                CmsJsonResult result = CmsJsonHandlerOnlineCachingWrapper.this.m_handler.renderJson(key.getContext());
                return result;
            }
        });
        OpenCms.addCmsEventListener(evt -> this.m_cache.invalidateAll(), new int[]{5, 2});
    }

    @Override
    public double getOrder() {
        return this.m_handler.getOrder();
    }

    @Override
    public boolean matches(CmsJsonHandlerContext context) {
        return this.m_handler.matches(context);
    }

    @Override
    public CmsJsonResult renderJson(CmsJsonHandlerContext context) {
        if (!context.getCms().getRequestContext().getCurrentProject().isOnlineProject()) {
            return this.m_handler.renderJson(context);
        }
        try {
            return (CmsJsonResult)this.m_cache.get((Object)context.getKey());
        }
        catch (ExecutionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(e.getLocalizedMessage(), 500);
        }
    }

    public String toString() {
        return this.m_handler.toString();
    }
}

