/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.document;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.xml2json.CmsJsonRequest;
import org.opencms.xml.xml2json.document.CmsJsonDocumentContainerPage;
import org.opencms.xml.xml2json.document.CmsJsonDocumentResource;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerException;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerXmlContent;
import org.opencms.xml.xml2json.renderer.CmsJsonRendererXmlContent;
import org.opencms.xml.xml2json.renderer.I_CmsJsonRendererXmlContent;

public class CmsJsonDocumentXmlContent
extends CmsJsonDocumentResource {
    protected CmsXmlContent m_xmlContent;
    protected boolean m_throwException = true;
    protected boolean m_embedLinkedModelgroup = true;
    private Object m_jsonPart;
    private I_CmsJsonRendererXmlContent m_renderer;

    public CmsJsonDocumentXmlContent(CmsJsonRequest jsonRequest, CmsXmlContent xmlContent) throws Exception {
        this(jsonRequest, xmlContent, true);
    }

    public CmsJsonDocumentXmlContent(CmsJsonRequest jsonRequest, CmsXmlContent xmlContent, boolean embedLinkedModelgroup) throws Exception {
        super(jsonRequest, xmlContent.getFile());
        this.m_xmlContent = xmlContent;
        this.m_embedLinkedModelgroup = embedLinkedModelgroup;
        this.initRenderer();
    }

    @Override
    public Object getJson() throws JSONException, CmsException, CmsJsonHandlerException, CmsJsonHandlerXmlContent.PathNotFoundException, Exception {
        this.insertJsonContent();
        this.insertJsonWrapper();
        if (this.isShowLinkedContentsRequest()) {
            this.insertJsonLinkedContents();
        }
        return this.m_jsonPart != null ? this.m_jsonPart : this.m_json;
    }

    protected void insertJsonLinkedContent(CmsResource resource) throws Exception {
        JSONObject jsonObject = (JSONObject)this.m_json.get("linkedContents");
        String key = resource.getRootPath();
        try {
            CmsFile file = this.m_context.getCms().readFile(resource);
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.m_context.getCms(), file);
            Object value = null;
            if (CmsResourceTypeXmlContainerPage.isContainerPage(resource) && this.m_embedLinkedModelgroup) {
                CmsJsonDocumentContainerPage document = new CmsJsonDocumentContainerPage(this.m_jsonRequest, xmlContent, false);
                value = document.getJson();
            } else if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
                CmsJsonDocumentXmlContent document = new CmsJsonDocumentXmlContent(this.m_jsonRequest, xmlContent, false);
                value = document.getJson();
            }
            jsonObject.put(key, value);
        }
        catch (Exception e) {
            JSONObject exception = new JSONObject();
            exception.put("exception", e.getLocalizedMessage());
            jsonObject.put(key, exception);
        }
    }

    protected void insertJsonLinkedContents() throws Exception {
        List<CmsRelation> relationList = this.m_context.getCms().getRelationsForResource(this.m_xmlContent.getFile(), CmsRelationFilter.TARGETS);
        this.m_json.put("linkedContents", new JSONObject());
        for (CmsRelation relation : relationList) {
            CmsResource resource = relation.getTarget(this.m_context.getCms(), CmsResourceFilter.DEFAULT);
            if (!CmsResourceTypeXmlContent.isXmlContent(resource) && !CmsResourceTypeXmlContainerPage.isContainerPage(resource)) continue;
            this.insertJsonLinkedContent(resource);
        }
    }

    protected void insertJsonWrapper() throws JSONException, CmsException {
        if (this.isShowWrapperRequest()) {
            this.insertJsonLocales();
            this.insertJsonResource();
        }
    }

    protected boolean isLocaleAllRequest() {
        String paramLocale = this.m_jsonRequest.getParamLocale();
        String paramPath = this.m_jsonRequest.getParamPath();
        return paramLocale == null && paramPath == null;
    }

    protected boolean isLocalePathRequest() {
        String paramLocale = this.m_jsonRequest.getParamLocale();
        String paramPath = this.m_jsonRequest.getParamPath();
        return paramLocale != null && paramPath != null;
    }

    protected boolean isLocaleRequest() {
        String paramLocale = this.m_jsonRequest.getParamLocale();
        String paramPath = this.m_jsonRequest.getParamPath();
        return paramLocale != null && paramPath == null;
    }

    protected boolean isShowFallbackLocaleRequest() {
        return this.m_jsonRequest.getParamFallbackLocale();
    }

    protected boolean isShowLinkedContentsRequest() {
        return this.m_jsonRequest.getParamContent();
    }

    protected boolean isShowWrapperRequest() {
        boolean showWrapper = true;
        String paramWrapperRaw = this.m_context.getParameters().get("wrapper");
        Boolean paramWrapper = this.m_jsonRequest.getParamWrapper();
        if (this.isLocaleAllRequest()) {
            showWrapper = true;
            if (paramWrapperRaw != null && paramWrapperRaw.equals("false")) {
                showWrapper = false;
            }
        } else if (this.isLocaleRequest()) {
            showWrapper = false;
            if (paramWrapper.booleanValue()) {
                showWrapper = true;
            }
        } else if (this.isLocalePathRequest()) {
            showWrapper = false;
        }
        return showWrapper;
    }

    private void initRenderer() throws Exception {
        I_CmsXmlContentHandler handler = this.m_xmlContent.getContentDefinition().getContentHandler();
        I_CmsXmlContentHandler.JsonRendererSettings settings = handler.getJsonRendererSettings();
        if (settings == null) {
            this.m_renderer = new CmsJsonRendererXmlContent();
        } else {
            this.m_renderer = (I_CmsJsonRendererXmlContent)Class.forName(settings.getClassName()).newInstance();
            for (Map.Entry<String, String> entry : settings.getParameters().entrySet()) {
                this.m_renderer.addConfigurationParameter(entry.getKey(), entry.getValue());
            }
            this.m_renderer.initConfiguration();
        }
        this.m_renderer.initialize(this.m_context.getCms());
    }

    private void insertJsonContent() throws CmsJsonHandlerException, JSONException, CmsJsonHandlerXmlContent.PathNotFoundException {
        if (this.isLocaleAllRequest()) {
            this.insertJsonContentAllLocales();
        } else if (this.isLocaleRequest()) {
            this.insertJsonContentLocale();
        } else if (this.isLocalePathRequest()) {
            this.insertJsonContentLocalePath();
        } else {
            throw new CmsJsonHandlerException("Can not use path parameter without locale parameter.");
        }
    }

    private void insertJsonContentAllLocales() throws JSONException {
        this.m_json = CmsJsonRendererXmlContent.renderAllLocales(this.m_xmlContent, this.m_renderer);
    }

    private void insertJsonContentLocale() throws JSONException, CmsJsonHandlerXmlContent.PathNotFoundException {
        String paramLocale = this.m_jsonRequest.getParamLocale();
        Locale locale = CmsLocaleManager.getLocale(paramLocale);
        Locale selectedLocale = OpenCms.getLocaleManager().getBestMatchingLocale(locale, Collections.emptyList(), this.m_xmlContent.getLocales());
        boolean localeExists = true;
        if (selectedLocale == null || !this.m_xmlContent.hasLocale(selectedLocale)) {
            localeExists = false;
        }
        JSONObject jsonObject = new JSONObject(true);
        if (localeExists) {
            jsonObject = (JSONObject)this.m_renderer.render(this.m_xmlContent, selectedLocale);
        } else if (this.isShowFallbackLocaleRequest()) {
            List<Locale> localeList = this.m_xmlContent.getLocales();
            if (!localeList.isEmpty()) {
                jsonObject = (JSONObject)this.m_renderer.render(this.m_xmlContent, localeList.get(0));
                this.m_json.put("localeFallback", localeList.get(0).toString());
            }
        } else if (this.m_throwException) {
            throw new CmsJsonHandlerXmlContent.PathNotFoundException("Locale <" + this.m_jsonRequest.getParamLocale() + "> not found.");
        }
        if (this.isShowWrapperRequest()) {
            this.m_json.put("localeContent", jsonObject);
        } else {
            this.m_json = jsonObject;
        }
    }

    private void insertJsonContentLocalePath() throws CmsJsonHandlerXmlContent.PathNotFoundException, JSONException {
        this.insertJsonContentLocale();
        String paramPath = this.m_jsonRequest.getParamPath();
        String[] tokens = paramPath.split("[/\\[\\]]");
        Object current = this.m_json;
        for (String token : tokens) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(token)) continue;
            if (StringUtils.isNumeric((CharSequence)token) && current instanceof JSONArray) {
                current = ((JSONArray)current).get(Integer.parseInt(token));
                continue;
            }
            if (current instanceof JSONObject) {
                current = ((JSONObject)current).get(token);
                continue;
            }
            throw new CmsJsonHandlerXmlContent.PathNotFoundException("Path not found");
        }
        this.m_jsonPart = current;
    }

    private void insertJsonLocales() throws JSONException {
        JSONArray locales = new JSONArray();
        for (Locale locale : this.m_xmlContent.getLocales()) {
            locales.put(locale.toString());
        }
        this.m_json.put("locales", locales);
    }
}

