/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.dom4j.Element;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlContentTree {
    private IdentityHashMap<I_CmsXmlContentValue, Node> m_valueToNodeCache = new IdentityHashMap();
    private CmsXmlContent m_content;
    private Locale m_locale;
    private Node m_root;

    public CmsXmlContentTree(CmsXmlContent content, Locale locale) {
        this.m_content = content;
        this.m_locale = locale;
        this.m_root = this.createNode(content.getLocaleNode(locale), content.getContentDefinition());
        CmsXmlContentTree.visitNodes(this.m_root, node -> {
            if (node.getValue() != null) {
                this.m_valueToNodeCache.put(node.getValue(), (Node)node);
            }
        });
    }

    public static void visitNodes(Node node, Consumer<Node> handler) {
        handler.accept(node);
        for (Field field : node.getFields()) {
            for (Node child : field.getNodes()) {
                CmsXmlContentTree.visitNodes(child, handler);
            }
        }
    }

    public Node createNode(Element elem, CmsXmlContentDefinition contentDef) {
        I_CmsXmlContentValue value;
        String path = this.getValuePath(elem);
        I_CmsXmlContentValue i_CmsXmlContentValue = value = path.isEmpty() ? null : this.m_content.getValue(path, this.m_locale);
        if (contentDef == null) {
            Node node = new Node(NodeType.simple, value, null, elem, null);
            return node;
        }
        CmsXmlContentDefinition.SequenceType seqType = contentDef.getSequenceType();
        if (seqType == CmsXmlContentDefinition.SequenceType.MULTIPLE_CHOICE || seqType == CmsXmlContentDefinition.SequenceType.SINGLE_CHOICE) {
            List<I_CmsXmlSchemaType> fieldDefinitions = contentDef.getTypeSequence();
            HashMap<String, I_CmsXmlSchemaType> defMap = new HashMap<String, I_CmsXmlSchemaType>();
            for (I_CmsXmlSchemaType i_CmsXmlSchemaType : fieldDefinitions) {
                String fieldName = i_CmsXmlSchemaType.getName();
                defMap.put(fieldName, i_CmsXmlSchemaType);
            }
            ArrayList<Field> choiceFields = new ArrayList<Field>();
            for (Element child : elem.elements()) {
                I_CmsXmlSchemaType childFieldDef = (I_CmsXmlSchemaType)defMap.get(child.getName());
                CmsXmlContentDefinition nestedDef = null;
                if (childFieldDef instanceof CmsXmlNestedContentDefinition) {
                    CmsXmlNestedContentDefinition nestedDefType = (CmsXmlNestedContentDefinition)childFieldDef;
                    nestedDef = nestedDefType.getNestedContentDefinition();
                }
                Node childNode = this.createNode(child, nestedDef);
                Field choiceField = new Field(childFieldDef, Arrays.asList(childNode));
                choiceFields.add(choiceField);
            }
            Node node = new Node(NodeType.choice, value, contentDef, elem, choiceFields);
            return node;
        }
        if (seqType == CmsXmlContentDefinition.SequenceType.SEQUENCE) {
            List<I_CmsXmlSchemaType> fieldDefinitions = contentDef.getTypeSequence();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (I_CmsXmlSchemaType i_CmsXmlSchemaType : fieldDefinitions) {
                CmsXmlContentDefinition nestedDef = null;
                if (i_CmsXmlSchemaType instanceof CmsXmlNestedContentDefinition) {
                    CmsXmlNestedContentDefinition nestedDefType = (CmsXmlNestedContentDefinition)i_CmsXmlSchemaType;
                    nestedDef = nestedDefType.getNestedContentDefinition();
                }
                String fieldName = i_CmsXmlSchemaType.getName();
                String fieldPath = CmsXmlUtils.concatXpath(path, fieldName);
                List<I_CmsXmlContentValue> fieldValues = this.m_content.getValues(fieldPath, this.m_locale);
                ArrayList<Node> fieldChildren = new ArrayList<Node>();
                for (int i = 0; i < fieldValues.size(); ++i) {
                    Element subElement = fieldValues.get(i).getElement();
                    Node fieldChild = this.createNode(subElement, nestedDef);
                    fieldChildren.add(fieldChild);
                }
                Field field = new Field(i_CmsXmlSchemaType, fieldChildren);
                fields.add(field);
            }
            Node seqNode = new Node(NodeType.sequence, value, contentDef, elem, fields);
            return seqNode;
        }
        throw new IllegalStateException("Invalid content definition type encounterered while processing " + this.m_content.getFile().getRootPath());
    }

    public Node getNodeForValue(I_CmsXmlContentValue value) {
        return this.m_valueToNodeCache.get(value);
    }

    public Node getRoot() {
        return this.m_root;
    }

    public String toString() {
        return this.m_content.getFile().getRootPath() + ":\n" + CmsStringUtil.indentLines(this.m_root.toString(), 4);
    }

    private String getValuePath(Element element) {
        String prefix;
        String fullPath = element.getUniquePath();
        String result = fullPath.substring((prefix = this.m_content.getLocaleNode(this.m_locale).getUniquePath()).length());
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public class Node {
        private CmsXmlContentDefinition m_contentDefinition;
        private Element m_elem;
        private List<Field> m_fields;
        private NodeType m_type;
        private I_CmsXmlContentValue m_value;

        public Node(NodeType type, I_CmsXmlContentValue value, CmsXmlContentDefinition contentDef, Element elem, List<Field> fields) {
            this.m_type = type;
            this.m_contentDefinition = contentDef;
            this.m_elem = elem;
            this.m_fields = fields;
            this.m_value = value;
            if (this.m_fields != null) {
                for (Field field : this.m_fields) {
                    field.setParentNode(this);
                }
            } else {
                this.m_fields = Collections.emptyList();
            }
        }

        public CmsXmlContentDefinition getContentDefinition() {
            return this.m_contentDefinition;
        }

        public Element getElement() {
            return this.m_elem;
        }

        public List<Field> getFields() {
            return this.m_fields;
        }

        public String getPath() {
            return CmsXmlContentTree.this.getValuePath(this.m_elem);
        }

        public NodeType getType() {
            return this.m_type;
        }

        public I_CmsXmlContentValue getValue() {
            return this.m_value;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("ND:\n");
            for (Field field : this.m_fields) {
                buffer.append(CmsStringUtil.indentLines(field.toString(), 4));
            }
            return buffer.toString();
        }
    }

    public class Field {
        I_CmsXmlSchemaType m_fieldDef;
        List<Node> m_nodes;
        private CmsXmlContentDefinition m_nestedDef;
        protected Node m_parentNode;

        public Field(I_CmsXmlSchemaType fieldDef, List<Node> nodes) {
            this.m_fieldDef = fieldDef;
            if (fieldDef instanceof CmsXmlNestedContentDefinition) {
                this.m_nestedDef = ((CmsXmlNestedContentDefinition)fieldDef).getNestedContentDefinition();
            }
            this.m_nodes = nodes;
        }

        public I_CmsXmlSchemaType getFieldDefinition() {
            return this.m_fieldDef;
        }

        public String getName() {
            return this.m_fieldDef.getName();
        }

        public Node getNode() {
            if (this.m_nodes.size() != 1) {
                throw new IllegalStateException("Can't call getNode for field with a number of nodes different from 1.");
            }
            return this.m_nodes.get(0);
        }

        public List<Node> getNodes() {
            return this.m_nodes;
        }

        public Node getParentNode() {
            return this.m_parentNode;
        }

        public boolean isMultiChoice() {
            return this.m_nestedDef != null && this.m_nestedDef.getChoiceMaxOccurs() > 1;
        }

        public boolean isMultivalue() {
            return this.m_fieldDef.getMaxOccurs() > 1;
        }

        public boolean isOptional() {
            return this.m_fieldDef.getMinOccurs() == 0;
        }

        public void setParentNode(Node parentNode) {
            this.m_parentNode = parentNode;
        }

        public String toString() {
            String result = "FL " + this.m_fieldDef.getName() + ":\n";
            for (Node child : this.m_nodes) {
                String entry = CmsStringUtil.indentLines(child.toString(), 4) + "\n";
                result = result + entry;
            }
            return result;
        }
    }

    public static enum NodeType {
        choice,
        sequence,
        simple;

    }
}

