/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json;

import java.util.List;
import java.util.function.Predicate;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.xml.xml2json.CmsJsonResourceHandler;

public class CmsResourceDataJsonHelper {
    private CmsObject m_cms;
    private Predicate<String> m_propertyFilter;
    private CmsResource m_resource;

    public CmsResourceDataJsonHelper(CmsObject cms, CmsResource resource, Predicate<String> propertyFilter) {
        this.m_cms = cms;
        this.m_resource = resource;
        this.m_propertyFilter = propertyFilter;
    }

    public void addPathAndLink(JSONObject json) throws JSONException {
        json.put("path", this.m_resource.getRootPath());
        json.put("link", CmsJsonResourceHandler.link(this.m_cms, this.m_resource));
    }

    public void addProperties(JSONObject result) throws CmsException, JSONException {
        result.put("properties", this.properties(true));
        result.put("own_properties", this.properties(false));
    }

    public JSONObject attributes() throws JSONException {
        JSONObject attributes = new JSONObject();
        attributes.put("type", OpenCms.getResourceManager().getResourceType(this.m_resource).getTypeName());
        attributes.put("lastModified", (Object)this.m_resource.getDateLastModified());
        return attributes;
    }

    public JSONObject properties(boolean inherited) throws CmsException, JSONException {
        List<CmsProperty> props = this.m_cms.readPropertyObjects(this.m_resource, inherited);
        JSONObject propJson = new JSONObject(true);
        for (CmsProperty prop : props) {
            if (this.m_propertyFilter != null && !this.m_propertyFilter.test(prop.getName())) continue;
            propJson.put(prop.getName(), prop.getValue());
        }
        return propJson;
    }
}

