/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.search.config.parser.CmsSimpleSearchConfigurationParser;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContainerPage;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerFolder;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerList;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerResource;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerXmlContent;
import org.opencms.xml.xml2json.handler.I_CmsJsonHandler;

public class CmsJsonRequest {
    public static final String PARAM_CONTENT = "content";
    public static final String PARAM_FALLBACK_LOCALE = "fallbackLocale";
    public static final String PARAM_LEVELS = "levels";
    public static final String PARAM_LOCALE = "locale";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_ROWS = "rows";
    public static final String PARAM_SORT = "sort";
    public static final String PARAM_START = "start";
    public static final String PARAM_WRAPPER = "wrapper";
    CmsJsonHandlerContext m_context;
    I_CmsJsonHandler m_handler;
    List<String> errors = new ArrayList<String>();

    public CmsJsonRequest(CmsJsonHandlerContext context, I_CmsJsonHandler handler) {
        this.m_context = context;
        this.m_handler = handler;
    }

    public CmsJsonHandlerContext getContext() {
        return this.m_context;
    }

    public JSONObject getErrorsAsJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", 400);
        for (String error : this.errors) {
            jsonObject.append("errors", error);
        }
        return jsonObject;
    }

    public Boolean getParamBoolean(String bool) {
        if (bool == null || bool.equals("false")) {
            return false;
        }
        return true;
    }

    public Boolean getParamContent() {
        String paramContent = this.m_context.getParameters().get(PARAM_CONTENT);
        return this.getParamBoolean(paramContent);
    }

    public Boolean getParamFallbackLocale() {
        String paramFallbackLocale = this.m_context.getParameters().get(PARAM_FALLBACK_LOCALE);
        return this.getParamBoolean(paramFallbackLocale);
    }

    public Integer getParamLevels() {
        String paramLevels = this.m_context.getParameters().get(PARAM_LEVELS);
        return paramLevels != null ? Integer.valueOf(paramLevels) : null;
    }

    public Integer getParamLevels(int defaultLevels) {
        Integer levels = this.getParamLevels();
        return levels != null ? levels : Integer.valueOf(defaultLevels);
    }

    public String getParamLocale() {
        String paramLocale = this.m_context.getParameters().get(PARAM_LOCALE);
        return paramLocale;
    }

    public String getParamPath() {
        String paramPath = this.m_context.getParameters().get(PARAM_PATH);
        return paramPath;
    }

    public Integer getParamRows() {
        String paramRows = this.m_context.getParameters().get(PARAM_ROWS);
        return paramRows != null ? Integer.valueOf(paramRows) : null;
    }

    public Integer getParamRows(int defaultRows) {
        Integer rows = this.getParamStart();
        return rows != null ? rows : Integer.valueOf(defaultRows);
    }

    public String getParamSort() {
        return this.m_context.getParameters().get(PARAM_SORT);
    }

    public String getParamSort(String defaultSort) {
        String sort = this.getParamSort();
        return sort != null ? sort : defaultSort;
    }

    public Integer getParamStart() {
        String paramStart = this.m_context.getParameters().get(PARAM_START);
        return paramStart != null ? Integer.valueOf(paramStart) : null;
    }

    public Integer getParamStart(int defaultStart) {
        Integer start = this.getParamStart();
        return start != null ? start : Integer.valueOf(defaultStart);
    }

    public Boolean getParamWrapper() {
        String paramWrapper = this.m_context.getParameters().get(PARAM_WRAPPER);
        return this.getParamBoolean(paramWrapper);
    }

    public Boolean getParamWrapper(boolean defaultWrapper) {
        String paramRaw = this.m_context.getParameters().get(PARAM_WRAPPER);
        if (paramRaw == null) {
            return defaultWrapper;
        }
        return this.getParamWrapper();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void validate() {
        this.validateRequest();
        this.validateDependencies();
        this.validateParamBooleanValue(PARAM_CONTENT, true);
        this.validateParamBooleanValue(PARAM_FALLBACK_LOCALE, true);
        this.validateParamPositiveIntegerValue(PARAM_LEVELS, false);
        this.validateParamPositiveIntegerValue(PARAM_ROWS, false);
        this.validateParamSortValue(PARAM_SORT, false);
        this.validateParamPositiveIntegerValue(PARAM_START, false);
        this.validateParamBooleanValue(PARAM_WRAPPER, true);
    }

    private void validateDependencies() {
        this.validateParamDepends(PARAM_FALLBACK_LOCALE, PARAM_LOCALE);
        this.validateParamDepends(PARAM_PATH, PARAM_LOCALE);
        this.validateParamDepends(PARAM_ROWS, PARAM_CONTENT);
        this.validateParamDepends(PARAM_SORT, PARAM_CONTENT);
        this.validateParamDepends(PARAM_START, PARAM_CONTENT);
    }

    private void validateParamBooleanValue(String paramName, boolean maybeEmpty) {
        String paramValue = this.m_context.getParameters().get(paramName);
        if (paramValue != null) {
            if (maybeEmpty && paramValue.equals("")) {
                return;
            }
            if (!paramValue.equals("true") && !paramValue.equals("false")) {
                this.errors.add("<" + paramValue + "> is not a boolean. Boolean expected for parameter <" + paramName + ">.");
            }
        }
    }

    private void validateParamDepends(String param, String other) {
        String first = this.m_context.getParameters().get(param);
        String second = this.m_context.getParameters().get(other);
        if (first != null && second == null) {
            this.errors.add("Parameter <" + param + "> depends on parameter <" + other + ">. <" + other + "> is expected.");
        }
    }

    private void validateParamPositiveIntegerValue(String paramName, boolean maybeEmpty) {
        String paramValue = this.m_context.getParameters().get(paramName);
        if (paramValue != null) {
            if (maybeEmpty && paramValue.equals("")) {
                return;
            }
            String message = "<" + paramValue + "> is not a positive integer. Positive integer expected for parameter <" + paramName + ">.";
            try {
                if (Integer.valueOf(paramValue) < 0) {
                    this.errors.add(message);
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(message);
            }
        }
    }

    private void validateParamSortValue(String paramName, boolean maybeEmpty) {
        String paramValue = this.m_context.getParameters().get(paramName);
        if (paramValue != null) {
            if (maybeEmpty && paramValue.equals("")) {
                return;
            }
            List<CmsSimpleSearchConfigurationParser.SortOption> list = Arrays.asList(CmsSimpleSearchConfigurationParser.SortOption.values());
            ArrayList<String> allowed = new ArrayList<String>();
            for (CmsSimpleSearchConfigurationParser.SortOption sortOption : CmsSimpleSearchConfigurationParser.SortOption.values()) {
                allowed.add(sortOption.toString());
            }
            String message = "<" + paramValue + "> is not a valid sort option. One of <" + String.join((CharSequence)",", allowed) + "> is expected.";
            try {
                if (!list.contains((Object)CmsSimpleSearchConfigurationParser.SortOption.valueOf(paramValue))) {
                    this.errors.add(message);
                }
            }
            catch (Exception e) {
                this.errors.add(message);
            }
        }
    }

    private void validateParamsSupported(String[] supported) {
        List<String> paramList = Arrays.asList(supported);
        for (String paramName : this.m_context.getParameters().keySet()) {
            if (paramList.contains(paramName)) continue;
            this.errors.add("Parameter <" + paramName + "> is not supported for this request type. One of <" + String.join((CharSequence)",", supported) + "> is expected.");
        }
    }

    private void validateRequest() {
        if (this.m_handler instanceof CmsJsonHandlerFolder) {
            this.validateRequestFolder();
        } else if (this.m_handler instanceof CmsJsonHandlerContainerPage) {
            this.validateRequestContainerPage();
        } else if (this.m_handler instanceof CmsJsonHandlerList) {
            this.validateRequestList();
        } else if (this.m_handler instanceof CmsJsonHandlerXmlContent) {
            this.validateRequestXmlContent();
        } else if (this.m_handler instanceof CmsJsonHandlerResource) {
            this.validateRequestResource();
        }
    }

    private void validateRequestContainerPage() {
        String[] supported = new String[]{PARAM_CONTENT, PARAM_WRAPPER, PARAM_LOCALE, PARAM_FALLBACK_LOCALE};
        this.validateParamsSupported(supported);
    }

    private void validateRequestFolder() {
        String[] supported = new String[]{PARAM_LEVELS, PARAM_CONTENT, PARAM_WRAPPER, PARAM_LOCALE, PARAM_FALLBACK_LOCALE};
        this.validateParamsSupported(supported);
    }

    private void validateRequestList() {
        String[] supported = new String[]{PARAM_CONTENT, PARAM_WRAPPER, PARAM_LOCALE, PARAM_FALLBACK_LOCALE, PARAM_START, PARAM_ROWS, PARAM_SORT};
        this.validateParamsSupported(supported);
    }

    private void validateRequestResource() {
        String[] supported = new String[]{};
        this.validateParamsSupported(supported);
    }

    private void validateRequestXmlContent() {
        String[] supported = new String[]{PARAM_CONTENT, PARAM_WRAPPER, PARAM_LOCALE, PARAM_FALLBACK_LOCALE, PARAM_PATH};
        this.validateParamsSupported(supported);
    }
}

