/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public interface I_CmsXmlContentValue
extends I_CmsXmlSchemaType {
    public I_CmsXmlDocument getDocument();

    public Element getElement();

    public int getIndex();

    public Locale getLocale();

    public int getMaxIndex();

    public String getPath();

    public String getPlainText(CmsObject var1);

    default public CmsSearchContentConfig getSearchContentConfig() {
        return new CmsSearchContentConfig(this.isSearchable() ? SearchContentType.TRUE : SearchContentType.FALSE, null);
    }

    public String getStringValue(CmsObject var1);

    public int getXmlIndex();

    public boolean isSearchable();

    public void moveDown();

    public void moveUp();

    public void setStringValue(CmsObject var1, String var2);

    public static class CmsSearchContentConfig {
        public static final CmsSearchContentConfig FALSE = new CmsSearchContentConfig(SearchContentType.FALSE, null);
        public static final CmsSearchContentConfig CONTENT = new CmsSearchContentConfig(SearchContentType.CONTENT, null);
        public static final CmsSearchContentConfig TRUE = new CmsSearchContentConfig(SearchContentType.TRUE, null);
        private SearchContentType m_type;
        private String m_adjustmentClass;

        private CmsSearchContentConfig(SearchContentType type, String adjustmentClass) {
            this.m_type = type;
            this.m_adjustmentClass = adjustmentClass;
        }

        public static CmsSearchContentConfig get(SearchContentType searchContentType) {
            return CmsSearchContentConfig.get(searchContentType, null);
        }

        public static CmsSearchContentConfig get(SearchContentType searchContentType, String adjustmentClass) {
            if (searchContentType == null) {
                return adjustmentClass == null ? null : new CmsSearchContentConfig(SearchContentType.TRUE, adjustmentClass);
            }
            switch (searchContentType) {
                case FALSE: {
                    return FALSE;
                }
                case TRUE: {
                    return adjustmentClass == null ? TRUE : new CmsSearchContentConfig(SearchContentType.TRUE, adjustmentClass);
                }
                case CONTENT: {
                    return CONTENT;
                }
            }
            return null;
        }

        public String getAdjustmentClass() {
            return this.m_adjustmentClass;
        }

        public SearchContentType getSearchContentType() {
            return this.m_type;
        }
    }

    public static enum SearchContentType {
        FALSE,
        TRUE,
        CONTENT;


        public static SearchContentType fromString(String type) {
            if (null == type) {
                return null;
            }
            switch (type.toLowerCase()) {
                case "false": {
                    return FALSE;
                }
                case "true": {
                    return TRUE;
                }
                case "content": {
                    return CONTENT;
                }
            }
            return null;
        }
    }
}

