/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CmsXsltContext {
    private static final Log LOG = CmsLog.getLog(CmsXsltContext.class);
    private CmsObject m_cms;
    private DocumentBuilderFactory m_documentBuilderFactory;
    private DocumentBuilder m_documentBuilder;

    public CmsXsltContext(CmsObject cms) {
        this.m_cms = cms;
        this.m_documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.m_documentBuilder = this.m_documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public NodeList convertType(NodeList value, String sourceTypeName, String targetTypeName, String elementName) {
        if (value.getLength() != 1) {
            throw new RuntimeException("convertType must be passed exactly one node.");
        }
        org.w3c.dom.Document doc = this.m_documentBuilder.newDocument();
        Node copiedNode = doc.importNode(value.item(0), true);
        Element w3cRoot = doc.createElement("root");
        doc.appendChild(w3cRoot);
        w3cRoot.appendChild(copiedNode);
        DOMReader reader = new DOMReader();
        Document dom4jDoc = reader.read(doc);
        org.dom4j.Element dom4jRoot = dom4jDoc.getRootElement();
        org.dom4j.Element dom4jValue = (org.dom4j.Element)dom4jRoot.elements().get(0);
        final CmsDefaultXmlContentHandler handler = new CmsDefaultXmlContentHandler();
        CmsXmlContent dummyContent = new CmsXmlContent(){

            @Override
            public I_CmsXmlContentHandler getHandler() {
                return handler;
            }
        };
        I_CmsXmlContentValue sourceType = (I_CmsXmlContentValue)OpenCms.getXmlContentTypeManager().getContentType(sourceTypeName);
        I_CmsXmlContentValue targetType = (I_CmsXmlContentValue)OpenCms.getXmlContentTypeManager().getContentType(targetTypeName).newInstance(elementName, "0", "1");
        I_CmsXmlContentValue sourceValue = sourceType.createValue(dummyContent, dom4jValue, Locale.ENGLISH);
        String valueString = sourceValue.getStringValue(this.m_cms);
        dom4jValue.detach();
        org.dom4j.Element dom4jNewValue = targetType.generateXml(this.m_cms, dummyContent, dom4jRoot, Locale.ENGLISH);
        I_CmsXmlContentValue newValue = targetType.createValue(dummyContent, dom4jNewValue, Locale.ENGLISH);
        newValue.setStringValue(this.m_cms, valueString);
        final ArrayList<Node> result = new ArrayList<Node>();
        try {
            org.w3c.dom.Document newW3cDoc = new DOMWriter().write(dom4jDoc);
            result.add(newW3cDoc.getDocumentElement().getFirstChild());
        }
        catch (DocumentException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return new NodeList(){

            @Override
            public int getLength() {
                return result.size();
            }

            @Override
            public Node item(int index) {
                return (Node)result.get(index);
            }
        };
    }
}

