/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.io.Serializable;
import org.opencms.util.CmsStringUtil;

public class CmsXmlContentProperty
implements Serializable {
    public static final String PROP_SEPARATOR = ",";
    private static final long serialVersionUID = -7718747702874213381L;
    protected Visibility m_visibility;
    private String m_aliasName;
    private String m_default;
    private String m_description;
    private String m_error;
    private String m_includeName;
    private String m_name;
    private String m_niceName;
    private String m_preferFolder;
    private String m_ruleRegex;
    private String m_ruleType;
    private String m_selectInherit;
    private String m_translation;
    private String m_type;
    private String m_widget;
    private String m_widgetConfiguration;

    public CmsXmlContentProperty(String name, String type, String widget, String widgetConfiguration, String ruleRegex, String ruleType, String default1, String niceName, String description, String error, String preferFolder) {
        this(name, null, type, null, widget, widgetConfiguration, ruleRegex, ruleType, default1, niceName, description, error, preferFolder, null);
    }

    public CmsXmlContentProperty(String name, String aliasName, String type, Visibility visibility, String widget, String widgetConfiguration, String ruleRegex, String ruleType, String default1, String niceName, String description, String error, String preferFolder, String translation) {
        this.m_name = name;
        this.m_type = type;
        this.m_visibility = visibility;
        this.m_widget = widget;
        this.m_widgetConfiguration = widgetConfiguration;
        this.m_ruleRegex = ruleRegex;
        this.m_ruleType = ruleType;
        this.m_default = default1;
        this.m_niceName = niceName;
        this.m_description = description;
        this.m_error = error;
        this.m_preferFolder = preferFolder;
        this.m_aliasName = CmsStringUtil.isEmptyOrWhitespaceOnly(aliasName) ? null : aliasName;
        this.m_translation = CmsStringUtil.isEmptyOrWhitespaceOnly(translation) ? null : translation;
    }

    protected CmsXmlContentProperty() {
    }

    private static <T> T firstNotNull(T o1, T o2) {
        if (o1 != null) {
            return o1;
        }
        return o2;
    }

    public CmsXmlContentProperty copy() {
        return new CmsXmlContentProperty(this.m_name, this.m_aliasName, this.m_type, this.m_visibility, this.m_widget, this.m_widgetConfiguration, this.m_ruleRegex, this.m_ruleType, this.m_default, this.m_niceName, this.m_description, this.m_error, this.m_preferFolder, this.m_translation);
    }

    public String getAliasName() {
        return this.m_aliasName;
    }

    public Visibility getConfiguredVisibility() {
        return this.m_visibility;
    }

    public String getConfiguredWidget() {
        return this.m_widget;
    }

    public String getDefault() {
        return this.m_default;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getError() {
        return this.m_error;
    }

    public String getIncludeName(String defaultValue) {
        if (this.m_includeName != null) {
            return this.m_includeName;
        }
        return defaultValue;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNiceName() {
        return this.m_niceName;
    }

    public String getRuleRegex() {
        return this.m_ruleRegex;
    }

    public String getRuleType() {
        return this.m_ruleType;
    }

    public String getSelectInherit() {
        return this.m_selectInherit;
    }

    public String getTranslationStr() {
        return this.m_translation;
    }

    public String getType() {
        return this.m_type;
    }

    public Visibility getVisibility(Visibility defaultValue) {
        if (this.m_visibility == null) {
            return defaultValue;
        }
        return this.m_visibility;
    }

    public String getWidget() {
        if (this.m_widget == null) {
            return "string";
        }
        return this.m_widget;
    }

    public String getWidgetConfiguration() {
        return this.m_widgetConfiguration;
    }

    public boolean isPreferFolder() {
        return this.m_preferFolder == null || Boolean.valueOf(this.m_preferFolder) != false;
    }

    public CmsXmlContentProperty mergeDefaults(CmsXmlContentProperty defaults) {
        return new CmsXmlContentProperty(CmsXmlContentProperty.firstNotNull(this.m_name, defaults.m_name), CmsXmlContentProperty.firstNotNull(this.m_aliasName, defaults.m_aliasName), CmsXmlContentProperty.firstNotNull(this.m_type, defaults.m_type), CmsXmlContentProperty.firstNotNull(this.m_visibility, defaults.m_visibility), CmsXmlContentProperty.firstNotNull(this.m_widget, defaults.m_widget), CmsXmlContentProperty.firstNotNull(this.m_widgetConfiguration, defaults.m_widgetConfiguration), CmsXmlContentProperty.firstNotNull(this.m_ruleRegex, defaults.m_ruleRegex), CmsXmlContentProperty.firstNotNull(this.m_ruleType, defaults.m_ruleType), CmsXmlContentProperty.firstNotNull(this.m_default, defaults.m_default), CmsXmlContentProperty.firstNotNull(this.m_niceName, defaults.m_niceName), CmsXmlContentProperty.firstNotNull(this.m_description, defaults.m_description), CmsXmlContentProperty.firstNotNull(this.m_error, defaults.m_error), CmsXmlContentProperty.firstNotNull(this.m_preferFolder, defaults.m_preferFolder), CmsXmlContentProperty.firstNotNull(this.m_translation, defaults.m_translation));
    }

    public CmsXmlContentProperty withConfig(String config) {
        return new CmsXmlContentProperty(this.m_name, this.m_aliasName, this.m_type, this.m_visibility, this.m_widget, config, this.m_ruleRegex, this.m_ruleType, this.m_default, this.m_niceName, this.m_description, this.m_error, this.m_preferFolder, this.m_translation);
    }

    public CmsXmlContentProperty withDefaultWidget(String defaultWidget) {
        return new CmsXmlContentProperty(this.m_name, this.m_aliasName, this.m_type, this.m_visibility, CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_widget) ? defaultWidget : this.m_widget, this.m_widgetConfiguration, this.m_ruleRegex, this.m_ruleType, this.m_default, this.m_niceName, this.m_description, this.m_error, this.m_preferFolder, this.m_translation);
    }

    public CmsXmlContentProperty withIncludeName(String includeName) {
        CmsXmlContentProperty result = this.copy();
        if (includeName != null) {
            includeName = includeName.trim();
        }
        result.m_includeName = includeName;
        return result;
    }

    public CmsXmlContentProperty withName(String name) {
        return new CmsXmlContentProperty(name, this.m_aliasName, this.m_type, this.m_visibility, this.m_widget, this.m_widgetConfiguration, this.m_ruleRegex, this.m_ruleType, this.m_default, this.m_niceName, this.m_description, this.m_error, this.m_preferFolder, this.m_translation);
    }

    public CmsXmlContentProperty withNiceName(String niceName) {
        return new CmsXmlContentProperty(this.m_name, this.m_aliasName, this.m_type, this.m_visibility, this.m_widget, this.m_widgetConfiguration, this.m_ruleRegex, this.m_ruleType, this.m_default, niceName, this.m_description, this.m_error, this.m_preferFolder, this.m_translation);
    }

    public CmsXmlContentProperty withValidation(String pattern, String type, String error) {
        return new CmsXmlContentProperty(this.m_name, this.m_aliasName, this.m_type, this.m_visibility, this.m_widget, this.m_widgetConfiguration, pattern, type, this.m_default, this.m_niceName, this.m_description, error, this.m_preferFolder, this.m_translation);
    }

    public static enum Visibility {
        element,
        elementAndParentIndividual,
        elementAndParentShared,
        parentIndividual,
        parentShared;


        public boolean isVisibleOnElement() {
            return this == element || this == elementAndParentIndividual || this == elementAndParentShared;
        }
    }

    public static enum XmlNode {
        FileList,
        Name,
        Properties,
        String,
        Uri,
        Value;

    }

    public static enum PropType {
        string,
        vfslist;


        public static boolean isVfsList(String type) {
            if (type == null) {
                return false;
            }
            return PropType.valueOf(type.toLowerCase()) == vfslist;
        }
    }
}

