/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsVfsBundleParameters;
import org.opencms.i18n.CmsVfsResourceBundle;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsVfsBundleLoaderXml
implements CmsVfsResourceBundle.I_Loader {
    public static final String N_KEY = "Key";
    public static final String N_MESSAGE = "Message";
    public static final String N_VALUE = "Value";

    @Override
    public Map<Locale, Map<String, String>> loadData(CmsObject cms, CmsVfsBundleParameters params) throws Exception {
        CmsFile file = cms.readFile(params.getBasePath());
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
        HashMap result = Maps.newHashMap();
        for (Locale locale : content.getLocales()) {
            List<I_CmsXmlContentValue> messages = content.getValues(N_MESSAGE, locale);
            HashMap<String, String> currentLocale = new HashMap<String, String>();
            for (I_CmsXmlContentValue messageValue : messages) {
                String path = messageValue.getPath();
                I_CmsXmlContentValue keyValue = content.getValue(CmsXmlUtils.concatXpath(path, N_KEY), locale);
                String keyStr = keyValue.getStringValue(cms);
                keyStr = keyStr.trim();
                I_CmsXmlContentValue valueValue = content.getValue(CmsXmlUtils.concatXpath(path, N_VALUE), locale);
                String valueStr = valueValue.getStringValue(cms);
                currentLocale.put(keyStr, valueStr);
            }
            result.put(locale, currentLocale);
        }
        return result;
    }
}

