/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.I_CmsFileNameGenerator;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsXmlContent;

public class CmsMappingResolutionContext {
    private static final Log LOG = CmsLog.getLog(CmsMappingResolutionContext.class);
    private CmsObject m_cms;
    private CmsXmlContent m_content;
    private Map<Locale, Long> m_dateExpired = new HashMap<Locale, Long>();
    private Map<Locale, Long> m_dateReleased = new HashMap<Locale, Long>();
    private boolean m_hasAttributeMappings;
    private List<InternalUrlNameMappingEntry> m_urlNameMappingEntries = Lists.newArrayList();

    public CmsMappingResolutionContext(CmsXmlContent content, boolean hasAttributeMappings) {
        this.m_content = content;
        this.m_hasAttributeMappings = hasAttributeMappings;
    }

    public void commitUrlNameMappings() throws CmsException {
        HashSet structureIds = Sets.newHashSet();
        for (InternalUrlNameMappingEntry internalUrlNameMappingEntry : this.m_urlNameMappingEntries) {
            structureIds.add(internalUrlNameMappingEntry.getStructureId());
        }
        boolean urlnameReplace = false;
        for (CmsUUID structureId : structureIds) {
            try {
                CmsResource resource = this.m_cms.readResource(structureId, CmsResourceFilter.ALL);
                CmsProperty prop = this.m_cms.readPropertyObject(resource, "urlname.replace", true);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(prop.getValue())) continue;
                urlnameReplace = Boolean.parseBoolean(prop.getValue());
            }
            catch (CmsException e) {
                LOG.error((Object)("Error while trying to read urlname.replace: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        I_CmsFileNameGenerator i_CmsFileNameGenerator = OpenCms.getResourceManager().getNameGenerator();
        for (InternalUrlNameMappingEntry entry : this.m_urlNameMappingEntries) {
            Iterator<String> nameSeq = i_CmsFileNameGenerator.getUrlNameSequence(entry.getName());
            this.m_cms.writeUrlNameMapping(nameSeq, entry.getStructureId(), entry.getLocale().toString(), urlnameReplace);
        }
    }

    public void finalizeMappings() throws CmsException {
        this.commitUrlNameMappings();
        if (this.m_hasAttributeMappings) {
            this.writeAttributes();
        }
    }

    public void putExpirationDate(Locale locale, long expiration) {
        this.m_dateExpired.put(locale, expiration);
    }

    public void putReleaseDate(Locale locale, long release) {
        this.m_dateReleased.put(locale, release);
    }

    public void setAttribute(CmsResource res, AttributeType type, Long value) throws CmsException {
        if (type == AttributeType.release) {
            long actualValue = value != null ? value : 0L;
            this.m_cms.setDateReleased(res, actualValue, false);
            if (this.m_content.getFile() != null && res.getStructureId().equals(this.m_content.getFile().getStructureId())) {
                this.m_content.getFile().setDateReleased(actualValue);
            }
        } else if (type == AttributeType.expiration) {
            long actualValue = value != null ? value : Long.MAX_VALUE;
            this.m_cms.setDateExpired(res, actualValue, false);
            if (this.m_content.getFile() != null && res.getStructureId().equals(this.m_content.getFile().getStructureId())) {
                this.m_content.getFile().setDateExpired(actualValue);
            }
        }
    }

    public void setCmsObject(CmsObject cms) {
        this.m_cms = cms;
    }

    protected void writeAttributes() {
        String p = "[" + RandomStringUtils.randomAlphanumeric((int)6) + "] ";
        CmsFile file = this.m_content.getFile();
        LOG.info((Object)(p + "Processing attributes for " + file.getRootPath()));
        try {
            for (CmsResource sibling : this.m_cms.readSiblings(file, CmsResourceFilter.IGNORE_EXPIRATION)) {
                LOG.info((Object)(p + "Processing sibling " + sibling.getRootPath()));
                try {
                    String localeStr;
                    List<Locale> tempLocales;
                    CmsProperty localeProp = this.m_cms.readPropertyObject(sibling, "locale", true);
                    List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales();
                    if (!localeProp.isNullProperty() && !(tempLocales = CmsLocaleManager.getLocales(localeStr = localeProp.getValue())).isEmpty()) {
                        locales = tempLocales;
                    }
                    LOG.info((Object)(p + "Using locale precedence " + String.valueOf(locales)));
                    boolean foundLocale = false;
                    for (Locale locale : locales) {
                        if (!this.m_content.hasLocale(locale)) continue;
                        LOG.info((Object)(p + "Mapping attributes from locale " + String.valueOf(locale)));
                        this.setAttribute(sibling, AttributeType.release, this.m_dateReleased.get(locale));
                        this.setAttribute(sibling, AttributeType.expiration, this.m_dateExpired.get(locale));
                        foundLocale = true;
                        break;
                    }
                    if (foundLocale) continue;
                    LOG.info((Object)(p + "No mapping locale found, resetting attributes"));
                    this.setAttribute(sibling, AttributeType.release, null);
                    this.setAttribute(sibling, AttributeType.expiration, null);
                }
                catch (CmsException e) {
                    LOG.error((Object)(p + e.getLocalizedMessage()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)(p + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    void addUrlNameMapping(String name, Locale locale, CmsUUID structureId) {
        this.m_urlNameMappingEntries.add(new InternalUrlNameMappingEntry(structureId, name, locale));
    }

    class InternalUrlNameMappingEntry {
        private Locale m_locale;
        private String m_name;
        private CmsUUID m_structureId;

        public InternalUrlNameMappingEntry(CmsUUID structureId, String name, Locale locale) {
            this.m_name = name;
            this.m_structureId = structureId;
            this.m_locale = locale;
        }

        public Locale getLocale() {
            return this.m_locale;
        }

        public String getName() {
            return this.m_name;
        }

        public CmsUUID getStructureId() {
            return this.m_structureId;
        }
    }

    public static enum AttributeType {
        expiration,
        release;

    }
}

