/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage.mutable;

import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.mutable.CmsMutableContainer;
import org.opencms.xml.containerpage.mutable.CmsMutableContainerPage;

public class CmsContainerPageWrapper {
    private CmsMutableContainerPage m_page;
    private CmsXmlContainerPage m_xml;
    private CmsObject m_cms;

    public CmsContainerPageWrapper(CmsObject cms, CmsResource res) throws CmsException {
        this.m_cms = cms;
        this.m_xml = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(res));
        this.m_page = CmsMutableContainerPage.fromImmutable(this.m_xml.getContainerPage(cms));
    }

    public CmsContainerPageWrapper(CmsObject cms, CmsXmlContainerPage xml) {
        this.m_cms = cms;
        this.m_xml = xml;
        this.m_page = CmsMutableContainerPage.fromImmutable(this.m_xml.getContainerPage(cms));
    }

    public boolean addElementToContainer(String containerName, CmsContainerElementBean element) {
        CmsMutableContainer container = this.page().firstContainer(containerName);
        if (container == null) {
            return false;
        }
        container.elements().add(element);
        return true;
    }

    public byte[] marshal() throws CmsException {
        this.m_xml.writeContainerPage(this.m_cms, this.m_page.toImmutable());
        return this.m_xml.marshal();
    }

    public CmsMutableContainerPage page() {
        return this.m_page;
    }

    public void saveToVfs() throws CmsException {
        CmsContainerPageBean immutablePage = this.page().toImmutable();
        try (AutoCloseable c = CmsLockUtil.withLockedResources(this.m_cms, this.m_xml.getFile());){
            this.m_xml.save(this.m_cms, immutablePage);
        }
        catch (Exception e) {
            if (e instanceof CmsException) {
                throw (CmsException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

