/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsFormatterUtils;
import org.opencms.ade.containerpage.CmsModelGroupHelper;
import org.opencms.ade.containerpage.CmsSettingTranslator;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsFunctionFormatterBean;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.containerpage.mutable.CmsMutableContainerPage;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentMacroVisitor;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;

public class CmsXmlContainerPage
extends CmsXmlContent {
    public static final String ATTR_STORE_DEFAULT_SETTINGS = "template.store.default.settings";
    public static final Set<String> LEGACY_SYSTEM_SETTING_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("use_as_copy_model", "model_group_id", "model_group_state", "use_as_copy_model", "source_containerpage_id")));
    public static final String SYSTEM_SETTING_PREFIX = "SYSTEM::";
    private static final Log LOG = CmsLog.getLog(CmsXmlContainerPage.class);
    private Map<Locale, CmsContainerPageBean> m_cntPages;

    protected CmsXmlContainerPage() {
    }

    protected CmsXmlContainerPage(CmsObject cms, Document document, String encoding, EntityResolver resolver) {
        this.m_document = document;
        this.m_contentDefinition = this.getContentDefinition(resolver);
        this.initDocument(cms, this.m_document, encoding, this.m_contentDefinition);
    }

    protected CmsXmlContainerPage(CmsObject cms, Locale locale, String modelUri) throws CmsException {
        CmsFile modelFile = cms.readFile(modelUri, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsXmlContainerPage model = CmsXmlContainerPageFactory.unmarshal(cms, modelFile);
        CmsMacroResolver macroResolver = CmsMacroResolver.newInstance().setCmsObject(cms);
        this.m_contentDefinition = model.getContentDefinition();
        Document document = (Document)model.m_document.clone();
        this.initDocument(cms, document, model.getEncoding(), this.m_contentDefinition);
        this.visitAllValuesWith(new CmsXmlContentMacroVisitor(cms, macroResolver));
        if (!this.hasLocale(locale)) {
            try {
                this.addLocale(cms, locale);
            }
            catch (CmsXmlException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected CmsXmlContainerPage(CmsObject cms, Locale locale, String encoding, CmsXmlContentDefinition contentDefinition) {
        this.m_contentDefinition = contentDefinition;
        Document document = this.m_contentDefinition.createDocument(cms, this, CmsLocaleManager.MASTER_LOCALE);
        this.initDocument(cms, document, encoding, this.m_contentDefinition);
    }

    public byte[] createContainerPageXml(CmsObject cms, CmsContainerPageBean cntPage) throws CmsException {
        this.writeContainerPage(cms, cntPage);
        this.checkLinkConcistency(cms);
        return this.marshal();
    }

    public CmsContainerPageBean getContainerPage(CmsObject cms) {
        CmsContainerPageBean result = this.getOriginalContainerPage(cms);
        if (result != null) {
            result = CmsMutableContainerPage.fromImmutable(result).toImmutable();
            return result;
        }
        return null;
    }

    public CmsContainerPageBean getOriginalContainerPage(CmsObject cms) {
        Locale masterLocale = CmsLocaleManager.MASTER_LOCALE;
        Locale localeToLoad = null;
        if (this.m_cntPages.containsKey(masterLocale)) {
            localeToLoad = masterLocale;
        } else if (!this.m_cntPages.isEmpty()) {
            localeToLoad = this.m_cntPages.keySet().iterator().next();
        }
        if (localeToLoad == null) {
            return null;
        }
        CmsContainerPageBean result = this.m_cntPages.get(localeToLoad);
        return result;
    }

    public void initDocument(CmsObject cms) {
        this.initDocument(cms, this.m_document, this.m_encoding, this.getContentDefinition());
    }

    @Override
    public boolean isAutoCorrectionEnabled() {
        return true;
    }

    public void save(CmsObject cms, CmsContainerPageBean cntPage) throws CmsException {
        this.save(cms, cntPage, false);
    }

    public void save(CmsObject cms, CmsContainerPageBean cntPage, boolean ifChangedOnly) throws CmsException {
        CmsFile file = this.getFile();
        byte[] data = this.createContainerPageXml(cms, cntPage);
        if (ifChangedOnly && Arrays.equals(file.getContents(), data)) {
            return;
        }
        cms.lockResourceTemporary(file);
        file.setContents(data);
        cms.writeFile(file);
    }

    public void writeContainerPage(CmsObject cms, CmsContainerPageBean cntPage) throws CmsException {
        CmsContainerPageBean savePage = this.cleanupContainersContainers(cms, cntPage);
        savePage = this.removeEmptyContainers(cntPage);
        for (Locale locale : this.getLocales()) {
            this.removeLocale(locale);
        }
        Locale masterLocale = CmsLocaleManager.MASTER_LOCALE;
        this.addLocale(cms, masterLocale);
        Element parent = this.getLocaleNode(masterLocale);
        this.saveContainerPage(cms, parent, savePage);
        this.initDocument(this.m_document, this.m_encoding, this.m_contentDefinition);
    }

    protected void checkLinkConcistency(CmsObject cms) {
        Locale masterLocale = CmsLocaleManager.MASTER_LOCALE;
        for (I_CmsXmlContentValue contentValue : this.getValues(masterLocale)) {
            if (!(contentValue instanceof CmsXmlVfsFileValue)) continue;
            CmsLink link = ((CmsXmlVfsFileValue)contentValue).getLink(cms);
            link.checkConsistency(cms);
        }
        this.initDocument();
    }

    protected CmsContainerPageBean cleanupContainersContainers(CmsObject cms, CmsContainerPageBean cntPage) {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, this.getFile().getRootPath());
        Map<String, CmsContainerBean> currentContainers = cntPage.getContainers();
        ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
        for (String string : cntPage.getNames()) {
            CmsContainerBean container = currentContainers.get(string);
            if (container.getElements().isEmpty()) continue;
            containers.add(container);
        }
        CmsContainerPageBean currentContainerPage = this.getContainerPage(cms);
        if (currentContainerPage != null) {
            for (String cntName : currentContainerPage.getNames()) {
                Object container;
                if (currentContainers.containsKey(cntName) || ((CmsContainerBean)(container = currentContainerPage.getContainers().get(cntName))).getElements().isEmpty()) continue;
                containers.add((CmsContainerBean)container);
            }
        }
        HashMap<String, CmsContainerElementBean> hashMap = new HashMap<String, CmsContainerElementBean>();
        HashMap<String, String> parentContainers = new HashMap<String, String>();
        for (CmsContainerBean container : containers) {
            for (CmsContainerElementBean element : container.getElements()) {
                try {
                    element.initResource(cms);
                    if (CmsModelGroupHelper.isModelGroupResource(element.getResource())) continue;
                    hashMap.put(element.getInstanceId(), element);
                    parentContainers.put(element.getInstanceId(), container.getName());
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        Iterator cntIt = containers.iterator();
        while (cntIt.hasNext()) {
            boolean remove;
            CmsContainerBean container;
            container = (CmsContainerBean)cntIt.next();
            if (currentContainers.containsKey(container.getName()) || !container.isNestedContainer() || container.isRootContainer()) continue;
            boolean bl = remove = !hashMap.containsKey(container.getParentInstanceId()) || container.getElements().isEmpty();
            if (!remove) {
                CmsContainerElementBean element;
                element = (CmsContainerElementBean)hashMap.get(container.getParentInstanceId());
                String settingsKey = CmsFormatterConfig.getSettingsKeyForContainer((String)parentContainers.get(element.getInstanceId()));
                String formatterId = element.getIndividualSettings().get(settingsKey);
                I_CmsFormatterBean bean = config.findFormatter(formatterId);
                if (bean != null) {
                    boolean bl2 = remove = bean instanceof CmsFormatterBean && ((CmsFormatterBean)bean).isStrictContainers();
                }
            }
            if (!remove) continue;
            for (CmsContainerElementBean element : container.getElements()) {
                hashMap.remove(element.getInstanceId());
            }
            cntIt.remove();
        }
        return new CmsContainerPageBean(containers);
    }

    protected CmsResource fillResource(CmsObject cms, Element element, CmsUUID resourceId) throws CmsException {
        String xpath = element.getPath();
        int pos = xpath.lastIndexOf("/" + XmlNode.Containers.name() + "/");
        if (pos > 0) {
            xpath = xpath.substring(pos + 1);
        }
        CmsRelationType type = this.getHandler().getRelationType(xpath);
        CmsResource res = cms.readResource(resourceId, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsXmlVfsFileValue.fillEntry(element, res.getStructureId(), res.getRootPath(), type);
        return res;
    }

    @Override
    protected void initDocument(CmsObject cms, Document document, String encoding, CmsXmlContentDefinition definition) {
        this.m_document = document;
        this.m_contentDefinition = definition;
        this.m_encoding = CmsEncoder.lookupEncoding(encoding, encoding);
        this.m_elementLocales = new HashMap();
        this.m_elementNames = new HashMap();
        this.m_locales = new HashSet();
        this.m_cntPages = new LinkedHashMap<Locale, CmsContainerPageBean>();
        this.clearBookmarks();
        CmsADEConfigData config = null;
        CmsSettingTranslator settingTranslator = null;
        if (this.getFile() != null && cms != null) {
            config = OpenCms.getADEManager().lookupConfiguration(cms, this.getFile().getRootPath());
            settingTranslator = new CmsSettingTranslator(config);
        }
        Iterator<Element> itCntPages = CmsXmlGenericWrapper.elementIterator(this.m_document.getRootElement());
        while (itCntPages.hasNext()) {
            Element cntPage = itCntPages.next();
            try {
                Locale locale = CmsLocaleManager.getLocale(cntPage.attribute("language").getValue());
                this.addLocale(locale);
                ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
                Iterator<Element> itCnts = CmsXmlGenericWrapper.elementIterator(cntPage, XmlNode.Containers.name());
                while (itCnts.hasNext()) {
                    Element isRootContainer;
                    Element container = itCnts.next();
                    int cntIndex = CmsXmlUtils.getXpathIndexInt(container.getUniquePath(cntPage));
                    String cntPath = CmsXmlUtils.createXpathElement(container.getName(), cntIndex);
                    I_CmsXmlSchemaType cntSchemaType = definition.getSchemaType(container.getName());
                    I_CmsXmlContentValue cntValue = cntSchemaType.createValue(this, container, locale);
                    this.addBookmark(cntPath, locale, true, cntValue);
                    CmsXmlContentDefinition cntDef = ((CmsXmlNestedContentDefinition)cntSchemaType).getNestedContentDefinition();
                    Element name = container.element(XmlNode.Name.name());
                    String containerName = name.getText();
                    this.addBookmarkForElement(name, locale, container, cntPath, cntDef);
                    Element type = container.element(XmlNode.Type.name());
                    this.addBookmarkForElement(type, locale, container, cntPath, cntDef);
                    Element parentInstance = container.element(XmlNode.ParentInstanceId.name());
                    if (parentInstance != null) {
                        this.addBookmarkForElement(parentInstance, locale, container, cntPath, cntDef);
                    }
                    if ((isRootContainer = container.element(XmlNode.IsRootContainer.name())) != null) {
                        this.addBookmarkForElement(isRootContainer, locale, container, cntPath, cntDef);
                    }
                    ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
                    Iterator<Element> itElems = CmsXmlGenericWrapper.elementIterator(container, XmlNode.Elements.name());
                    while (itElems.hasNext()) {
                        String key;
                        I_CmsFormatterBean maybeFunction;
                        Element createNewElement;
                        Element element = itElems.next();
                        int elemIndex = CmsXmlUtils.getXpathIndexInt(element.getUniquePath(container));
                        String elemPath = CmsXmlUtils.concatXpath(cntPath, CmsXmlUtils.createXpathElement(element.getName(), elemIndex));
                        I_CmsXmlSchemaType elemSchemaType = cntDef.getSchemaType(element.getName());
                        I_CmsXmlContentValue elemValue = elemSchemaType.createValue(this, element, locale);
                        this.addBookmark(elemPath, locale, true, elemValue);
                        CmsXmlContentDefinition elemDef = ((CmsXmlNestedContentDefinition)elemSchemaType).getNestedContentDefinition();
                        Element instanceIdElem = element.element(XmlNode.ElementInstanceId.name());
                        String elementInstanceId = null;
                        if (instanceIdElem != null) {
                            elementInstanceId = instanceIdElem.getTextTrim();
                        }
                        Element formatterKeyElem = element.element(XmlNode.FormatterKey.name());
                        String formatterKey = null;
                        if (formatterKeyElem != null) {
                            formatterKey = formatterKeyElem.getTextTrim();
                        }
                        Element uri = element.element(XmlNode.Uri.name());
                        CmsUUID elementId = null;
                        if (uri != null) {
                            this.addBookmarkForElement(uri, locale, element, elemPath, elemDef);
                            Element uriLink = uri.element("link");
                            if (uriLink != null) {
                                CmsLink link = new CmsLink(uriLink);
                                if (cms != null) {
                                    link.checkConsistency(cms);
                                }
                                elementId = link.getStructureId();
                            }
                        }
                        boolean createNew = (createNewElement = element.element(XmlNode.CreateNew.name())) != null && Boolean.parseBoolean(createNewElement.getStringValue());
                        Element formatter = element.element(XmlNode.Formatter.name());
                        CmsUUID formatterId = null;
                        if (formatter != null) {
                            this.addBookmarkForElement(formatter, locale, element, elemPath, elemDef);
                            Element formatterLink = formatter.element("link");
                            if (formatterLink != null) {
                                CmsLink link = new CmsLink(formatterLink);
                                if (cms != null) {
                                    link.checkConsistency(cms);
                                }
                                formatterId = link.getStructureId();
                            }
                        }
                        Map<String, String> propertiesMap = CmsXmlContentPropertyHelper.readProperties(this, locale, element, elemPath, elemDef);
                        propertiesMap = this.translateMapKeys(propertiesMap, this::translateSettingNameForLoad);
                        if (config != null && this.getFile() != null) {
                            propertiesMap = this.fixNestedFormatterSettings(cms, config, propertiesMap);
                        }
                        if (formatterKey != null) {
                            propertiesMap.put("formatterSettings#" + containerName, formatterKey);
                        }
                        I_CmsFormatterBean dynamicFormatter = null;
                        if (config != null) {
                            String key1 = "formatterSettings#" + containerName;
                            String key2 = "formatterSettings#";
                            for (String key3 : new String[]{key1, key2}) {
                                I_CmsFormatterBean temp;
                                String value = propertiesMap.get(key3);
                                if (value == null || (temp = config.findFormatter(value)) == null) continue;
                                dynamicFormatter = temp;
                                propertiesMap.put(key3, dynamicFormatter.getKeyOrId());
                                break;
                            }
                        }
                        if (config != null && dynamicFormatter != null && settingTranslator != null) {
                            propertiesMap = settingTranslator.translateSettings(dynamicFormatter, propertiesMap);
                        }
                        if (elementInstanceId != null) {
                            propertiesMap.put("element_instance_id", elementInstanceId);
                        }
                        CmsUUID pageId = this.getFile() != null ? this.getFile().getStructureId() : CmsUUID.getNullUUID();
                        propertiesMap.put("SYSTEM::pageId", String.valueOf(pageId));
                        boolean createNewFromSetting = Boolean.parseBoolean(propertiesMap.remove("SYSTEM::create_new"));
                        createNew |= createNewFromSetting;
                        if (config != null && (maybeFunction = config.findFormatter(key = CmsFormatterUtils.getFormatterKey(containerName, propertiesMap))) instanceof CmsFunctionFormatterBean) {
                            elementId = new CmsUUID(maybeFunction.getId());
                        }
                        if (elementId == null) continue;
                        elements.add(new CmsContainerElementBean(elementId, formatterId, propertiesMap, createNew));
                    }
                    CmsContainerBean newContainerBean = new CmsContainerBean(name.getText(), type.getText(), parentInstance != null ? parentInstance.getText() : null, isRootContainer != null && Boolean.valueOf(isRootContainer.getText()) != false, elements);
                    containers.add(newContainerBean);
                }
                this.m_cntPages.put(locale, new CmsContainerPageBean(containers));
            }
            catch (NullPointerException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_INIT_BOOKMARKS_0"), (Throwable)e);
            }
        }
        if (cms != null) {
            this.getHandler().invalidateBrokenLinks(cms, this);
        }
    }

    @Override
    protected void initDocument(Document document, String encoding, CmsXmlContentDefinition definition) {
        this.initDocument(null, document, encoding, definition);
    }

    protected CmsContainerPageBean removeEmptyContainers(CmsContainerPageBean cntPage) {
        ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>();
        for (CmsContainerBean container : cntPage.getContainers().values()) {
            if (container.getElements().size() <= 0) continue;
            containers.add(container);
        }
        return new CmsContainerPageBean(containers);
    }

    protected void saveContainerPage(CmsObject cms, Element parent, CmsContainerPageBean cntPage) throws CmsException {
        parent.clearContent();
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, this.getFile().getRootPath());
        if (adeConfig.isUseFormatterKeys()) {
            this.saveContainerPageV2(cms, parent, cntPage, adeConfig);
        } else {
            this.saveContainerPageV1(cms, parent, cntPage, adeConfig);
        }
    }

    @Override
    protected void setFile(CmsFile file) {
        super.setFile(file);
    }

    private Map<String, String> fixNestedFormatterSettings(CmsObject cms, CmsADEConfigData config, Map<String, String> propertiesMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
            String prefix;
            I_CmsFormatterBean formatter;
            Object key = entry.getKey();
            int underscorePos = ((String)key).indexOf("_");
            if (underscorePos >= 0 && (formatter = config.findFormatter(prefix = ((String)key).substring(0, underscorePos), true)) != null) {
                key = formatter.getKeyOrId() + ((String)key).substring(underscorePos);
            }
            result.put((String)key, entry.getValue());
        }
        return result;
    }

    private Map<String, String> processSettingsForSaveV1(CmsADEConfigData config, Map<String, String> settings) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            Object key = entry.getKey();
            String value = entry.getValue();
            if (((String)key).startsWith("formatterSettings#")) {
                I_CmsFormatterBean dynamicFmt;
                if (!CmsUUID.isValidUUID(value) && (dynamicFmt = config.findFormatter(value)) != null && dynamicFmt.getId() != null) {
                    value = dynamicFmt.getId();
                }
            } else {
                int underscorePos = ((String)key).indexOf("_");
                if (underscorePos != -1) {
                    String id;
                    String partBeforeUnderscore = ((String)key).substring(0, underscorePos);
                    String partAfterUnderscore = ((String)key).substring(underscorePos + 1);
                    I_CmsFormatterBean dynamicFmt = config.findFormatter(partBeforeUnderscore);
                    if (dynamicFmt != null && dynamicFmt.getSettings(config).containsKey(partAfterUnderscore) && (id = dynamicFmt.getId()) != null) {
                        key = id + "_" + partAfterUnderscore;
                    }
                }
            }
            result.put((String)key, value);
        }
        result.remove("SYSTEM::pageId");
        return result;
    }

    private Map<String, String> processSettingsForSaveV2(CmsADEConfigData config, Map<String, String> settings) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            I_CmsFormatterBean dynamicFmt;
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith("formatterSettings#") && CmsUUID.isValidUUID(value) && (dynamicFmt = config.findFormatter(value)) != null && dynamicFmt.getKey() != null) {
                value = dynamicFmt.getKey();
            }
            result.put(key, value);
        }
        result.remove("SYSTEM::pageId");
        result = this.sortSettingsForSave(this.translateMapKeys(result, this::translateSettingNameForSave));
        return result;
    }

    private void saveContainerPageV1(CmsObject cms, Element parent, CmsContainerPageBean cntPage, CmsADEConfigData adeConfig) throws CmsException {
        ArrayList<String> containerNames = new ArrayList<String>(cntPage.getNames());
        Collections.sort(containerNames);
        for (String containerName : containerNames) {
            CmsContainerBean container = cntPage.getContainers().get(containerName);
            Element cntElement = parent.addElement(XmlNode.Containers.name());
            cntElement.addElement(XmlNode.Name.name()).addCDATA(container.getName());
            cntElement.addElement(XmlNode.Type.name()).addCDATA(container.getType());
            if (container.isNestedContainer()) {
                cntElement.addElement(XmlNode.ParentInstanceId.name()).addCDATA(container.getParentInstanceId());
            }
            if (container.isRootContainer()) {
                cntElement.addElement(XmlNode.IsRootContainer.name()).addText(Boolean.TRUE.toString());
            }
            for (CmsContainerElementBean element : container.getElements()) {
                Element elemElement = cntElement.addElement(XmlNode.Elements.name());
                Element uriElem = elemElement.addElement(XmlNode.Uri.name());
                CmsResource uriRes = this.fillResource(cms, uriElem, element.getId());
                if (element.getFormatterId() != null) {
                    Element formatterElem = elemElement.addElement(XmlNode.Formatter.name());
                    this.fillResource(cms, formatterElem, element.getFormatterId());
                }
                if (element.isCreateNew()) {
                    Element createNewElem = elemElement.addElement(XmlNode.CreateNew.name());
                    createNewElem.addText(Boolean.TRUE.toString());
                }
                Map<String, String> properties = element.getIndividualSettings();
                Map<String, String> processedSettings = this.processSettingsForSaveV1(adeConfig, properties);
                Map<String, CmsXmlContentProperty> propertiesConf = OpenCms.getADEManager().getElementSettings(cms, uriRes);
                CmsXmlContentPropertyHelper.saveProperties(cms, elemElement, processedSettings, propertiesConf, true);
            }
        }
    }

    private void saveContainerPageV2(CmsObject cms, Element parent, CmsContainerPageBean cntPage, CmsADEConfigData adeConfig) throws CmsException {
        List<String> containerNames = this.sortContainerNames(cntPage);
        for (String containerName : containerNames) {
            CmsContainerBean container = cntPage.getContainers().get(containerName);
            Element cntElement = parent.addElement(XmlNode.Containers.name());
            cntElement.addElement(XmlNode.Name.name()).addCDATA(container.getName());
            cntElement.addElement(XmlNode.Type.name()).addCDATA(container.getType());
            if (container.isNestedContainer()) {
                cntElement.addElement(XmlNode.ParentInstanceId.name()).addCDATA(container.getParentInstanceId());
            }
            if (container.isRootContainer()) {
                cntElement.addElement(XmlNode.IsRootContainer.name()).addText(Boolean.TRUE.toString());
            }
            for (CmsContainerElementBean element : container.getElements()) {
                CmsResource elementRes;
                Element elemElement = cntElement.addElement(XmlNode.Elements.name());
                HashMap<String, String> properties = new HashMap<String, String>(element.getIndividualSettings());
                String instanceId = (String)properties.remove("element_instance_id");
                if (instanceId != null) {
                    Element instanceIdElem = elemElement.addElement(XmlNode.ElementInstanceId.name());
                    instanceIdElem.addText(instanceId);
                }
                String formatterKey = CmsFormatterUtils.removeFormatterKey(containerName, properties);
                I_CmsFormatterBean formatter = null;
                if (formatterKey != null) {
                    Element formatterKeyElem = elemElement.addElement(XmlNode.FormatterKey.name());
                    formatter = adeConfig.findFormatter(formatterKey);
                    if (formatter != null && formatter.getKeyOrId() != null) {
                        formatterKey = formatter.getKeyOrId();
                    }
                    formatterKeyElem.addText(formatterKey);
                }
                if (!(formatter instanceof CmsFunctionFormatterBean)) {
                    Element uriElem = elemElement.addElement(XmlNode.Uri.name());
                    elementRes = this.fillResource(cms, uriElem, element.getId());
                    if (element.getFormatterId() != null && formatterKey == null) {
                        Element formatterElem = elemElement.addElement(XmlNode.Formatter.name());
                        this.fillResource(cms, formatterElem, element.getFormatterId());
                    }
                } else {
                    elementRes = cms.readResource(element.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
                }
                if (element.isCreateNew()) {
                    properties.put("SYSTEM::create_new", "true");
                }
                Map<String, String> processedSettings = this.processSettingsForSaveV2(adeConfig, properties);
                String valAlways = "always";
                String valFalse = "false";
                String storeDefaultSettings = adeConfig.getAttribute(ATTR_STORE_DEFAULT_SETTINGS, "false");
                if ("false".equals(storeDefaultSettings) || "always".equals(storeDefaultSettings)) {
                    CmsFormatterConfiguration formatterConfig;
                    List<I_CmsFormatterBean> formatters;
                    if (formatter == null && (formatters = (formatterConfig = adeConfig.getFormatters(cms, elementRes)).getFormattersForKey(formatterKey)).size() > 0) {
                        formatter = formatters.get(0);
                    }
                    Map<String, CmsXmlContentProperty> settingDefs = OpenCms.getADEManager().getFormatterSettings(cms, adeConfig, formatter, elementRes, cms.getRequestContext().getLocale(), null);
                    HashMap<String, String> settingDefaults = new HashMap<String, String>();
                    HashMap<String, String> visibleSettingDefaults = new HashMap<String, String>();
                    for (Map.Entry<String, CmsXmlContentProperty> entry : settingDefs.entrySet()) {
                        if (!"hidden".equals(entry.getValue().getWidget())) {
                            visibleSettingDefaults.put(entry.getKey(), entry.getValue().getDefault());
                        }
                        settingDefaults.put(entry.getKey(), entry.getValue().getDefault());
                    }
                    if ("false".equals(storeDefaultSettings)) {
                        Iterator<Map.Entry<String, String>> entryIter = processedSettings.entrySet().iterator();
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        while (entryIter.hasNext()) {
                            Map.Entry<String, String> settingEntry = entryIter.next();
                            if (!settingDefaults.containsKey(settingEntry.getKey()) || !Objects.equals(settingEntry.getValue(), settingDefaults.get(settingEntry.getKey()))) continue;
                            hashMap.put(settingEntry.getKey(), settingEntry.getValue());
                            entryIter.remove();
                        }
                        if (hashMap.size() > 0 && LOG.isDebugEnabled()) {
                            LOG.debug((Object)((String)(this.m_file != null ? this.m_file.getRootPath() + ": " : "") + "Removed default settings for " + elementRes.getRootPath() + ":" + String.valueOf(hashMap)));
                        }
                    } else if ("always".equals(storeDefaultSettings)) {
                        for (Map.Entry<String, CmsXmlContentProperty> entry : visibleSettingDefaults.entrySet()) {
                            String defaultValue;
                            if (processedSettings.containsKey(entry.getKey()) || (defaultValue = (String)((Object)entry.getValue())) == null) continue;
                            processedSettings.put(entry.getKey(), defaultValue);
                        }
                        processedSettings = this.sortSettingsForSave(processedSettings);
                    }
                }
                Map<String, CmsXmlContentProperty> propertiesConf = OpenCms.getADEManager().getElementSettings(cms, elementRes);
                CmsXmlContentPropertyHelper.saveProperties(cms, elemElement, processedSettings, propertiesConf, false);
            }
        }
    }

    private List<String> sortContainerNames(CmsContainerPageBean page) {
        ArrayListMultimap containersByParentId = ArrayListMultimap.create();
        HashMap<String, CmsContainerElementBean> elementsById = new HashMap<String, CmsContainerElementBean>();
        ArrayList<CmsContainerBean> rootContainers = new ArrayList<CmsContainerBean>();
        for (CmsContainerBean container : page.getContainers().values()) {
            for (CmsContainerElementBean element : container.getElements()) {
                if (element.getInstanceId() == null) continue;
                elementsById.put(element.getInstanceId(), element);
            }
        }
        for (CmsContainerBean container : page.getContainers().values()) {
            String parentInstanceId = container.getParentInstanceId();
            if (parentInstanceId != null) {
                containersByParentId.put((Object)parentInstanceId, (Object)container);
            }
            if (parentInstanceId != null && elementsById.containsKey(parentInstanceId)) continue;
            rootContainers.add(container);
        }
        rootContainers.sort((a, b) -> b.getName().compareTo(a.getName()));
        ArrayList<CmsContainerBean> stack = new ArrayList<CmsContainerBean>();
        stack.addAll(rootContainers);
        HashMap<String, Integer> order = new HashMap<String, Integer>();
        int counter = 0;
        while (stack.size() > 0) {
            CmsContainerBean container = (CmsContainerBean)stack.remove(stack.size() - 1);
            if (order.containsKey(container.getName())) continue;
            order.put(container.getName(), counter);
            ++counter;
            for (CmsContainerElementBean element : container.getElements()) {
                String instanceId = element.getInstanceId();
                if (instanceId == null) continue;
                ArrayList childContainers = new ArrayList(containersByParentId.get((Object)instanceId));
                childContainers.sort((a, b) -> b.getName().compareTo(a.getName()));
                stack.addAll(childContainers);
            }
        }
        ArrayList<String> result = new ArrayList<String>(page.getContainers().keySet());
        result.sort((a, b) -> ComparisonChain.start().compare((Object)((Integer)order.get(a)), (Object)((Integer)order.get(b)), (Comparator)Ordering.natural().nullsLast()).compare((Comparable)((Object)a), (Comparable)((Object)b)).result());
        return result;
    }

    private LinkedHashMap<String, String> sortSettingsForSave(Map<String, String> settings) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        ArrayList<String> keys = new ArrayList<String>(settings.keySet());
        keys.sort((a, b) -> ComparisonChain.start().compareTrueFirst(a.startsWith(SYSTEM_SETTING_PREFIX), b.startsWith(SYSTEM_SETTING_PREFIX)).compare((Comparable)((Object)a), (Comparable)((Object)b)).result());
        for (String key : keys) {
            result.put(key, settings.get(key));
        }
        return result;
    }

    private Map<String, String> translateMapKeys(Map<String, String> settings, Function<String, String> translation) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        settings.entrySet().forEach(e -> result.put((String)translation.apply((String)e.getKey()), (String)e.getValue()));
        return result;
    }

    private String translateSettingNameForLoad(String name) {
        String remainder;
        if (name.startsWith(SYSTEM_SETTING_PREFIX) && LEGACY_SYSTEM_SETTING_NAMES.contains(remainder = name.substring(SYSTEM_SETTING_PREFIX.length()))) {
            return remainder;
        }
        return name;
    }

    private String translateSettingNameForSave(String name) {
        if (LEGACY_SYSTEM_SETTING_NAMES.contains(name)) {
            return SYSTEM_SETTING_PREFIX + name;
        }
        return name;
    }

    public static enum XmlNode {
        Attribute,
        Containers,
        CreateNew,
        ElementInstanceId,
        Elements,
        Formatter,
        FormatterKey,
        IsRootContainer,
        Key,
        Name,
        ParentInstanceId,
        Type,
        Uri,
        Value;

    }
}

