/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.formatters.CmsSettingConfiguration;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsMetaMapping;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsMacroFormatterBean
extends CmsFormatterBean {
    private String m_defaultContentRootPath;
    private CmsUUID m_defaultContentStructureId;
    private String m_macroInput;
    private boolean m_online;
    private String m_placeholderMacroInput;
    private Map<String, CmsUUID> m_referencedFormatters;

    public CmsMacroFormatterBean(Set<String> containerTypes, String jspRootPath, CmsUUID jspStructureId, int minWidth, int maxWidth, boolean searchContent, String location, String niceName, String description, Collection<String> resourceTypeNames, int rank, String id, String defaultContentRootPath, CmsUUID defaultContentStructureId, CmsSettingConfiguration settingConfig, boolean isAutoEnabled, boolean isDetail, String displayType, boolean isAllowsSettingsInEditor, String macroInput, String placeholderMacroInput, Map<String, CmsUUID> referencedFormatters, boolean online, List<CmsMetaMapping> metaMappings, boolean useMetaMappingsForNormalElements) {
        super(containerTypes, jspRootPath, jspStructureId, null, new HashSet<String>(), minWidth, maxWidth, false, searchContent, location, Collections.emptyList(), "", Collections.emptyList(), "", Collections.emptyList(), niceName, description, resourceTypeNames, rank, id, settingConfig, true, isAutoEnabled, isDetail, displayType, isAllowsSettingsInEditor, false, false, metaMappings, Collections.emptyMap(), useMetaMappingsForNormalElements);
        this.m_macroInput = macroInput;
        this.m_placeholderMacroInput = placeholderMacroInput;
        this.m_referencedFormatters = Collections.unmodifiableMap(referencedFormatters);
        this.m_online = online;
        this.m_defaultContentRootPath = defaultContentRootPath;
        this.m_defaultContentStructureId = defaultContentStructureId;
    }

    public String getDefaultContentRootPath() {
        return this.m_defaultContentRootPath;
    }

    public CmsUUID getDefaultContentStructureId() {
        return this.m_defaultContentStructureId;
    }

    public String getMacroInput() {
        return this.m_macroInput;
    }

    public String getPlaceholderMacroInput() {
        return this.m_placeholderMacroInput;
    }

    public Map<String, CmsUUID> getReferencedFormatters() {
        return this.m_referencedFormatters;
    }

    @Override
    public Map<String, CmsXmlContentProperty> getSettings(CmsADEConfigData config) {
        LinkedHashMap<String, CmsXmlContentProperty> settings = new LinkedHashMap<String, CmsXmlContentProperty>(super.getSettings(config));
        for (CmsUUID formatterId : this.m_referencedFormatters.values()) {
            I_CmsFormatterBean formatter = OpenCms.getADEManager().getCachedFormatters(this.m_online).getFormatters().get(formatterId);
            if (formatter == null) continue;
            for (Map.Entry<String, CmsXmlContentProperty> entry : formatter.getSettings(config).entrySet()) {
                if (settings.containsKey(entry.getKey())) continue;
                settings.put(entry.getKey(), entry.getValue());
            }
        }
        return settings;
    }
}

