/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;

public class CmsLazyFolder {
    private CmsResource m_folder;
    private String m_path;

    public CmsLazyFolder(CmsResource folder) {
        assert (folder != null);
        this.m_folder = folder;
        this.m_path = null;
    }

    public CmsLazyFolder(String path) {
        assert (path != null);
        this.m_path = path;
        this.m_folder = null;
    }

    public CmsResource createFolder(CmsObject cms) throws CmsException {
        if (this.m_folder != null) {
            return this.m_folder;
        }
        return cms.createResource(this.m_path, OpenCms.getResourceManager().getResourceType("folder").getTypeId());
    }

    public CmsResource getFolder(CmsObject cms) throws CmsException {
        if (this.m_folder != null) {
            return this.m_folder;
        }
        try {
            CmsResource folder = cms.readResource(this.m_path);
            return folder;
        }
        catch (CmsVfsResourceNotFoundException e) {
            return null;
        }
    }

    public CmsResource getOrCreateFolder(CmsObject cms) throws CmsException {
        CmsResource result = this.getFolder(cms);
        if (result != null) {
            return result;
        }
        return this.createFolder(cms);
    }

    public CmsResource getPermissionCheckFolder(CmsObject cms) throws CmsException {
        CmsResource folder = this.getFolder(cms);
        if (folder != null) {
            return folder;
        }
        String parentPath = CmsResource.getParentFolder(this.m_path);
        CmsResource parent = cms.readResource(parentPath);
        return parent;
    }

    public String getSitePath(CmsObject cms) {
        if (this.m_path != null) {
            return this.m_path;
        }
        if (this.m_folder != null) {
            return cms.getRequestContext().removeSiteRoot(this.m_folder.getRootPath());
        }
        return null;
    }
}

