/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.util.Comparator;
import org.opencms.acacia.shared.CmsContentDefinition;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlDisplayOrderPathComparator
implements Comparator<String> {
    private CmsXmlContentDefinition m_definition;

    public CmsXmlDisplayOrderPathComparator(CmsXmlContentDefinition definition) {
        this.m_definition = definition;
    }

    @Override
    public int compare(String p1, String p2) {
        String firstPart2;
        int firstSlash1 = p1.indexOf(47);
        int firstSlash2 = p2.indexOf(47);
        String firstPart1 = firstSlash1 > 0 ? p1.substring(0, firstSlash1) : p1;
        String string = firstPart2 = firstSlash2 > 0 ? p2.substring(0, firstSlash2) : p2;
        if (firstPart1.equals(firstPart2)) {
            CmsXmlDisplayOrderPathComparator subComparator = new CmsXmlDisplayOrderPathComparator(this.m_definition.getSchemaType(CmsContentDefinition.removeIndex(firstPart1)).getContentDefinition());
            return subComparator.compare(p1.substring(firstSlash1 + 1, p1.length()), p2.substring(firstSlash2 + 1, p2.length()));
        }
        String firstNode1 = CmsXmlUtils.removeXpathIndex(firstPart1);
        int idx1 = CmsXmlUtils.getXpathIndexInt(firstPart1);
        String firstNode2 = CmsXmlUtils.removeXpathIndex(firstPart2);
        int idx2 = CmsXmlUtils.getXpathIndexInt(firstPart2);
        if (firstNode1.equals(firstNode2)) {
            return idx1 - idx2;
        }
        for (I_CmsXmlSchemaType t : this.m_definition.getTypeSequence()) {
            if (t.getName().equals(firstNode1)) {
                return -1;
            }
            if (!t.getName().equals(firstNode2)) continue;
            return 1;
        }
        return 0;
    }
}

