/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.http.client.utils.URIBuilder;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsLinkFinisher {
    private static final Log LOG = CmsLog.getLog(CmsLinkFinisher.class);
    private boolean m_enabled;
    private Set<String> m_defaultFileNames;
    private Pattern m_excludePattern;

    public CmsLinkFinisher(boolean enabled, Collection<String> defaultFileNames, String exclude) {
        this.m_enabled = enabled;
        this.m_defaultFileNames = Collections.unmodifiableSet(new HashSet<String>(defaultFileNames));
        if (exclude != null) {
            try {
                this.m_excludePattern = Pattern.compile(exclude);
            }
            catch (PatternSyntaxException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public String transformLink(String link, boolean full) {
        if (!this.m_enabled) {
            return link;
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(link)) {
            return link;
        }
        if (link.startsWith("/system/config/showversion")) {
            return link;
        }
        if (link.startsWith("javascript:")) {
            return link;
        }
        if (this.m_excludePattern != null && this.m_excludePattern.matcher(link).matches()) {
            return link;
        }
        try {
            URI uri = new URI(link);
            URIBuilder builder = new URIBuilder(uri);
            String path = builder.getPath();
            if (path != null) {
                String name;
                path = path.replaceFirst("/$", "");
                if (full && path.length() > 1 && this.m_defaultFileNames.contains(name = CmsResource.getName(path))) {
                    path = path.substring(0, path.lastIndexOf(47));
                }
                if (uri.getAuthority() == null && "".equals(path)) {
                    path = "/";
                }
                builder.setPath(path);
                link = builder.toString();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return link;
    }
}

