/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.threads.Messages;

public final class CmsXmlContentRepairSettings {
    private final CmsObject m_cms;
    private boolean m_force;
    private boolean m_includeSubFolders;
    private String m_resourceType;
    private String m_vfsFolder;

    public CmsXmlContentRepairSettings(CmsObject cms) {
        this.m_cms = cms;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public String getVfsFolder() {
        return this.m_vfsFolder;
    }

    public boolean isForce() {
        return this.m_force;
    }

    public boolean isIncludeSubFolders() {
        return this.m_includeSubFolders;
    }

    public void setForce(boolean force) {
        this.m_force = force;
    }

    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.m_includeSubFolders = includeSubFolders;
    }

    public void setResourceType(String resourceType) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(resourceType)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_VALUE_EMPTY_0"));
        }
        this.m_resourceType = resourceType;
    }

    public void setVfsFolder(String vfsFolder) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(vfsFolder)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_VALUE_EMPTY_0"));
        }
        if (!this.m_cms.existsResource(vfsFolder, CmsResourceFilter.ALL.addRequireFolder())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_XMLCONTENT_VFSFOLDER_1", vfsFolder));
        }
        this.m_vfsFolder = vfsFolder;
    }

    protected int getResourceTypeId() {
        if (CmsStringUtil.isNotEmpty(this.getResourceType())) {
            try {
                return OpenCms.getResourceManager().getResourceType(this.getResourceType()).getTypeId();
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return -1;
    }
}

