/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.galleries.A_CmsAjaxGallery;

public class CmsAjaxLinkGallery
extends A_CmsAjaxGallery {
    public static final String GALLERYTYPE_NAME = "linkgallery";
    public static final String OPEN_URI_SUFFIX = "linkgallery/index.jsp";
    private static final Log LOG = CmsLog.getLog(CmsAjaxLinkGallery.class);
    private int m_galleryTypeId;

    public CmsAjaxLinkGallery() {
    }

    public CmsAjaxLinkGallery(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsAjaxLinkGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public int getGalleryItemsTypeId() {
        int pointerId;
        try {
            pointerId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePointer.getStaticTypeName()).getTypeId();
        }
        catch (CmsLoaderException e) {
            pointerId = CmsResourceTypePointer.getStaticTypeId();
        }
        return pointerId;
    }

    @Override
    public int getGalleryTypeId() {
        block2: {
            try {
                this.m_galleryTypeId = OpenCms.getResourceManager().getResourceType(GALLERYTYPE_NAME).getTypeId();
            }
            catch (CmsLoaderException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.m_galleryTypeId;
    }

    @Override
    public String getGalleryTypeName() {
        return GALLERYTYPE_NAME;
    }

    @Override
    protected void buildJsonItemSpecificPart(JSONObject jsonObj, CmsResource res, String sitePath) {
        block4: {
            try {
                String pointer = new String(this.getCms().readFile(res).getContents());
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(pointer)) {
                    pointer = this.getJsp().link(this.getCms().getSitePath(res));
                }
                jsonObj.append("pointer", pointer);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected void changeItemLinkUrl(String itemUrl) {
        block6: {
            try {
                JspWriter out = this.getJsp().getJspContext().getOut();
                if (this.getCms().existsResource(itemUrl)) {
                    try {
                        this.writePointerLink(this.getCms().readResource(itemUrl));
                        out.print((Object)this.buildJsonItemObject(this.getCms().readResource(itemUrl)));
                    }
                    catch (CmsException cmsException) {}
                } else {
                    out.print("none");
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void writePointerLink(CmsResource res) throws CmsException {
        String resPath = this.getCms().getSitePath(res);
        String currentPropertyValue = this.getParamPropertyValue();
        boolean locked = true;
        CmsLock lock = this.getCms().getLock(res);
        if (lock.isUnlocked()) {
            this.getCms().lockResource(resPath);
            locked = false;
        }
        CmsFile file = this.getCms().readFile(res);
        file.setContents(currentPropertyValue.getBytes());
        this.checkLock(this.getCms().getSitePath(res));
        this.getCms().writeFile(file);
        if (!locked) {
            this.getCms().unlockResource(resPath);
        }
    }
}

