/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.shared.CmsDialogOptions;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.serialdate.CmsSerialDateBeanFactory;
import org.opencms.widgets.serialdate.CmsSerialDateValue;
import org.opencms.widgets.serialdate.I_CmsSerialDateBean;
import org.opencms.workplace.editors.directedit.I_CmsEditHandler;
import org.opencms.workplace.editors.directedit.Messages;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsDateSeriesEditHandler
implements I_CmsEditHandler {
    public static final String PARAM_INSTANCEDATE = "instancedate";

    @Override
    public CmsDialogOptions getDeleteOptions(CmsObject cms, CmsContainerElementBean elementBean, CmsUUID pageContextId, Map<String, String[]> requestParams) {
        InternalHandler internalHandler = new InternalHandler(cms, elementBean, requestParams, pageContextId);
        return internalHandler.getDeleteOptions();
    }

    @Override
    public CmsDialogOptions getEditOptions(CmsObject cms, CmsContainerElementBean elementBean, CmsUUID pageContextId, Map<String, String[]> requestParams, boolean isListElement) {
        InternalHandler internalHandler = new InternalHandler(cms, elementBean, requestParams, pageContextId);
        return internalHandler.getEditOptions(isListElement);
    }

    @Override
    public CmsDialogOptions getNewOptions(CmsObject cms, CmsContainerElementBean elementBean, CmsUUID pageContextId, Map<String, String[]> requestParam) {
        return null;
    }

    @Override
    public void handleDelete(CmsObject cms, CmsContainerElementBean elementBean, String deleteOption, CmsUUID pageContextId, Map<String, String[]> requestParams) throws CmsException {
        InternalHandler internalHandler = new InternalHandler(cms, elementBean, requestParams, pageContextId);
        internalHandler.handleDelete(deleteOption);
    }

    @Override
    public String handleNew(CmsObject cms, String newLink, Locale locale, String referenceSitePath, String modelFileSitePath, String postCreateHandler, CmsContainerElementBean element, CmsUUID pageId, Map<String, String[]> requestParams, String choice) {
        return null;
    }

    @Override
    public CmsUUID prepareForEdit(CmsObject cms, CmsContainerElementBean elementBean, String editOption, CmsUUID pageContextId, Map<String, String[]> requestParams) throws CmsException {
        if (Objects.equals("series", editOption)) {
            return elementBean.getId();
        }
        InternalHandler internalHandler = new InternalHandler(cms, elementBean, requestParams, pageContextId);
        return internalHandler.prepareForEdit(editOption);
    }

    @Override
    public void setParameters(Map<String, String> params) {
    }

    private static class InternalHandler {
        private static final Log LOG = CmsLog.getLog(InternalHandler.class);
        private static final String OPTION_INSTANCE = "instance";
        private static final String OPTION_SERIES = "series";
        private CmsObject m_cms;
        private CmsXmlContent m_content;
        private I_CmsXmlContentValue m_contentValue;
        private CmsContainerElementBean m_elementBean;
        private CmsFile m_file;
        private Date m_instanceDate;
        private CmsUUID m_pageContextId;
        private Map<String, String[]> m_requestParameters;
        private I_CmsSerialDateBean m_series;
        private CmsSerialDateValue m_value;

        public InternalHandler(CmsObject cms, CmsContainerElementBean elementBean, Map<String, String[]> requestParams, CmsUUID pageContextId) {
            try {
                this.m_cms = cms;
                this.m_elementBean = elementBean;
                this.m_requestParameters = requestParams;
                this.m_pageContextId = pageContextId;
                elementBean.initResource(cms);
                CmsResource res = elementBean.getResource();
                this.m_file = cms.readFile(res);
                this.m_content = CmsXmlContentFactory.unmarshal(cms, this.m_file);
                this.m_contentValue = this.getSerialDateContentValue(this.m_content, null);
                this.m_value = this.m_contentValue != null ? new CmsSerialDateValue(this.m_contentValue.getStringValue(cms)) : null;
                this.m_series = CmsSerialDateBeanFactory.createSerialDateBean(this.m_value);
                this.setInstanceDate();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to determine all information to edit the instance of the date series.", (Throwable)e);
            }
        }

        public CmsDialogOptions getDeleteOptions() {
            if (null != this.m_instanceDate) {
                Locale wpl = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
                CmsMessages messages = Messages.get().getBundle(wpl);
                if (!this.m_value.getPatternType().equals((Object)I_CmsSerialDateValue.PatternType.NONE)) {
                    ArrayList<CmsDialogOptions.Option> options = new ArrayList<CmsDialogOptions.Option>(2);
                    String instanceDate = DateFormat.getDateInstance(1, wpl).format(this.m_instanceDate);
                    CmsDialogOptions.Option oInstance = new CmsDialogOptions.Option(OPTION_INSTANCE, messages.key("GUI_DATE_SERIES_HANDLER_DELETE_OPTION_INSTANCE_1", instanceDate), messages.key("GUI_DATE_SERIES_HANDLER_DELETE_OPTION_INSTANCE_HELP_ACTIVE_1", instanceDate), false);
                    options.add(oInstance);
                    CmsDialogOptions.Option oSeries = new CmsDialogOptions.Option("regular_delete", messages.key("GUI_DATE_SERIES_HANDLER_DELETE_OPTION_SERIES_0"), messages.key("GUI_DATE_SERIES_HANDLER_DELETE_OPTION_SERIES_HELP_ACTIVE_0"), false);
                    options.add(oSeries);
                    return new CmsDialogOptions(messages.key("GUI_DATE_SERIES_HANDLER_DELETE_DIALOG_HEADING_0"), messages.key("GUI_DATE_SERIES_HANDLER_DELETE_DIALOG_INFO_1", this.getTitle(wpl)), options);
                }
            }
            return null;
        }

        public CmsDialogOptions getEditOptions(boolean isListElement) {
            if (null != this.m_instanceDate) {
                Locale wpl = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
                CmsMessages messages = Messages.get().getBundle(wpl);
                if (!this.m_value.getPatternType().equals((Object)I_CmsSerialDateValue.PatternType.NONE)) {
                    ArrayList<CmsDialogOptions.Option> options = new ArrayList<CmsDialogOptions.Option>(2);
                    String instanceDate = DateFormat.getDateInstance(1, wpl).format(this.m_instanceDate);
                    CmsDialogOptions.Option oInstance = !isListElement && !this.isContainerPageLockable() ? new CmsDialogOptions.Option(OPTION_INSTANCE, messages.key("GUI_DATE_SERIES_HANDLER_EDIT_OPTION_INSTANCE_1", instanceDate), messages.key("GUI_DATE_SERIES_HANDLER_EDIT_OPTION_INSTANCE_HELP_INACTIVE_1", instanceDate), true) : new CmsDialogOptions.Option(OPTION_INSTANCE, messages.key("GUI_DATE_SERIES_HANDLER_EDIT_OPTION_INSTANCE_1", instanceDate), messages.key("GUI_DATE_SERIES_HANDLER_EDIT_OPTION_INSTANCE_HELP_ACTIVE_1", instanceDate), false);
                    options.add(oInstance);
                    CmsDialogOptions.Option oSeries = new CmsDialogOptions.Option(OPTION_SERIES, messages.key("GUI_DATE_SERIES_HANDLER_EDIT_OPTION_SERIES_0"), messages.key("GUI_DATE_SERIES_HANDLER_EDIT_OPTION_SERIES_HELP_ACTIVE_0"), false);
                    options.add(oSeries);
                    return new CmsDialogOptions(messages.key("GUI_DATE_SERIES_HANDLER_EDIT_DIALOG_HEADING_0"), messages.key("GUI_DATE_SERIES_HANDLER_EDIT_DIALOG_INFO_1", this.getTitle(wpl)), options);
                }
            }
            return null;
        }

        public void handleDelete(String deleteOption) throws CmsException {
            if (!Objects.equals(deleteOption, OPTION_INSTANCE)) {
                throw new CmsException(new CmsMessageContainer(Messages.get(), "ERR_DATE_SERIES_HANDLER_INVALID_DELETE_OPTION_1", deleteOption));
            }
            this.addExceptionForInstance();
        }

        public CmsUUID prepareForEdit(String editOption) throws CmsException {
            if (Objects.equals(OPTION_INSTANCE, editOption)) {
                return this.extractDate();
            }
            throw new CmsException(new CmsMessageContainer(Messages.get(), "ERR_DATE_SERIES_HANDLER_INVALID_EDIT_OPTION_1", editOption));
        }

        private void addExceptionForInstance() throws CmsException {
            if (null != this.m_instanceDate) {
                try {
                    this.m_cms.lockResource(this.m_file);
                    this.m_value.addException(this.m_instanceDate);
                    String stringValue = this.m_value.toString();
                    for (Locale l : this.m_content.getLocales()) {
                        I_CmsXmlContentValue contentValue = this.getSerialDateContentValue(this.m_content, l);
                        contentValue.setStringValue(this.m_cms, stringValue);
                    }
                    this.m_file.setContents(this.m_content.marshal());
                    this.m_cms.writeFile(this.m_file);
                    this.m_cms.unlockResource(this.m_file);
                }
                catch (Exception e) {
                    throw new CmsException(new CmsMessageContainer(Messages.get(), "ERR_DATE_SERIES_HANDLER_ADD_EXCEPTION_FAILED_0"), (Throwable)e);
                }
            } else {
                throw new CmsException(new CmsMessageContainer(Messages.get(), "ERR_DATE_SERIES_HANDLER_ADD_EXCEPTION_FAILED_MISSING_DATE_0"));
            }
        }

        private CmsUUID extractDate() throws CmsException {
            if (null != this.m_instanceDate) {
                try {
                    CmsResource page = this.m_cms.readResource(this.m_pageContextId);
                    CmsResourceTypeConfig typeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, page.getRootPath()).getResourceType(OpenCms.getResourceManager().getResourceType(this.m_file).getTypeName());
                    String pattern = typeConfig.getNamePattern(true);
                    String newSitePath = OpenCms.getResourceManager().getNameGenerator().getNewFileName(this.m_cms, CmsResource.getFolderPath(this.m_file.getRootPath()) + pattern, 5);
                    String oldSitePath = this.m_cms.getSitePath(this.m_file);
                    this.m_cms.copyResource(oldSitePath, newSitePath);
                    CmsFile newFile = this.m_cms.readFile(newSitePath);
                    CmsXmlContent newContent = CmsXmlContentFactory.unmarshal(this.m_cms, newFile);
                    CmsSerialDateValue newValue = new CmsSerialDateValue();
                    newValue.setStart(this.m_instanceDate);
                    if (this.m_value.getEnd() != null && this.m_series.getEventDuration() != null) {
                        newValue.setEnd(new Date(this.m_instanceDate.getTime() + this.m_series.getEventDuration()));
                    }
                    newValue.setParentSeriesId(this.m_file.getStructureId());
                    newValue.setWholeDay(this.m_value.isWholeDay());
                    newValue.setPatternType(I_CmsSerialDateValue.PatternType.NONE);
                    String newValueString = newValue.toString();
                    for (Locale l : newContent.getLocales()) {
                        I_CmsXmlContentValue newContentValue = this.getSerialDateContentValue(newContent, l);
                        newContentValue.setStringValue(this.m_cms, newValueString);
                    }
                    newFile.setContents(newContent.marshal());
                    this.m_cms.writeFile(newFile);
                    this.m_cms.unlockResource(newFile);
                    this.addExceptionForInstance();
                    return newFile.getStructureId();
                }
                catch (Exception e) {
                    throw new CmsException(new CmsMessageContainer(Messages.get(), "ERR_DATE_SERIES_HANDLER_EXTRACT_CONTENT_FAILED_0"), (Throwable)e);
                }
            }
            throw new CmsException(new CmsMessageContainer(Messages.get(), "ERR_DATE_SERIES_HANDLER_EXTRACT_CONTENT_FAILED_MISSING_DATE_0"));
        }

        private I_CmsXmlContentValue getSerialDateContentValue(CmsXmlContent content, Locale locale) {
            if (null == locale && !content.getLocales().isEmpty()) {
                locale = content.getLocales().get(0);
            }
            for (I_CmsXmlContentValue value : content.getValues(locale)) {
                if (!value.getTypeName().equals("OpenCmsSerialDate")) continue;
                return value;
            }
            return null;
        }

        private String getTitle(Locale l) {
            try {
                CmsGallerySearchResult result = CmsGallerySearch.searchById(this.m_cms, this.m_contentValue.getDocument().getFile().getStructureId(), l);
                return result.getTitle();
            }
            catch (CmsException e) {
                LOG.error((Object)"Could not retrieve title of series content.", (Throwable)e);
                return "";
            }
        }

        private boolean isContainerPageLockable() {
            try {
                return this.m_cms.getLock(this.m_cms.readResource(this.m_pageContextId)).isLockableBy(this.m_cms.getRequestContext().getCurrentUser());
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to check if the container page is lockable by the current user.", (Throwable)e);
                return false;
            }
        }

        private void setInstanceDate() {
            String[] sls;
            String sl = null;
            Map<String, String> settings = this.m_elementBean.getSettings();
            if (settings.containsKey(CmsDateSeriesEditHandler.PARAM_INSTANCEDATE)) {
                sl = settings.get(CmsDateSeriesEditHandler.PARAM_INSTANCEDATE);
            } else if (this.m_requestParameters.containsKey(CmsDateSeriesEditHandler.PARAM_INSTANCEDATE) && (sls = this.m_requestParameters.get(CmsDateSeriesEditHandler.PARAM_INSTANCEDATE)) != null && sls.length > 0) {
                sl = sls[0];
            }
            if (sl != null) {
                try {
                    long l = Long.parseLong(sl);
                    Date d = new Date(l);
                    if (!this.m_series.getDates().contains(d)) {
                        throw new Exception("Instance date is not a date of the series.");
                    }
                    this.m_instanceDate = d;
                }
                catch (Exception e) {
                    LOG.error((Object)"Could not read valid date from setting or request parameter \"instancedate\".", (Throwable)e);
                }
            }
        }
    }
}

