/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.CmsDefaultPageEditor;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsSimplePageEditor
extends CmsDefaultPageEditor {
    private static final String EDITOR_TYPE = "simplehtml";
    private static final Log LOG = CmsLog.getLog(CmsSimplePageEditor.class);

    public CmsSimplePageEditor(CmsJspActionElement jsp) {
        super(jsp);
    }

    @Override
    public String getEditorResourceUri() {
        return CmsSimplePageEditor.getSkinUri() + "editors/simplehtml/";
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        block40: {
            this.fillParamValues(request);
            this.setParamDialogtype(EDITOR_TYPE);
            if (this.getParamTempfile() != null && !"null".equals(this.getParamTempfile())) {
                try {
                    this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
                    this.m_page = CmsXmlPageFactory.unmarshal(this.getCms(), this.m_file);
                }
                catch (CmsException e) {
                    if (e instanceof CmsVfsResourceNotFoundException) {
                        try {
                            this.setParamTempfile(this.createTempFile());
                            this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
                            this.m_page = CmsXmlPageFactory.unmarshal(this.getCms(), this.m_file);
                        }
                        catch (CmsException e1) {
                            try {
                                this.showErrorPage(this, e1);
                                break block40;
                            }
                            catch (JspException exc) {
                                if (LOG.isInfoEnabled()) {
                                    LOG.info((Object)exc);
                                }
                                break block40;
                            }
                        }
                    }
                    try {
                        this.showErrorPage(this, e);
                    }
                    catch (JspException exc) {
                        if (!LOG.isInfoEnabled()) break block40;
                        LOG.info((Object)exc);
                    }
                }
            }
        }
        if ("save".equals(this.getParamAction())) {
            this.setAction(121);
        } else if ("saveexit".equals(this.getParamAction())) {
            this.setAction(123);
        } else if ("saveaction".equals(this.getParamAction())) {
            block41: {
                this.setAction(130);
                try {
                    this.actionDirectEdit();
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) break block41;
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.setAction(122);
        } else if ("exit".equals(this.getParamAction())) {
            this.setAction(122);
        } else {
            if ("closebrowser".equals(this.getParamAction())) {
                this.actionClear(true);
                return;
            }
            if ("deletelocale".equals(this.getParamAction())) {
                this.setAction(140);
            } else if ("changeelement".equals(this.getParamAction())) {
                this.setAction(125);
                this.actionChangeBodyElement();
                this.prepareContent(false);
            } else if ("cleanup".equals(this.getParamAction())) {
                this.setAction(125);
                this.actionCleanupBodyElement();
                this.prepareContent(false);
            } else if ("show".equals(this.getParamAction())) {
                this.setAction(125);
                this.prepareContent(false);
            } else if ("preview".equals(this.getParamAction())) {
                this.setAction(126);
            } else {
                block42: {
                    this.setAction(0);
                    try {
                        if (Boolean.valueOf(this.getParamDirectedit()).booleanValue()) {
                            this.checkLock(this.getParamResource(), CmsLockType.TEMPORARY);
                        } else {
                            this.checkLock(this.getParamResource());
                        }
                        this.setParamTempfile(this.createTempFile());
                        this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
                        this.m_page = CmsXmlPageFactory.unmarshal(this.getCms(), this.m_file);
                    }
                    catch (CmsException e) {
                        try {
                            this.showErrorPage(this, e);
                            return;
                        }
                        catch (JspException exc) {
                            if (!LOG.isInfoEnabled()) break block42;
                            LOG.info((Object)exc);
                        }
                    }
                }
                if (this.getParamElementlanguage() == null) {
                    this.initBodyElementLanguage();
                }
                if (this.getParamElementname() == null) {
                    this.initBodyElementName(null);
                }
                this.initContent();
                this.prepareContent(false);
            }
        }
    }

    @Override
    protected String prepareContent(boolean save) {
        String content = this.getParamContent().trim();
        content = CmsEncoder.adjustHtmlEncoding(content, this.getFileEncoding());
        if (!save) {
            this.setParamContent(content);
        }
        return content;
    }
}

