/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.loader.CmsTemplateContextManager;
import org.opencms.loader.I_CmsTemplateContextProvider;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.CmsXmlContentEditor;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.workplace.editors.Messages;

public class CmsEditorCssHandlerDefault
implements I_CmsEditorCssHandler {
    private static final Log LOG = CmsLog.getLog(CmsEditorCssHandlerDefault.class);
    public static final String ATTR_TEMPLATE_EDITOR_CSS = "template.editor.css";
    public static final String ATTRIBUTE_EDITOR_STYLESHEET = "cms-editor-stylesheet";

    @Override
    public String getUriStyleSheet(CmsObject cms, String editedResourcePath) {
        String editContext = (String)cms.getRequestContext().getAttribute(CmsXmlContentEditor.ATTRIBUTE_EDITCONTEXT);
        String result = "";
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(editContext)) {
            result = this.internalGetUriStyleSheet(cms, editContext);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = this.internalGetUriStyleSheet(cms, editedResourcePath);
        }
        return result;
    }

    @Override
    public boolean matches(CmsObject cms, String editedResourcePath) {
        return true;
    }

    private String internalGetUriStyleSheet(CmsObject cms, String editedResourcePath) {
        String result;
        block12: {
            if (editedResourcePath == null) {
                return "";
            }
            result = "";
            Object attr = cms.getRequestContext().getAttribute(ATTRIBUTE_EDITOR_STYLESHEET);
            if (attr instanceof String) {
                String editorStylesheet = (String)attr;
                return editorStylesheet;
            }
            try {
                CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(cms, cms.getRequestContext().addSiteRoot(editedResourcePath));
                String cssPathFromSitemapConfig = config.getAttribute(ATTR_TEMPLATE_EDITOR_CSS, null);
                if (cssPathFromSitemapConfig != null && cms.existsResource(cssPathFromSitemapConfig)) {
                    return cssPathFromSitemapConfig;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                String templatePath;
                block11: {
                    templatePath = "";
                    try {
                        String providerResult;
                        I_CmsTemplateContextProvider provider;
                        templatePath = cms.readPropertyObject(editedResourcePath, "template", true).getValue("");
                        if (CmsTemplateContextManager.isProvider(templatePath) && (provider = OpenCms.getTemplateContextManager().getTemplateContextProvider(templatePath)) != null && (providerResult = provider.getEditorStyleSheet(cms, editedResourcePath)) != null) {
                            return providerResult;
                        }
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) break block11;
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_READ_TEMPLATE_PROP_FAILED_0"), (Throwable)e);
                    }
                }
                if (CmsStringUtil.isNotEmpty(templatePath)) {
                    result = cms.readPropertyObject(templatePath, "template", false).getValue("");
                }
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) break block12;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_READ_TEMPLATE_PROP_STYLESHEET_FAILED_0"), (Throwable)e);
            }
        }
        return result;
    }
}

