/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.CmsEditor;
import org.opencms.workplace.editors.I_CmsEditorActionHandler;

public class CmsEditorActionDefault
implements I_CmsEditorActionHandler {
    @Override
    public void editorAction(CmsEditor editor, CmsJspActionElement jsp) throws IOException, JspException {
        editor.actionSave();
        editor.actionClear(true);
        Object publishLink = jsp.link("/system/workplace/commons/publishresource.jsp");
        StringBuffer params = new StringBuffer(256);
        params.append("?").append("resource").append("=").append(editor.getParamResource());
        params.append("&").append("action").append("=").append("confirmed");
        params.append("&").append("directpublish").append("=").append(CmsStringUtil.TRUE);
        params.append("&").append("publishsiblings").append("=").append(editor.getSettings().getUserSettings().getDialogPublishSiblings());
        String pubRelated = CmsStringUtil.TRUE;
        if (OpenCms.getWorkplaceManager().getDefaultUserSettings().getPublishRelatedResources() == CmsDefaultUserSettings.PUBLISH_RELATED_RESOURCES_MODE_FALSE) {
            pubRelated = CmsStringUtil.FALSE;
        }
        params.append("&").append("relatedresources").append("=").append(pubRelated);
        params.append("&").append("title").append("=");
        params.append(CmsEncoder.escapeWBlanks(editor.key("GUI_MESSAGEBOX_TITLE_PUBLISHRESOURCE_0") + ": " + editor.getParamResource(), "UTF-8"));
        params.append("&").append("redirect").append("=").append(CmsStringUtil.TRUE);
        params.append("&").append("closelink").append("=");
        if (Boolean.valueOf(editor.getParamDirectedit()).booleanValue()) {
            String linkTarget = !"".equals(editor.getParamBacklink()) ? jsp.link(editor.getParamBacklink()) : jsp.link(editor.getParamResource());
            publishLink = (String)publishLink + params.toString() + CmsEncoder.escapeWBlanks(linkTarget, "UTF-8");
        } else {
            publishLink = CmsLinkManager.isWorkplaceLink(editor.getParamBacklink()) ? (String)publishLink + params.toString() + CmsEncoder.escapeWBlanks(jsp.link(editor.getParamBacklink()), "UTF-8") : (String)publishLink + params.toString() + CmsEncoder.escapeWBlanks(CmsVaadinUtils.getWorkplaceLink(), "UTF-8");
        }
        jsp.getResponse().sendRedirect((String)publishLink);
    }

    @Override
    public String getButtonName() {
        return "GUI_EXPLORER_CONTEXT_PUBLISH_0";
    }

    @Override
    public String getButtonUrl(CmsJspActionElement jsp, String resourceName) {
        String button = "/system/workplace/resources/buttons/publish.png";
        if (!this.isButtonActive(jsp, resourceName)) {
            button = "/system/workplace/resources/buttons/publish_in.png";
        }
        return jsp.link(button);
    }

    @Override
    public boolean isButtonActive(CmsJspActionElement jsp, String resourceName) {
        try {
            OpenCms.getPublishManager().getPublishList(jsp.getCmsObject(), jsp.getCmsObject().readResource(resourceName, CmsResourceFilter.IGNORE_EXPIRATION), false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

