/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.CmsDialogElement;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsDialogElements
extends CmsDialog {
    public static final int ACTION_UPDATE_ELEMENTS = 210;
    public static final String DIALOG_TYPE = "elementselector";
    public static final String DIALOG_UPDATE_ELEMENTS = "updateelements";
    public static final String PREFIX_PARAM_BODY = "element-";
    private static final Log LOG = CmsLog.getLog(CmsDialogElements.class);
    private String m_changeElement = "";
    private List<CmsDialogElement> m_elementList;
    private Locale m_elementLocale;
    private String m_paramElementlanguage;
    private String m_paramElementname;
    private String m_paramTempFile;

    public CmsDialogElements(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDialogElements(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
        this.m_changeElement = "";
    }

    public static List<CmsDialogElement> computeElements(CmsObject cms, CmsXmlPage xmlPage, String xmlPageUri, Locale locale) {
        String currentTemplate;
        ArrayList<CmsDialogElement> result;
        block12: {
            result = new ArrayList<CmsDialogElement>();
            if (xmlPage != null) {
                List<String> elementNames = xmlPage.getNames(locale);
                for (String name : elementNames) {
                    CmsDialogElement element = new CmsDialogElement(name, null, false, false, true);
                    result.add(element);
                }
            }
            currentTemplate = null;
            try {
                currentTemplate = cms.readPropertyObject(xmlPageUri, "template", true).getValue();
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) break block12;
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (currentTemplate != null && currentTemplate.length() > 0) {
            String elements;
            block13: {
                elements = null;
                try {
                    elements = cms.readPropertyObject(currentTemplate, "template-elements", false).getValue(null);
                }
                catch (CmsException e) {
                    if (!LOG.isWarnEnabled()) break block13;
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (elements != null) {
                List<String> tokens = CmsStringUtil.splitAsList(elements, ',', true);
                for (String currentElement : tokens) {
                    CmsDialogElement element;
                    String niceName = null;
                    boolean mandatory = false;
                    int sepIndex = currentElement.indexOf("|");
                    if (sepIndex != -1) {
                        niceName = currentElement.substring(sepIndex + 1);
                        currentElement = currentElement.substring(0, sepIndex);
                    }
                    if (currentElement.endsWith("*")) {
                        mandatory = true;
                        currentElement = currentElement.substring(0, currentElement.length() - 1);
                    }
                    if (result.contains(element = new CmsDialogElement(currentElement, niceName, mandatory, true, false))) {
                        element.setExisting(true);
                        result.remove(element);
                    }
                    result.add(element);
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    public static List<CmsDialogElement> computeElements(CmsObject cms, String xmlPageUri, Locale locale) {
        CmsXmlPage page = null;
        try {
            CmsFile pageFile = cms.readFile(xmlPageUri, CmsResourceFilter.IGNORE_EXPIRATION);
            page = CmsXmlPageFactory.unmarshal(cms, pageFile);
        }
        catch (CmsException e) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_READ_XMLPAGE_FAILED_1", xmlPageUri), (Throwable)e);
        }
        return CmsDialogElements.computeElements(cms, page, xmlPageUri, locale);
    }

    public void actionUpdateElements() throws JspException {
        try {
            List<CmsDialogElement> elementList = this.computeElements();
            CmsFile file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.IGNORE_EXPIRATION);
            CmsXmlPage page = CmsXmlPageFactory.unmarshal(this.getCms(), file);
            boolean foundMandatory = false;
            this.m_changeElement = "";
            for (CmsDialogElement element : elementList) {
                if (element.isMandantory() || element.getName().equals(this.getParamElementname()) || Boolean.valueOf(this.getJsp().getRequest().getParameter(PREFIX_PARAM_BODY + element.getName())).booleanValue()) {
                    if (!element.isExisting()) {
                        page.addValue(element.getName(), this.getElementLocale());
                    }
                    page.setEnabled(element.getName(), this.getElementLocale(), true);
                    if (!element.isMandantory() || foundMandatory) continue;
                    this.m_changeElement = element.getName();
                    foundMandatory = true;
                    continue;
                }
                if (!element.isExisting()) continue;
                page.removeValue(element.getName(), this.getElementLocale());
            }
            file.setContents(page.marshal());
            this.getCms().writeFile(file);
            if (page.isEnabled(this.getParamElementname(), this.getElementLocale())) {
                this.m_changeElement = this.getParamElementname();
            } else if (!foundMandatory && elementList.size() > 0) {
                this.m_changeElement = elementList.get(0).getName();
            }
        }
        catch (Throwable e) {
            this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_UPDATE_ELEMENTS_0"));
            this.includeErrorpage(this, e);
        }
    }

    public String buildElementList() {
        StringBuffer retValue;
        block5: {
            retValue = new StringBuffer(512);
            retValue.append("<table border=\"0\">\n");
            retValue.append("<tr>\n");
            retValue.append("\t<td class=\"textbold\" unselectable=\"on\">" + this.key("GUI_EDITOR_DIALOG_ELEMENTS_PAGEELEMENT_0") + "</td>\n");
            retValue.append("\t<td class=\"textbold\" unselectable=\"on\">&nbsp;&nbsp;" + this.key("GUI_EDITOR_DIALOG_ELEMENTS_ENABLED_0") + "&nbsp;&nbsp;</td>\n");
            retValue.append("</tr>\n");
            retValue.append("<tr><td colspan=\"2\"><span style=\"height: 6px;\"></span></td></tr>\n");
            try {
                List<CmsDialogElement> elementList = this.computeElements();
                CmsFile file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.IGNORE_EXPIRATION);
                CmsXmlPage page = CmsXmlPageFactory.unmarshal(this.getCms(), file);
                for (CmsDialogElement element : elementList) {
                    retValue.append("<tr>\n");
                    retValue.append("\t<td style=\"white-space: nowrap;\" unselectable=\"on\">" + element.getNiceName());
                    retValue.append("</td>\n");
                    retValue.append("\t<td class=\"textcenter\" unselectable=\"on\"><input type=\"checkbox\" name=\"");
                    retValue.append(PREFIX_PARAM_BODY);
                    retValue.append(element.getName());
                    retValue.append("\" value=\"true\"");
                    if (!page.hasValue(element.getName(), this.getElementLocale()) && element.isMandantory() || page.isEnabled(element.getName(), this.getElementLocale())) {
                        retValue.append(" checked=\"checked\"");
                    }
                    if (element.isMandantory() || element.getName().equals(this.getParamElementname())) {
                        retValue.append(" disabled=\"disabled\"");
                    }
                    retValue.append(">");
                    retValue.append("<script >registerElement(\"");
                    retValue.append(element.getName());
                    retValue.append("\", ");
                    retValue.append(page.isEnabled(element.getName(), this.getElementLocale()));
                    retValue.append(");</script>");
                    retValue.append("</td>\n");
                    retValue.append("</tr>\n");
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block5;
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        retValue.append("</table>\n");
        return retValue.toString();
    }

    public List<CmsDialogElement> computeElements() {
        if (this.m_elementList == null) {
            this.m_elementList = CmsDialogElements.computeElements(this.getCms(), this.getParamTempfile(), this.getElementLocale());
        }
        return this.m_elementList;
    }

    public String getChangeElement() {
        return this.m_changeElement;
    }

    public Locale getElementLocale() {
        if (this.m_elementLocale == null) {
            this.m_elementLocale = CmsLocaleManager.getLocale(this.getParamElementlanguage());
        }
        return this.m_elementLocale;
    }

    public String getParamElementlanguage() {
        return this.m_paramElementlanguage;
    }

    public String getParamElementname() {
        return this.m_paramElementname;
    }

    public String getParamTempfile() {
        return this.m_paramTempFile;
    }

    public void setParamElementlanguage(String elementLanguage) {
        this.m_paramElementlanguage = elementLanguage;
    }

    public void setParamElementname(String elementName) {
        this.m_paramElementname = elementName;
    }

    public void setParamTempfile(String fileName) {
        this.m_paramTempFile = fileName;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_UPDATE_ELEMENTS.equals(this.getParamAction())) {
            this.setAction(210);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_EDITOR_DIALOG_ELEMENTS_TITLE_1", new Object[]{CmsResource.getName(this.getParamResource())}));
        }
    }
}

