/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Collection;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.opencms.acacia.shared.A_CmsSerialDateValue;
import org.opencms.acacia.shared.CmsSerialDateUtil;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.serialdate.CmsSerialDateBeanFactory;
import org.opencms.widgets.serialdate.Messages;

public class CmsSerialDateValue
extends A_CmsSerialDateValue {
    private static final Log LOG = CmsLog.getLog(CmsSerialDateValue.class);
    private boolean m_parsingFailed;

    public CmsSerialDateValue() {
        this.setDefaultValue();
    }

    public CmsSerialDateValue(String value) {
        block5: {
            if (null != value && !value.isEmpty()) {
                try {
                    JSONObject json = new JSONObject(value);
                    this.setStart(this.readOptionalDate(json, "from"));
                    this.setEnd(this.readOptionalDate(json, "to"));
                    this.setWholeDay(this.readOptionalBoolean(json, "wholeday"));
                    JSONObject patternJson = json.getJSONObject("pattern");
                    this.readPattern(patternJson);
                    this.setExceptions(this.readDates(this.readOptionalArray(json, "exceptions")));
                    this.setSeriesEndDate(this.readOptionalDate(json, "enddate"));
                    this.setOccurrences(this.readOptionalInt(json, "occurrences"));
                    this.setDerivedEndType();
                    this.setCurrentTillEnd(this.readOptionalBoolean(json, "currenttillend"));
                    this.setParentSeriesId(this.readOptionalUUID(json, "parentseries"));
                }
                catch (JSONException e) {
                    this.setDefaultValue();
                    Date d = CmsJspElFunctions.convertDate(value);
                    if (d.getTime() == 0L) {
                        this.m_parsingFailed = true;
                        break block5;
                    }
                    this.setStart(d);
                }
            } else {
                this.setDefaultValue();
            }
        }
    }

    public JSONObject toJson() {
        try {
            JSONObject result = new JSONObject();
            if (null != this.getStart()) {
                result.put("from", this.dateToJson(this.getStart()));
            }
            if (null != this.getEnd()) {
                result.put("to", this.dateToJson(this.getEnd()));
            }
            if (this.isWholeDay()) {
                result.put("wholeday", true);
            }
            JSONObject pattern = this.patternToJson();
            result.put("pattern", pattern);
            SortedSet<Date> exceptions = this.getExceptions();
            if (!exceptions.isEmpty()) {
                result.put("exceptions", this.datesToJson(exceptions));
            }
            switch (this.getEndType()) {
                case DATE: {
                    result.put("enddate", this.dateToJson(this.getSeriesEndDate()));
                    break;
                }
                case TIMES: {
                    result.put("occurrences", String.valueOf(this.getOccurrences()));
                    break;
                }
            }
            if (!this.isCurrentTillEnd()) {
                result.put("currenttillend", false);
            }
            if (null != this.getParentSeriesId()) {
                result.put("parentseries", this.getParentSeriesId().getStringValue());
            }
            return result;
        }
        catch (JSONException e) {
            LOG.error((Object)"Could not convert Serial date value to JSON.", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        JSONObject json = this.toJson();
        return null != json ? json.toString() : "";
    }

    public CmsMessageContainer validateWithMessage() {
        if (this.m_parsingFailed) {
            return Messages.get().container("ERR_SERIALDATE_INVALID_VALUE_0");
        }
        if (!this.isStartSet()) {
            return Messages.get().container("ERR_SERIALDATE_START_MISSING_0");
        }
        if (!this.isEndValid()) {
            return Messages.get().container("ERR_SERIALDATE_END_BEFORE_START_0");
        }
        String key = this.validatePattern();
        if (null != key) {
            return Messages.get().container(key);
        }
        key = this.validateDuration();
        if (null != key) {
            return Messages.get().container(key);
        }
        if (this.hasTooManyEvents()) {
            return Messages.get().container("ERR_SERIALDATE_TOO_MANY_EVENTS_1", CmsSerialDateUtil.getMaxEvents());
        }
        return null;
    }

    private JSONArray datesToJson(Collection<Date> individualDates) {
        if (null != individualDates) {
            JSONArray result = new JSONArray();
            for (Date d : individualDates) {
                result.put(this.dateToJson(d));
            }
            return result;
        }
        return null;
    }

    private String dateToJson(Date d) {
        return Long.toString(d.getTime());
    }

    private boolean hasTooManyEvents() {
        return CmsSerialDateBeanFactory.createSerialDateBean(this).hasTooManyDates();
    }

    private JSONObject patternToJson() throws JSONException {
        JSONObject pattern = new JSONObject();
        if (null != this.getPatternType()) {
            pattern.putOpt("type", this.getPatternType().toString());
            switch (this.getPatternType()) {
                case DAILY: {
                    if (this.isEveryWorkingDay()) {
                        pattern.put("everyworkingday", true);
                        break;
                    }
                    pattern.putOpt("interval", String.valueOf(this.getInterval()));
                    break;
                }
                case WEEKLY: {
                    pattern.putOpt("interval", String.valueOf(this.getInterval()));
                    pattern.putOpt("weekdays", this.toJsonStringArray(this.getWeekDays()));
                    break;
                }
                case MONTHLY: {
                    pattern.putOpt("interval", String.valueOf(this.getInterval()));
                    if (null != this.getWeekDay()) {
                        pattern.putOpt("weeks", this.toJsonStringArray(this.getWeeksOfMonth()));
                        pattern.putOpt("weekdays", this.toJsonStringArray(this.getWeekDays()));
                        break;
                    }
                    pattern.putOpt("day", "" + this.getDayOfMonth());
                    break;
                }
                case YEARLY: {
                    pattern.put("month", this.getMonth().toString());
                    if (null != this.getWeekDay()) {
                        pattern.putOpt("weeks", this.toJsonStringArray(this.getWeeksOfMonth()));
                        pattern.putOpt("weekdays", this.toJsonStringArray(this.getWeekDays()));
                        break;
                    }
                    pattern.putOpt("day", "" + this.getDayOfMonth());
                    break;
                }
                case INDIVIDUAL: {
                    pattern.putOpt("dates", this.datesToJson(this.getIndividualDates()));
                    break;
                }
            }
        }
        return pattern;
    }

    private SortedSet<Date> readDates(JSONArray array) {
        if (null != array) {
            TreeSet<Date> result = new TreeSet<Date>();
            for (int i = 0; i < array.length(); ++i) {
                try {
                    long l = Long.valueOf(array.getString(i));
                    result.add(new Date(l));
                    continue;
                }
                catch (NumberFormatException | JSONException e) {
                    LOG.error((Object)"Could not read date from JSON array.", (Throwable)e);
                }
            }
            return result;
        }
        return new TreeSet<Date>();
    }

    private JSONArray readOptionalArray(JSONObject json, String key) {
        try {
            return json.getJSONArray(key);
        }
        catch (JSONException e) {
            LOG.debug((Object)"Reading optional JSON array failed. Default to provided default value.", (Throwable)e);
            return null;
        }
    }

    private Boolean readOptionalBoolean(JSONObject json, String key) {
        try {
            return json.getBoolean(key);
        }
        catch (JSONException e) {
            LOG.debug((Object)"Reading optional JSON boolean failed. Default to provided default value.", (Throwable)e);
            return null;
        }
    }

    private Date readOptionalDate(JSONObject json, String key) {
        try {
            String str = json.getString(key);
            return new Date(Long.parseLong(str));
        }
        catch (NumberFormatException | JSONException e) {
            LOG.debug((Object)"Reading optional JSON Long failed. Default to provided default value.", (Throwable)e);
            return null;
        }
    }

    private int readOptionalInt(JSONObject json, String key) {
        try {
            String str = json.getString(key);
            return Integer.valueOf(str);
        }
        catch (NumberFormatException | JSONException e) {
            LOG.debug((Object)"Reading optional JSON int failed. Default to provided default value.", (Throwable)e);
            return 0;
        }
    }

    private I_CmsSerialDateValue.Month readOptionalMonth(JSONObject json, String key) {
        try {
            String str = json.getString(key);
            return I_CmsSerialDateValue.Month.valueOf(str);
        }
        catch (IllegalArgumentException | JSONException e) {
            LOG.debug((Object)"Reading optional JSON month failed. Default to provided default value.", (Throwable)e);
            return null;
        }
    }

    private String readOptionalString(JSONObject json, String key, String defaultValue) {
        try {
            String str = json.getString(key);
            if (str != null) {
                return str;
            }
        }
        catch (JSONException e) {
            LOG.debug((Object)"Reading optional JSON string failed. Default to provided default value.", (Throwable)e);
        }
        return defaultValue;
    }

    private CmsUUID readOptionalUUID(JSONObject json, String key) {
        String id = this.readOptionalString(json, key, null);
        if (null != id) {
            try {
                CmsUUID uuid = CmsUUID.valueOf(id);
                return uuid;
            }
            catch (NumberFormatException e) {
                LOG.debug((Object)("Reading optional UUID failed. Could not convert \"" + id + "\" to a valid UUID."));
            }
        }
        return null;
    }

    private void readPattern(JSONObject patternJson) {
        this.setPatternType(this.readPatternType(patternJson));
        this.setInterval(this.readOptionalInt(patternJson, "interval"));
        this.setWeekDays(this.readWeekDays(patternJson));
        this.setDayOfMonth(this.readOptionalInt(patternJson, "day"));
        this.setEveryWorkingDay(this.readOptionalBoolean(patternJson, "everyworkingday"));
        this.setWeeksOfMonth(this.readWeeksOfMonth(patternJson));
        this.setIndividualDates(this.readDates(this.readOptionalArray(patternJson, "dates")));
        this.setMonth(this.readOptionalMonth(patternJson, "month"));
    }

    private I_CmsSerialDateValue.PatternType readPatternType(JSONObject val) {
        I_CmsSerialDateValue.PatternType patterntype;
        try {
            String str = this.readOptionalString(val, "type", "");
            patterntype = I_CmsSerialDateValue.PatternType.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)"Could not read pattern type from JSON. Default to type NONE.", (Throwable)e);
            patterntype = I_CmsSerialDateValue.PatternType.NONE;
        }
        return patterntype;
    }

    private SortedSet<I_CmsSerialDateValue.WeekDay> readWeekDays(JSONObject val) {
        try {
            JSONArray array = val.getJSONArray("weekdays");
            if (null != array) {
                TreeSet<I_CmsSerialDateValue.WeekDay> result = new TreeSet<I_CmsSerialDateValue.WeekDay>();
                for (int i = 0; i < array.length(); ++i) {
                    try {
                        result.add(I_CmsSerialDateValue.WeekDay.valueOf(array.getString(i)));
                        continue;
                    }
                    catch (IllegalArgumentException | JSONException e) {
                        LOG.error((Object)"Could not read weekday from JSON. Skipping that day.", (Throwable)e);
                    }
                }
                return result;
            }
        }
        catch (JSONException e) {
            LOG.debug((Object)"Could not read weekdays from JSON", (Throwable)e);
        }
        return new TreeSet<I_CmsSerialDateValue.WeekDay>();
    }

    private SortedSet<I_CmsSerialDateValue.WeekOfMonth> readWeeksOfMonth(JSONObject json) {
        try {
            JSONArray array = json.getJSONArray("weeks");
            if (null != array) {
                TreeSet<I_CmsSerialDateValue.WeekOfMonth> result = new TreeSet<I_CmsSerialDateValue.WeekOfMonth>();
                for (int i = 0; i < array.length(); ++i) {
                    try {
                        I_CmsSerialDateValue.WeekOfMonth week = I_CmsSerialDateValue.WeekOfMonth.valueOf(array.getString(i));
                        result.add(week);
                        continue;
                    }
                    catch (JSONException e) {
                        LOG.debug((Object)"Could not read week of month from JSON. Skipping that particular week of month.", (Throwable)e);
                    }
                }
                return result;
            }
        }
        catch (JSONException e) {
            LOG.debug((Object)"Could not read week of month information from JSON", (Throwable)e);
        }
        return new TreeSet<I_CmsSerialDateValue.WeekOfMonth>();
    }

    private JSONArray toJsonStringArray(Collection<? extends Object> collection) {
        if (null != collection) {
            JSONArray array = new JSONArray();
            for (Object object : collection) {
                array.put(String.valueOf(object));
            }
            return array;
        }
        return null;
    }

    private String validateDayOfMonth() {
        return this.isDayOfMonthValid() ? null : "ERR_SERIALDATE_INVALID_DAY_OF_MONTH_0";
    }

    private String validateDuration() {
        if (!this.isValidEndTypeForPattern()) {
            return "ERR_SERIALDATE_INVALID_END_TYPE_FOR_PATTERN_0";
        }
        switch (this.getEndType()) {
            case DATE: {
                return this.getStart().getTime() < this.getSeriesEndDate().getTime() + 86400000L ? null : "ERR_SERIALDATE_SERIES_END_BEFORE_START_0";
            }
            case TIMES: {
                return this.getOccurrences() > 0 ? null : "ERR_SERIALDATE_INVALID_OCCURRENCES_0";
            }
        }
        return null;
    }

    private String validateInterval() {
        return this.isIntervalValid() ? null : "ERR_SERIALDATE_INVALID_INTERVAL_0";
    }

    private String validateMonthSet() {
        return this.isMonthSet() ? null : "ERR_SERIALDATE_NO_MONTH_SET_0";
    }

    private String validatePattern() {
        String error = null;
        switch (this.getPatternType()) {
            case DAILY: {
                error = this.isEveryWorkingDay() ? null : this.validateInterval();
                break;
            }
            case WEEKLY: {
                error = this.validateInterval();
                if (null != error) break;
                error = this.validateWeekDaySet();
                break;
            }
            case MONTHLY: {
                error = this.validateInterval();
                if (null != error || null != (error = this.validateMonthSet())) break;
                error = this.isWeekDaySet() ? this.validateWeekOfMonthSet() : this.validateDayOfMonth();
                break;
            }
            case YEARLY: {
                error = this.isWeekDaySet() ? this.validateWeekOfMonthSet() : this.validateDayOfMonth();
                break;
            }
        }
        return error;
    }

    private String validateWeekDaySet() {
        return this.isWeekDaySet() ? null : "ERR_SERIALDATE_NO_WEEKDAY_SPECIFIED_0";
    }

    private String validateWeekOfMonthSet() {
        return this.isWeekOfMonthSet() ? null : "ERR_SERIALDATE_NO_WEEK_OF_MONTH_SPECIFIED_0";
    }
}

