/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import org.apache.commons.lang3.ArrayUtils;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.widgets.serialdate.A_CmsSerialDateBean;

public class CmsSerialDateBeanWorkingDays
extends A_CmsSerialDateBean {
    private static final int[] NON_WORKING_DAYS = new int[]{7, 1};

    public CmsSerialDateBeanWorkingDays(Date startDate, Date endDate, boolean isWholeDay, I_CmsSerialDateValue.EndType endType, Date serialEndDate, int occurrences, SortedSet<Date> exceptions) {
        super(startDate, endDate, isWholeDay, endType, serialEndDate, occurrences, exceptions);
    }

    @Override
    protected Calendar getFirstDate() {
        Calendar date = (Calendar)this.getStartDate().clone();
        if (!this.isWorkingDay(date)) {
            this.toNextDate(date);
        }
        return date;
    }

    @Override
    protected boolean isAnyDatePossible() {
        return true;
    }

    @Override
    protected void toNextDate(Calendar date) {
        do {
            date.add(5, 1);
        } while (!this.isWorkingDay(date));
    }

    private boolean isWorkingDay(Calendar date) {
        return !ArrayUtils.contains((int[])NON_WORKING_DAYS, (int)date.get(7));
    }
}

