/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.widgets.serialdate.A_CmsSerialDateBean;

public class CmsSerialDateBeanMonthlyWeeks
extends A_CmsSerialDateBean {
    private int m_interval;
    private SortedSet<I_CmsSerialDateValue.WeekOfMonth> m_weeksOfMonth;
    private I_CmsSerialDateValue.WeekDay m_weekDay;
    private Iterator<I_CmsSerialDateValue.WeekOfMonth> m_weekOfMonthIterator;

    public CmsSerialDateBeanMonthlyWeeks(Date startDate, Date endDate, boolean isWholeDay, I_CmsSerialDateValue.EndType endType, Date serialEndDate, int occurrences, SortedSet<Date> exceptions, int interval, SortedSet<I_CmsSerialDateValue.WeekOfMonth> weeksOfMonth, I_CmsSerialDateValue.WeekDay weekDay) {
        super(startDate, endDate, isWholeDay, endType, serialEndDate, occurrences, exceptions);
        this.m_interval = interval;
        this.m_weeksOfMonth = weeksOfMonth;
        this.m_weekDay = weekDay;
    }

    @Override
    protected Calendar getFirstDate() {
        this.m_weekOfMonthIterator = this.m_weeksOfMonth.iterator();
        Calendar date = (Calendar)this.getStartDate().clone();
        this.toCorrectDateWithDay(date, this.m_weekOfMonthIterator.next());
        while (date.getTimeInMillis() < this.getStartDate().getTimeInMillis()) {
            this.toNextDate(date, 1);
        }
        return date;
    }

    @Override
    protected boolean isAnyDatePossible() {
        return this.m_weeksOfMonth.size() > 0;
    }

    @Override
    protected void toNextDate(Calendar date) {
        this.toNextDate(date, this.m_interval);
    }

    private void toCorrectDateWithDay(Calendar date, I_CmsSerialDateValue.WeekOfMonth week) {
        date.set(5, 1);
        int daysToFirstWeekDayMatch = (this.m_weekDay.toInt() + 7 - date.get(7)) % 7;
        date.add(5, daysToFirstWeekDayMatch);
        int wouldBeDayOfMonth = date.get(5) + week.ordinal() * 7;
        if (wouldBeDayOfMonth > date.getActualMaximum(5)) {
            date.set(5, wouldBeDayOfMonth - 7);
        } else {
            date.set(5, wouldBeDayOfMonth);
        }
    }

    private void toNextDate(Calendar date, int interval) {
        long previousDate = date.getTimeInMillis();
        if (!this.m_weekOfMonthIterator.hasNext()) {
            date.add(2, interval);
            this.m_weekOfMonthIterator = this.m_weeksOfMonth.iterator();
        }
        this.toCorrectDateWithDay(date, this.m_weekOfMonthIterator.next());
        if (previousDate == date.getTimeInMillis()) {
            this.toNextDate(date);
        }
    }
}

