/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.widgets.serialdate.A_CmsSerialDateBean;

public class CmsSerialDateBeanMonthly
extends A_CmsSerialDateBean {
    private int m_interval;
    private int m_dayOfMonth;

    public CmsSerialDateBeanMonthly(Date startDate, Date endDate, boolean isWholeDay, I_CmsSerialDateValue.EndType endType, Date serialEndDate, int occurrences, SortedSet<Date> exceptions, int interval, int dayOfMonth) {
        super(startDate, endDate, isWholeDay, endType, serialEndDate, occurrences, exceptions);
        this.m_interval = interval;
        this.m_dayOfMonth = dayOfMonth;
    }

    @Override
    protected Calendar getFirstDate() {
        Calendar date = (Calendar)this.getStartDate().clone();
        if (date.get(5) > this.m_dayOfMonth) {
            date.set(5, 1);
            date.add(2, 1);
        }
        this.setCorrectDay(date);
        return date;
    }

    @Override
    protected boolean isAnyDatePossible() {
        return true;
    }

    @Override
    protected void toNextDate(Calendar date) {
        date.set(5, 1);
        date.add(2, this.m_interval);
        this.setCorrectDay(date);
    }

    private boolean monthHasNotDay(Calendar date) {
        return date.getActualMaximum(5) < this.m_dayOfMonth;
    }

    private void setCorrectDay(Calendar date) {
        if (this.monthHasNotDay(date)) {
            date.set(5, date.getActualMaximum(5));
        } else {
            date.set(5, this.m_dayOfMonth);
        }
    }
}

