/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.dataview;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CmsDataViewFilter {
    private String m_id;
    private LinkedHashMap<String, String> m_options;
    private String m_value;
    private String m_niceName;
    private String m_helpText;

    public CmsDataViewFilter(String id, String niceName, String helpText, LinkedHashMap<String, String> options, String value) {
        this.m_options = new LinkedHashMap<String, String>(options);
        this.m_id = id;
        this.m_niceName = niceName;
        this.m_value = value;
        this.m_helpText = helpText;
        if (!this.m_options.containsKey(value)) {
            throw new IllegalArgumentException("Option value " + value + " not found in " + String.valueOf(options));
        }
    }

    public CmsDataViewFilter copy() {
        return new CmsDataViewFilter(this.m_id, this.m_niceName, this.m_helpText, this.m_options, this.m_value);
    }

    public CmsDataViewFilter copyWithValue(String value) {
        return new CmsDataViewFilter(this.m_id, this.m_niceName, this.m_helpText, this.m_options, value);
    }

    public boolean equals(Object other) {
        if (!(other instanceof CmsDataViewFilter)) {
            return false;
        }
        CmsDataViewFilter otherFilter = (CmsDataViewFilter)other;
        LinkedHashMap<String, String> otherOptions = otherFilter.m_options;
        if (!this.m_id.equals(otherFilter.m_id)) {
            return false;
        }
        if (!this.m_value.equals(otherFilter.m_value)) {
            return false;
        }
        if (otherOptions.size() != this.m_options.size()) {
            return false;
        }
        Iterator<Map.Entry<String, String>> iter1 = this.m_options.entrySet().iterator();
        Iterator<Map.Entry<String, String>> iter2 = otherOptions.entrySet().iterator();
        while (iter1.hasNext()) {
            Map.Entry<String, String> entry1 = iter1.next();
            Map.Entry<String, String> entry2 = iter2.next();
            boolean equalKey = Objects.equal((Object)entry1.getKey(), (Object)entry2.getKey());
            boolean equalValue = Objects.equal((Object)entry1.getValue(), (Object)entry2.getValue());
            if (equalKey && equalValue) continue;
            return false;
        }
        return true;
    }

    public String getHelpText() {
        return this.m_helpText;
    }

    public String getId() {
        return this.m_id;
    }

    public String getNiceName() {
        return this.m_niceName;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.m_options);
    }

    public String getValue() {
        return this.m_value;
    }

    public int hashCode() {
        return 31 * this.m_id.hashCode() + 961 * this.m_options.hashCode() + this.m_value.hashCode();
    }
}

