/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;

public class CmsUserWidget
extends CmsSelectWidget {
    public static final String CONFIGURATION_FLAGS = "flags";
    public static final String CONFIGURATION_GROUP = "group";
    private static final Log LOG = CmsLog.getLog(CmsUserWidget.class);
    private Integer m_flags;
    private String m_groupName;

    public CmsUserWidget() {
        this("");
    }

    public CmsUserWidget(Integer flags, String groupName) {
        this.m_flags = flags;
        this.m_groupName = groupName;
    }

    public CmsUserWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration() {
        StringBuffer result = new StringBuffer(8);
        if (this.m_flags != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_FLAGS);
            result.append("=");
            result.append(this.m_flags);
        }
        if (this.m_groupName != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_GROUP);
            result.append("=");
            result.append(this.m_groupName);
        }
        return result.toString();
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/userselector.js"));
        return result.toString();
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(128);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\"><tr><td style=\"width: 100%;\">");
        result.append("<input style=\"width: 99%;\" class=\"xmlInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        result.append(param.getStringValue(cms));
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        StringBuffer buttonJs = new StringBuffer(8);
        buttonJs.append("javascript:openUserWin('");
        buttonJs.append(OpenCms.getSystemInfo().getOpenCmsContext());
        buttonJs.append("/system/workplace/commons/user_selection.jsp");
        buttonJs.append("','EDITOR',  '");
        buttonJs.append(id);
        buttonJs.append("', document, ");
        if (this.m_flags != null) {
            buttonJs.append("'");
            buttonJs.append(this.m_flags);
            buttonJs.append("'");
        } else {
            buttonJs.append("null");
        }
        buttonJs.append(", ");
        if (this.m_groupName != null) {
            buttonJs.append("'");
            buttonJs.append(this.m_groupName);
            buttonJs.append("'");
        } else {
            buttonJs.append("null");
        }
        buttonJs.append(");");
        result.append(widgetDialog.button(buttonJs.toString(), null, "user", "GUI_DIALOG_BUTTON_SEARCH_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        return result.toString();
    }

    public Integer getFlags() {
        return this.m_flags;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    @Override
    public String getWidgetName() {
        return CmsSelectWidget.class.getName();
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsUserWidget(this.getConfiguration());
    }

    @Override
    public void setConfiguration(String configuration) {
        this.m_groupName = null;
        this.m_flags = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            int groupIndex;
            int flagsIndex = configuration.indexOf(CONFIGURATION_FLAGS);
            if (flagsIndex != -1) {
                String flags = configuration.substring(CONFIGURATION_FLAGS.length() + 1);
                if (flags.indexOf(124) != -1) {
                    flags = flags.substring(0, flags.indexOf(124));
                }
                try {
                    this.m_flags = Integer.valueOf(flags);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((groupIndex = configuration.indexOf(CONFIGURATION_GROUP)) != -1) {
                String group = configuration.substring(CONFIGURATION_GROUP.length() + 1);
                if (group.indexOf(124) != -1) {
                    group = group.substring(0, group.indexOf(124));
                }
                this.m_groupName = group;
            }
        }
        super.setConfiguration(configuration);
    }

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        ArrayList<CmsSelectWidgetOption> options = new ArrayList<CmsSelectWidgetOption>();
        options.add(new CmsSelectWidgetOption("", true, ""));
        try {
            List<CmsUser> users = this.m_groupName != null ? cms.getUsersOfGroup(this.m_groupName) : OpenCms.getOrgUnitManager().getUsers(cms, "/", true);
            for (CmsUser user : users) {
                CmsSelectWidgetOption option = new CmsSelectWidgetOption(user.getName(), false, user.getFullName());
                options.add(option);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return options;
    }
}

