/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsSelectWidget;
import org.opencms.widgets.CmsComboWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;

public class CmsOrgUnitWidget
extends A_CmsSelectWidget
implements I_CmsADEWidget {
    public static final String CONFIGURATION_ROLE = "role";
    private static final Log LOG = CmsLog.getLog(CmsOrgUnitWidget.class);
    private CmsRole m_role;

    public CmsOrgUnitWidget() {
        this("");
    }

    public CmsOrgUnitWidget(CmsRole role) {
        this.m_role = role;
    }

    public CmsOrgUnitWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration() {
        StringBuffer result = new StringBuffer(8);
        if (this.m_role != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_ROLE);
            result.append("=");
            result.append(this.m_role.getGroupName());
        }
        return result.toString();
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/orgunitselector.js"));
        return result.toString();
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(128);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\"><tr><td style=\"width: 100%;\">");
        result.append("<input style=\"width: 99%;\" class=\"xmlInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        result.append(param.getStringValue(cms));
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        StringBuffer buttonJs = new StringBuffer(8);
        buttonJs.append("javascript:openOrgUnitWin('");
        buttonJs.append(OpenCms.getSystemInfo().getOpenCmsContext());
        buttonJs.append("/system/workplace/commons/orgunit_selection.jsp");
        buttonJs.append("','EDITOR',  '");
        buttonJs.append(id);
        buttonJs.append("', document, ");
        if (this.m_role != null) {
            buttonJs.append("'");
            buttonJs.append(this.m_role.getGroupName());
            buttonJs.append("'");
        } else {
            buttonJs.append("null");
        }
        buttonJs.append(");");
        result.append(widgetDialog.button(buttonJs.toString(), null, "orgunit", "GUI_DIALOG_BUTTON_SEARCH_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        return result.toString();
    }

    public CmsRole getRole() {
        return this.m_role;
    }

    @Override
    public String getWidgetName() {
        return CmsComboWidget.class.getName();
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsOrgUnitWidget(this.getConfiguration());
    }

    @Override
    public void setConfiguration(String configuration) {
        int roleIndex;
        this.m_role = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration) && (roleIndex = configuration.indexOf(CONFIGURATION_ROLE)) != -1) {
            String groupName = configuration.substring(CONFIGURATION_ROLE.length() + 1);
            if (groupName.indexOf(124) != -1) {
                groupName = groupName.substring(0, groupName.indexOf(124));
            }
            this.m_role = CmsRole.valueOfGroupName(groupName);
        }
        super.setConfiguration(configuration);
    }

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        ArrayList<CmsOrganizationalUnit> orgUnits = new ArrayList<CmsOrganizationalUnit>();
        try {
            if (this.m_role != null) {
                orgUnits.addAll(OpenCms.getRoleManager().getOrgUnitsForRole(cms, this.m_role.forOrgUnit(""), true));
            } else {
                orgUnits.addAll(OpenCms.getOrgUnitManager().getOrganizationalUnits(cms, "", true));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        for (CmsOrganizationalUnit ou : orgUnits) {
            CmsSelectWidgetOption option = new CmsSelectWidgetOption(ou.getName(), false, ou.getDisplayName(locale));
            result.add(option);
        }
        this.setSelectOptions(result);
        return result;
    }
}

